/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class BaseFlex {
    public static final String base64Table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    public static final String url64Table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";
    public static final char base64Pad = '=';
    public static final char url64Pad = '~';

    private BaseFlex() {
    }

    public static String encodeBase64(String in) {
        return BaseFlex.encode(base64Table, '=', in);
    }

    public static String decodeBase64(String in) {
        return BaseFlex.decode(base64Table, '=', in);
    }

    public static String encode(String encodingTable, char padChar, String srcString) {
        try {
            return BaseFlex.encode(encodingTable, padChar, srcString.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("System should have UTF8: " + e.toString());
        }
    }

    public static String encode(String encodingTable, char padChar, byte[] src) {
        if (encodingTable == null || encodingTable.length() == 0) {
            return "";
        }
        if (src == null || src.length == 0) {
            return "";
        }
        int srcsize = src.length;
        int tbllen = encodingTable.length();
        if (tbllen != 2 && tbllen != 4 && tbllen != 8 && tbllen != 16 && tbllen != 32 && tbllen != 64 && tbllen != 128) {
            return "";
        }
        StringBuffer result = new StringBuffer(srcsize);
        int tblpos = 0;
        int bitpos = 0;
        int bitsread = -1;
        int inpos = 0;
        byte pos = 0;
        while (inpos <= srcsize) {
            if (bitsread < 0) {
                if (inpos >= srcsize) break;
                pos = src[inpos++];
                bitsread = 7;
            }
            tblpos = 0;
            bitpos = tbllen / 2;
            while (bitpos > 0) {
                if (bitsread < 0) {
                    pos = inpos < srcsize ? src[inpos] : (byte)0;
                    ++inpos;
                    bitsread = 7;
                }
                if ((1 << bitsread & pos) != 0) {
                    tblpos += bitpos;
                }
                bitpos /= 2;
                --bitsread;
            }
            result.append(encodingTable.charAt(tblpos));
        }
        while (bitsread != -1) {
            bitpos = tbllen / 2;
            while (bitpos > 0) {
                if (bitsread < 0) {
                    bitsread = 7;
                }
                bitpos /= 2;
                --bitsread;
            }
            result.append(padChar);
        }
        return result.toString();
    }

    public static byte[] decodeToBytes(String decodingTable, char padChar, String srcString) {
        int j;
        int[] x;
        int shift;
        if (decodingTable == null || decodingTable.length() == 0 || srcString == null || srcString.length() == 0) {
            return new byte[0];
        }
        int srcsize = srcString.length();
        int tbllen = decodingTable.length();
        for (shift = 1; shift < 8 && 1 << shift != tbllen; ++shift) {
        }
        if (shift == 8) {
            throw new IllegalArgumentException("Deconding table size must be a power of two");
        }
        char[] decTable = new char[256];
        for (int i = 0; i < tbllen; ++i) {
            if (decTable[decodingTable.charAt(i)] > '\u0000') {
                throw new IllegalArgumentException("Multiply defined codes are not allowed.");
            }
            decTable[decodingTable.charAt((int)i)] = (char)i;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream(srcsize);
        int inpos = 0;
        char pos = srcString.charAt(inpos++);
        long incoming = 0L;
        int bitsread = 0;
        while (inpos <= srcsize) {
            incoming = (incoming << shift) + (long)decTable[pos];
            if ((bitsread += shift) % 8 == 0) {
                x = new int[8];
                for (j = 0; j < bitsread >> 3; ++j) {
                    x[j] = (int)(incoming & 0xFFL);
                    incoming >>= 8;
                }
                bitsread = 0;
                while (j > 0) {
                    if (x[--j] == 0) continue;
                    result.write(x[j]);
                }
            }
            pos = inpos < srcsize ? srcString.charAt(inpos) : (char)'\u0000';
            ++inpos;
        }
        if (bitsread > 0) {
            x = new int[8];
            incoming >>= bitsread % 8;
            for (j = 0; j < bitsread >> 3; ++j) {
                x[j] = (int)(incoming & 0xFFL);
                incoming >>= 8;
            }
            while (j > 0) {
                if (x[--j] == 0) continue;
                result.write(x[j]);
            }
        }
        return result.toByteArray();
    }

    public static String decode(String decodingTable, char padChar, String srcString) {
        try {
            return new String(BaseFlex.decodeToBytes(decodingTable, padChar, srcString), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("System should have UTF8: " + e.toString());
        }
    }
}

