/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import com.day.util.Blob;
import com.day.util.BlobFactory;
import com.day.util.BlobImpl;
import com.day.util.BlobOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BlobFactoryImpl
implements BlobFactory {
    private final Set<BlobImpl> blobs = new HashSet<BlobImpl>();
    private final File tmpDirectory;

    public BlobFactoryImpl(File tmpDirectory) {
        this.tmpDirectory = tmpDirectory;
    }

    public Blob create(byte[] bytes, int off, int len) throws IOException {
        byte[] data = new byte[len];
        System.arraycopy(bytes, off, data, 0, len);
        return this.register(new BlobImpl(this, data));
    }

    public Blob create(byte[] bytes) throws IOException {
        return this.create(bytes, 0, bytes.length);
    }

    public BlobOutputStream createOutputStream() throws IOException {
        return new BlobOutputStream(this);
    }

    BlobImpl register(BlobImpl blob) {
        this.blobs.add(blob);
        return blob;
    }

    void discard(BlobImpl blob) throws IOException {
        blob.discard();
    }

    File allocateTmpFile() throws IOException {
        return File.createTempFile("__crx", ".dat", this.tmpDirectory);
    }

    void freeTmpFile(File file) throws IOException {
        file.deleteOnExit();
        file.delete();
    }

    public void close() throws IOException {
        Iterator<BlobImpl> iter = this.blobs.iterator();
        while (iter.hasNext()) {
            iter.next().close();
            iter.remove();
        }
    }
}

