/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheMap {
    private LRUMap cache;
    private long expiration;
    private static final long DEFAULT_EXPIRATION = 600L;
    private static final int DEFAULT_SIZE = 1000;
    private static final Logger log = LoggerFactory.getLogger(CacheMap.class);

    public CacheMap() {
        this(600L, 1000);
    }

    public CacheMap(long expiration) {
        this(expiration, 1000);
    }

    public CacheMap(long expiration, int maxSize) {
        this.cache = new LRUMap(maxSize);
        this.setExpiration(expiration);
    }

    public void setExpiration(long expiration) {
        this.clear();
        this.expiration = expiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setMaxSize(int maxSize) {
        if (this.cache.maxSize() != maxSize) {
            this.clear();
            this.cache = new LRUMap(maxSize);
        }
    }

    public int getMaxSize() {
        return this.cache.maxSize();
    }

    public void close() {
        this.clear();
    }

    public boolean isEmpty() {
        return this.entries().isEmpty();
    }

    public boolean containsKey(Object key) {
        return null != this.get(key);
    }

    public void cleanUp() {
        if (!this.cache.isEmpty()) {
            Object[] keys = this.cache.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                CacheEntry entry = (CacheEntry)this.cache.get(keys[i]);
                if (null == entry || entry.isValid()) continue;
                this.cache.remove(keys[i]);
            }
        }
    }

    public Set entries() {
        this.cleanUp();
        return Collections.unmodifiableSet(new HashSet(this.cache.values()));
    }

    public Object put(Object key, Object object) {
        CacheEntry entry = (CacheEntry)this.cache.put(key, (Object)new CacheEntry(object));
        return null != entry ? entry.getEntry() : null;
    }

    public Object get(Object key) {
        Object cached = null;
        if (this.cache.containsKey(key)) {
            CacheEntry entry = (CacheEntry)this.cache.get(key);
            if (entry.isValid()) {
                cached = entry.getEntry();
            } else {
                this.remove(key);
            }
        }
        return cached;
    }

    public void clear() {
        log.debug("cleared " + this.cache.size() + " objects");
        this.cache.clear();
    }

    public Object remove(Object key) {
        log.debug("removed expired value for key: " + key);
        CacheEntry entry = (CacheEntry)this.cache.remove(key);
        return null != entry ? entry.getEntry() : null;
    }

    private class CacheEntry {
        private final Object entry;
        private final long validity;

        CacheEntry(Object object) {
            this.entry = object;
            this.validity = System.currentTimeMillis() + CacheMap.this.expiration * 1000L;
        }

        public Object getEntry() {
            return this.entry;
        }

        public boolean isValid() {
            return this.validity > System.currentTimeMillis();
        }

        public long getExpiration() {
            return this.validity;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheEntry) {
                return ((CacheEntry)obj).entry.equals(this.entry);
            }
            return false;
        }

        public int hashCode() {
            return this.entry.hashCode();
        }
    }
}

