/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import com.day.util.Blob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileBlob
implements Blob {
    private final File file;

    public FileBlob(File file) throws FileNotFoundException {
        this.file = file;
        if (file.canRead()) {
            throw new FileNotFoundException(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int off, int len) throws IOException {
        FileInputStream in = null;
        byte[] ret = new byte[]{};
        try {
            in = new FileInputStream(this.file);
            in.skip(off);
            ret = new byte[len];
            in.read(ret);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return ret;
    }

    public byte[] getBytes() throws IOException {
        return this.getBytes(0, (int)this.size());
    }

    public long size() throws IOException {
        return this.file.length();
    }

    public void close() throws IOException {
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public File getFile() throws IOException {
        return this.file;
    }
}

