/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Queue {
    private static final Logger log = LoggerFactory.getLogger(Queue.class);
    private final LinkedList list = new LinkedList();
    private boolean closed;
    private final boolean unique;
    private final Object waitForEmpty = new Object();
    private final Object waitForNonEmpty = new Object();

    public Queue() {
        this(true);
    }

    public Queue(boolean unique) {
        this.unique = unique;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void enqueue(Object o) {
        if (!this.unique || !this.list.contains(o)) {
            this.list.addLast(o);
            this.notify();
            Object object = this.waitForNonEmpty;
            synchronized (object) {
                this.waitForNonEmpty.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object dequeue() throws InterruptedException {
        while (this.list.isEmpty()) {
            if (this.closed) {
                Thread.currentThread().interrupt();
            }
            this.wait();
        }
        Object o = this.list.removeFirst();
        if (this.list.isEmpty()) {
            Object object = this.waitForEmpty;
            synchronized (object) {
                this.waitForEmpty.notifyAll();
            }
        }
        return o;
    }

    public int size() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Object dequeue(long timeout) throws InterruptedException {
        if (this.closed) {
            Thread.currentThread().interrupt();
        }
        if (timeout == 0L) {
            return this.dequeue();
        }
        long waitUntil = System.currentTimeMillis() + timeout;
        while (this.list.isEmpty()) {
            long current = System.currentTimeMillis();
            if (current >= waitUntil) {
                return null;
            }
            this.wait(waitUntil - current);
            if (!this.closed) continue;
            Thread.currentThread().interrupt();
        }
        Object o = this.list.removeFirst();
        if (this.list.isEmpty()) {
            Object object = this.waitForEmpty;
            synchronized (object) {
                this.waitForEmpty.notifyAll();
            }
        }
        return o;
    }

    public synchronized boolean contains(Object filter) {
        for (Object o : this.list) {
            if (!filter.equals(o)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            this.waitUntilEmpty();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Queue queue = this;
        synchronized (queue) {
            this.closed = true;
            this.notifyAll();
        }
    }

    public final synchronized boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitUntilEmpty() throws InterruptedException {
        Object object;
        if (log.isDebugEnabled() && !this.list.isEmpty()) {
            log.debug("queue not empty: " + this + " contains " + this.list.size() + " entries");
            object = this;
            synchronized (object) {
                for (int i = 0; i < this.list.size(); ++i) {
                    log.debug("...entry " + i + ": " + this.list.get(i));
                }
            }
        }
        while (!this.list.isEmpty()) {
            object = this.waitForEmpty;
            synchronized (object) {
                this.waitForEmpty.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitUntilNonEmpty() throws InterruptedException {
        while (this.list.isEmpty()) {
            Object object = this.waitForNonEmpty;
            synchronized (object) {
                this.waitForNonEmpty.wait();
            }
        }
    }
}

