/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.mq;

import com.day.util.mq.History;
import com.day.util.mq.Message;
import com.day.util.mq.MessageFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HistoryImpl
implements History {
    private static final Logger log = LoggerFactory.getLogger(HistoryImpl.class);
    private static final String pattern = "dd.MM.yyyy HH:mm:ss";
    private static final DateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final char[] states = new char[]{'?', 'P', 'D', 'E'};
    private int[] stateCounts = new int[]{0, 0, 0, 0};
    private MessageFactory factory;
    private RandomAccessFile file;
    private File historyFile;
    private final int purgeThreshhold = 1024;
    private final LinkedList list = new LinkedList();

    public void init(MessageFactory factory, File directory, String filename) throws IOException {
        this.historyFile = new File(directory, filename);
        this.factory = factory;
        this.file = new RandomAccessFile(this.historyFile, "rw");
        while (true) {
            long position = this.file.getFilePointer();
            String line = this.file.readLine();
            if (line == null) break;
            try {
                EntryImpl entry = new EntryImpl(factory);
                entry.deserialize(line);
                entry.setPosition(position);
                this.list.addLast(entry);
                int n = entry.state;
                this.stateCounts[n] = this.stateCounts[n] + 1;
            }
            catch (IOException e) {
                log.error("Unable to deserialize entry (ignored):{}", (Object)e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryImpl[] entries() {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            return this.list.toArray(new EntryImpl[this.list.size()]);
        }
    }

    public boolean isPersistent() {
        return this.file != null;
    }

    public void delete() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.historyFile.delete();
        }
    }

    public void close() throws IOException {
        this.file.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryImpl append(Message message) {
        EntryImpl entry = new EntryImpl(message, 1, new Date());
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.addLast(entry);
            int n = entry.state;
            this.stateCounts[n] = this.stateCounts[n] + 1;
        }
        if (this.isPersistent()) {
            try {
                String line = entry.serialize();
                RandomAccessFile randomAccessFile = this.file;
                synchronized (randomAccessFile) {
                    long pos = this.file.length();
                    this.file.seek(pos);
                    this.file.writeBytes(line);
                    this.file.writeBytes("\r\n");
                    this.file.getFD().sync();
                    entry.setPosition(pos);
                }
            }
            catch (IOException e) {
                log.error("Unable to write message to history persistence: {}", (Object)e.toString());
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            return this.list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(int state) {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            if (state > this.stateCounts.length) {
                return -1;
            }
            return this.stateCounts[state];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stateChanged(EntryImpl entry) {
        if (!entry.isPersistent()) {
            return;
        }
        Object object = this.list;
        synchronized (object) {
            int prevSize = this.size();
            if (prevSize - this.size(1) > 1024) {
                ListIterator iter = this.list.listIterator();
                while (iter.hasNext()) {
                    entry = (EntryImpl)iter.next();
                    if (entry.state == 1) continue;
                    iter.remove();
                    int n = entry.state;
                    this.stateCounts[n] = this.stateCounts[n] - 1;
                }
                log.info("purged {} entries.", (Object)("" + (prevSize - this.list.size())));
                try {
                    RandomAccessFile randomAccessFile = this.file;
                    synchronized (randomAccessFile) {
                        this.file.setLength(0L);
                        iter = this.list.listIterator();
                        while (iter.hasNext()) {
                            entry = (EntryImpl)iter.next();
                            long pos = this.file.length();
                            this.file.seek(pos);
                            this.file.writeBytes(entry.serialize());
                            this.file.writeBytes("\r\n");
                            this.file.getFD().sync();
                            entry.setPosition(pos);
                        }
                    }
                }
                catch (IOException e) {
                    log.error("Unable to write message to history persistence: {}", (Object)e.toString());
                }
                return;
            }
        }
        try {
            object = this.file;
            synchronized (object) {
                this.file.seek(entry.position);
                this.file.writeBytes(entry.serialize());
                this.file.writeBytes("\r\n");
                this.file.getFD().sync();
            }
        }
        catch (IOException e) {
            log.error("Unable to update message in history persistence: {}", (Object)e.toString());
        }
    }

    private static int state(char c) {
        switch (c) {
            case 'D': {
                return 2;
            }
            case 'P': {
                return 1;
            }
            case 'E': {
                return 3;
            }
        }
        return 0;
    }

    final class EntryImpl {
        public final Message message;
        private int state;
        private Date timestamp;
        private long position = -1L;

        EntryImpl(MessageFactory factory) {
            this.message = factory.createMessage();
        }

        EntryImpl(Message message, int state, Date timestamp) {
            this.message = message;
            this.state = state;
            this.timestamp = timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String serialize() throws IOException {
            StringBuffer buffer = new StringBuffer();
            DateFormat dateFormat = fmt;
            synchronized (dateFormat) {
                buffer.append(fmt.format(this.timestamp));
            }
            buffer.append(' ');
            buffer.append(states[this.state]);
            buffer.append(' ');
            buffer.append(this.message.serialize());
            return buffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deserialize(String s) throws IOException {
            try {
                int idx = HistoryImpl.pattern.length();
                DateFormat dateFormat = fmt;
                synchronized (dateFormat) {
                    this.timestamp = fmt.parse(s.substring(0, idx));
                }
                this.state = HistoryImpl.state(s.charAt(idx + 1));
                this.message.deserialize(s.substring(idx + 3));
            }
            catch (ParseException e) {
                throw new IOException(e.getMessage());
            }
        }

        void setPosition(long position) {
            this.position = position;
        }

        public void setState(int state) {
            int[] nArray = HistoryImpl.this.stateCounts;
            int n = this.state;
            nArray[n] = nArray[n] - 1;
            this.state = state;
            int[] nArray2 = HistoryImpl.this.stateCounts;
            int n2 = state;
            nArray2[n2] = nArray2[n2] + 1;
            HistoryImpl.this.stateChanged(this);
        }

        public int getState() {
            return this.state;
        }

        public boolean isPersistent() {
            return this.position >= 0L;
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

