/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.mq;

import com.day.util.Condition;
import com.day.util.Counter;
import com.day.util.Queue;
import com.day.util.mq.Consumer;
import com.day.util.mq.History;
import com.day.util.mq.HistoryImpl;
import com.day.util.mq.Message;
import com.day.util.mq.MessageFactory;
import com.day.util.mq.MessageQueue;
import com.day.util.mq.UndeliverableException;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MessageQueueImpl
implements MessageQueue,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(MessageQueueImpl.class);
    private final String queueName;
    private Consumer consumer;
    private MessageFactory factory;
    private final Queue queue = new Queue();
    private final HistoryImpl history = new HistoryImpl();
    private final File directory;
    private final Condition flushing = new Condition();
    private final Condition purging = new Condition();
    private final Counter pending = new Counter();
    private final Object deliveryDelay = new Object();

    public MessageQueueImpl(String queueName, MessageFactory factory, File dir) throws IOException {
        this.queueName = queueName;
        this.factory = factory;
        this.directory = dir;
        this.history.init(factory, dir, queueName + ".hist");
        HistoryImpl.EntryImpl[] entries = this.history.entries();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getState() != 1) continue;
            this.queue.enqueue(entries[i]);
            this.pending.increment();
        }
    }

    public History history() {
        return this.history;
    }

    public MessageQueueImpl(String queueName) {
        this.queueName = queueName;
        this.directory = null;
    }

    public void setConsumer(Consumer consumer) {
        if (this.consumer != null) {
            throw new IllegalStateException("consumer already set");
        }
        this.consumer = consumer;
        this.start();
    }

    public void send(Message message) {
        HistoryImpl.EntryImpl entry = this.history.append(message);
        this.queue.enqueue(entry);
        this.pending.increment();
        this.deliverNow();
    }

    public boolean contains(final Object filter) {
        Object msgFilter = new Object(){

            public boolean equals(Object o) {
                if (o instanceof HistoryImpl.EntryImpl) {
                    return filter.equals(((HistoryImpl.EntryImpl)o).getMessage());
                }
                return false;
            }
        };
        return this.queue.contains(msgFilter);
    }

    void flush() {
        this.flushing.setTrue();
        this.deliverNow();
        try {
            this.pending.waitUntilZero();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.flushing.setFalse();
    }

    public void purge() {
        this.purging.setTrue();
        this.flush();
        this.purging.setFalse();
    }

    public void destroy() {
        this.purge();
        this.stop();
        try {
            this.history.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() {
        Thread thread = new Thread((Runnable)this, "MessageQueue[" + this.queueName + "]");
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.flushing.setTrue();
        this.deliverNow();
        this.queue.close();
    }

    public void run() {
        try {
            while (true) {
                HistoryImpl.EntryImpl entry = (HistoryImpl.EntryImpl)this.queue.dequeue();
                this.deliver(entry);
                this.pending.decrement();
            }
        }
        catch (InterruptedException e) {
            try {
                this.history.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverNow() {
        Object object = this.deliveryDelay;
        synchronized (object) {
            this.deliveryDelay.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliver(HistoryImpl.EntryImpl entry) {
        while (this.flushing.isFalse()) {
            try {
                this.consumer.consume(entry.message);
                entry.setState(2);
                entry.message.purge();
                return;
            }
            catch (UndeliverableException e) {
                entry.message.release();
                Object object = this.deliveryDelay;
                synchronized (object) {
                    try {
                        this.deliveryDelay.wait(e.timeout);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable e) {
                log.error("Uncaught exception in consumer.", e);
            }
        }
        if (this.purging.isTrue()) {
            entry.message.purge();
            entry.setState(3);
        }
    }
}

