/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.mq;

import com.day.util.mq.MessageException;
import com.day.util.mq.MessageFactory;
import com.day.util.mq.MessageQueue;
import com.day.util.mq.MessageQueueImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageQueueProvider {
    private static final Logger log = LoggerFactory.getLogger(MessageQueueProvider.class);
    private final HashMap queues = new HashMap();
    private final File directory;

    public MessageQueueProvider(File directory) {
        log.debug("Created provider with directory {}", (Object)directory);
        this.directory = directory;
    }

    public MessageQueueProvider() {
        log.debug("Created directory-less provider");
        this.directory = null;
    }

    public void startup() {
        log.debug("startup");
    }

    public MessageQueue open(String queueName, MessageFactory factory) throws MessageException {
        log.debug("open({},{})", (Object)queueName, (Object)factory);
        MessageQueue queue = (MessageQueue)this.queues.get(queueName);
        if (queue == null) {
            if (this.directory == null) {
                throw new MessageException("Unable to open persistent queue for transient provider");
            }
            try {
                queue = new MessageQueueImpl(queueName, factory, this.directory);
            }
            catch (IOException e) {
                throw new MessageException(e.toString());
            }
            this.queues.put(queueName, queue);
            log.debug("associated new queue: {}->{}", (Object)queueName, (Object)queue);
        }
        return queue;
    }

    public MessageQueue open(String queueName) throws MessageException {
        log.debug("open({})", (Object)queueName);
        MessageQueue queue = (MessageQueue)this.queues.get(queueName);
        if (queue == null) {
            queue = new MessageQueueImpl(queueName);
            this.queues.put(queueName, queue);
            log.debug("associated new queue: {}->{}", (Object)queueName, (Object)queue);
        }
        return queue;
    }

    public void delete(String queueName) throws MessageException {
        log.debug("delete({})", (Object)queueName);
        MessageQueue queue = (MessageQueue)this.queues.remove(queueName);
        if (queue != null) {
            log.debug("queue being destroyed: {}->{}", (Object)queueName, (Object)queue);
            queue.destroy();
        }
    }

    public void shutdown() {
        log.debug("shutdown");
        for (MessageQueueImpl queue : this.queues.values()) {
            queue.stop();
        }
        this.queues.clear();
    }
}

