/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.eventlogger;

import com.day.crx.CRXSession;
import com.day.crx.eventlogger.EventLogger;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventLogger
implements EventLogger,
EventListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractEventLogger.class);
    private CRXSession systemSession;
    protected CRXSession observedSession;
    protected String observedWorkspace;

    public AbstractEventLogger(CRXSession systemSession, String observedWorkspace) {
        this.systemSession = systemSession;
        this.observedWorkspace = observedWorkspace;
    }

    public void start() throws RepositoryException {
        this.observedSession = this.systemSession.getSession(this.observedWorkspace);
        try {
            this.onStart();
            this.observedSession.getWorkspace().getObservationManager().addEventListener((EventListener)this, -1, "/", true, null, null, false);
        }
        catch (RepositoryException e) {
            this.closeObservedSession();
            throw e;
        }
    }

    public void stop() {
        this.onStop();
        this.closeObservedSession();
    }

    public abstract void onEvent(EventIterator var1);

    protected void onStart() throws RepositoryException {
    }

    protected void onStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeObservedSession() {
        if (this.observedSession.isLive()) {
            try {
                this.observedSession.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (RepositoryException re) {
                log.error("Error while stopping event logger", (Throwable)re);
            }
            finally {
                this.observedSession.logout();
                this.observedSession = null;
            }
        }
    }
}

