/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.eventlogger;

import com.day.crx.CRXSession;
import com.day.crx.eventlogger.AbstractEventLogger;
import java.util.Calendar;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRXEventLogger
extends AbstractEventLogger {
    public static final String SINK_NAME = "crx";
    private static final Logger log = LoggerFactory.getLogger(CRXEventLogger.class);
    private CRXSession systemSession;
    private String logWorkspace;
    private String storageRootPath;
    private String persistPath;
    private Session logSession;

    public CRXEventLogger(CRXSession systemSession, String obsWorkspace, String logWorkspace, String storageRootPath) {
        super(systemSession, obsWorkspace);
        this.systemSession = systemSession;
        this.logWorkspace = logWorkspace;
        this.storageRootPath = storageRootPath;
    }

    public void onStart() throws RepositoryException {
        try {
            this.logSession = this.getEventLogSession(this.systemSession, this.logWorkspace);
            this.checkWorkspaceNode();
        }
        catch (RepositoryException e) {
            if (this.logSession != null) {
                this.logSession.logout();
            }
            throw e;
        }
    }

    public void onStop() {
        if (this.logSession != null && this.logSession.isLive()) {
            this.logSession.logout();
            this.logSession = null;
        }
    }

    public void onEvent(EventIterator eventIterator) {
        try {
            Node dayNode = this.checkDayNode();
            Node eventsNode = this.createEventsNode(dayNode);
            int count = 0;
            while (eventIterator.hasNext()) {
                Event ev = eventIterator.nextEvent();
                this.persistEvent(eventsNode, ev, count);
                ++count;
            }
        }
        catch (RepositoryException e) {
            log.error("Cannot log events: " + e.getMessage());
        }
    }

    private Session getEventLogSession(CRXSession systemSession, String logWorkspace) throws RepositoryException {
        try {
            return systemSession.getSession(logWorkspace);
        }
        catch (NoSuchWorkspaceException nswe) {
            Workspace wsp = systemSession.getWorkspace();
            wsp.createWorkspace(logWorkspace);
            return systemSession.getSession(logWorkspace);
        }
    }

    private void checkWorkspaceNode() throws RepositoryException {
        Node root;
        try {
            root = (Node)this.logSession.getItem(this.storageRootPath);
        }
        catch (PathNotFoundException e) {
            root = this.logSession.getRootNode().addNode(this.storageRootPath.substring(1), "nt:unstructured");
            this.logSession.getRootNode().save();
        }
        if (!root.hasNode(this.observedSession.getWorkspace().getName())) {
            root.addNode(this.observedSession.getWorkspace().getName(), "nt:unstructured");
            root.save();
        }
        this.persistPath = root.getPath() + "/" + this.observedSession.getWorkspace().getName();
    }

    private Node checkDayNode() throws RepositoryException {
        Node day;
        String dayString = this.getDayString();
        try {
            day = (Node)this.logSession.getItem(this.persistPath + "/" + dayString);
        }
        catch (PathNotFoundException e) {
            day = ((Node)this.logSession.getItem(this.persistPath)).addNode(dayString, "nt:unstructured");
            this.logSession.getItem(this.persistPath).save();
        }
        return day;
    }

    private Node createEventsNode(Node dayNode) throws RepositoryException {
        long time = System.currentTimeMillis();
        Node eventsNode = dayNode.addNode(String.valueOf(time), "nt:unstructured");
        eventsNode.setProperty("timestamp", time);
        dayNode.save();
        return eventsNode;
    }

    private void persistEvent(Node eventsNode, Event event, int count) {
        try {
            Node eventNode = eventsNode.addNode(String.valueOf(count));
            eventNode.setProperty("action", (long)event.getType());
            eventNode.setProperty("path", event.getPath());
            eventNode.setProperty("userid", event.getUserID());
            eventsNode.save();
        }
        catch (RepositoryException e) {
            log.error("Cannot persist event: " + e.getMessage());
        }
    }

    private String getDayString() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2);
        int year = calendar.get(1);
        int day = calendar.get(5);
        String strMonth = month < 10 ? "0" + String.valueOf(month) : String.valueOf(month);
        String strDay = day < 10 ? "0" + String.valueOf(day) : String.valueOf(day);
        String dayString = String.valueOf(year) + strMonth + strDay;
        return dayString;
    }
}

