/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.eventlogger;

import com.day.crx.CRXModule;
import com.day.crx.CRXSession;
import com.day.crx.eventlogger.CRXEventLogger;
import com.day.crx.eventlogger.EventLogger;
import com.day.crx.eventlogger.Slf4jEventLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoggerModule
implements CRXModule {
    private static final Logger log = LoggerFactory.getLogger(EventLoggerModule.class);
    private String workspaces;
    private String logWorkspace = "crx.logger";
    private String logPath = "/crx.events";
    private String sink = "crx";
    private List<EventLogger> eventLoggers;

    public String getName() {
        return "Event Logger Module";
    }

    public void start(CRXSession systemSession) {
        if (this.getWorkspaces() != null && this.getWorkspaces().length() > 0) {
            this.eventLoggers = new ArrayList<EventLogger>();
            StringTokenizer tokener = new StringTokenizer(this.getWorkspaces(), ",");
            while (tokener.hasMoreTokens()) {
                String obsWorkspace = tokener.nextToken().trim();
                if (this.logWorkspace.equals(obsWorkspace)) {
                    log.warn("Will not listen on logger workspace " + obsWorkspace);
                    continue;
                }
                try {
                    EventLogger el = this.createEventLogger(systemSession, obsWorkspace);
                    el.start();
                    this.eventLoggers.add(el);
                }
                catch (Exception e) {
                    log.error("Cannot start event logger for workspace " + obsWorkspace, (Throwable)e);
                }
            }
        } else {
            log.info("No workspaces configured to listen on");
        }
    }

    public void stop() {
        if (this.eventLoggers != null && this.eventLoggers.size() > 0) {
            Iterator<EventLogger> i$ = this.eventLoggers.iterator();
            while (i$.hasNext()) {
                EventLogger eventLogger;
                EventLogger el = eventLogger = i$.next();
                el.stop();
            }
            this.eventLoggers = null;
        }
    }

    public String getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(String workspaces) {
        this.workspaces = workspaces;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String getSink() {
        return this.sink;
    }

    public void setSink(String sink) {
        this.sink = sink;
    }

    public String getLogWorkspace() {
        return this.logWorkspace;
    }

    public void setLogWorkspace(String logWorkspace) {
        this.logWorkspace = logWorkspace;
    }

    private EventLogger createEventLogger(CRXSession systemSession, String obsWorkspace) throws RepositoryException {
        if (this.sink != null && this.sink.compareToIgnoreCase("crx") == 0) {
            return new CRXEventLogger(systemSession, obsWorkspace, this.getLogWorkspace(), this.getLogPath());
        }
        if (this.sink != null && this.sink.compareToIgnoreCase("slf4j") == 0) {
            return new Slf4jEventLogger(systemSession, obsWorkspace, this.getLogPath());
        }
        throw new RepositoryException("Unknown sink: " + this.sink);
    }
}

