/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.eventlogger;

import com.day.crx.CRXSession;
import com.day.crx.eventlogger.AbstractEventLogger;
import java.text.DecimalFormat;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jEventLogger
extends AbstractEventLogger {
    public static final String SINK_NAME = "slf4j";
    private String loggerName;
    private int eventCount;

    public Slf4jEventLogger(CRXSession systemSession, String observedWorkspace, String loggerName) throws RepositoryException {
        super(systemSession, observedWorkspace);
        this.loggerName = this.trim(loggerName);
        if (this.loggerName.length() == 0) {
            throw new RepositoryException("Invalid value for logPath: " + loggerName);
        }
    }

    public void onEvent(EventIterator eventIterator) {
        Logger l = LoggerFactory.getLogger((String)(this.loggerName + "." + this.observedWorkspace + "." + new DecimalFormat("0000").format(++this.eventCount)));
        if (l.isInfoEnabled()) {
            while (eventIterator.hasNext()) {
                Event e = eventIterator.nextEvent();
                l.info(this.translateEvent(e));
            }
        }
    }

    private String getEventTypeName(Event e) {
        int i = e.getType();
        switch (i) {
            case 1: {
                return "NODE_ADDED (" + i + ")";
            }
            case 2: {
                return "NODE_REMOVED (" + i + ")";
            }
            case 4: {
                return "PROPERTY_ADDED (" + i + ")";
            }
            case 8: {
                return "PROPERTY_REMOVED (" + i + ")";
            }
            case 16: {
                return "PROPERTY_CHANGED (" + i + ")";
            }
        }
        return "UNKNOWN EVENT TYPE (" + i + ")";
    }

    private String translateEvent(Event e) {
        StringBuffer s = new StringBuffer();
        s.append(this.getEventTypeName(e));
        s.append(" Path: ");
        try {
            s.append(e.getPath());
        }
        catch (RepositoryException ex) {
            s.append("unknown: " + (Object)((Object)ex));
        }
        s.append(" User: ");
        s.append(e.getUserID());
        return s.toString();
    }

    private String trim(String loggerName) {
        StringBuffer s = new StringBuffer();
        boolean skip = true;
        for (int i = 0; i < loggerName.length(); ++i) {
            char c = loggerName.charAt(i);
            if (c == '/' && !skip) {
                s.append('.');
                continue;
            }
            if (c == '/') continue;
            s.append(c);
            skip = false;
        }
        return s.toString();
    }
}

