/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics;

import com.day.crx.CRXModule;
import com.day.crx.CRXSession;
import com.day.crx.CRXWorkspace;
import com.day.crx.statistics.Entry;
import com.day.crx.statistics.Report;
import com.day.crx.statistics.Statistics;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class StatisticsModule
implements CRXModule {
    static final String CVS_ID = "$URL: http://svn.day.com/repos/misc/crx-statistics/tags/crx-statistics-1.4.3/src/main/java/com/day/crx/statistics/StatisticsModule.java $ $Rev: 37140 $ $Date: 2008-06-27 16:03:00 +0200 (Fr, 27 Jun 2008) $";
    private Statistics statistics;
    private String wspName;

    public String getName() {
        return StatisticsModule.class.getName();
    }

    public void start(CRXSession session) throws RepositoryException {
        CRXSession s;
        if (this.wspName == null) {
            s = session.getSession(session.getWorkspace().getName());
        } else {
            List<String> wspNames = Arrays.asList(session.getWorkspace().getAccessibleWorkspaceNames());
            if (!wspNames.contains(this.wspName)) {
                ((CRXWorkspace)session.getWorkspace()).createWorkspace(this.wspName);
            }
            s = session.getSession(this.wspName);
        }
        this.statistics = new Statistics((Session)s);
    }

    public void stop() {
        if (this.statistics != null) {
            this.statistics.stop();
            this.statistics = null;
        }
    }

    public Iterator runReport(Report report) throws RepositoryException {
        return this.statistics.runReport(report);
    }

    public void addEntry(Entry entry) throws RepositoryException {
        this.statistics.addEntry(entry);
    }

    public String getWorkspaceName() {
        return this.wspName;
    }

    public void setWorkspaceName(String wspName) {
        this.wspName = wspName;
    }
}

