/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.ConsoleSession;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Util;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager_friend;
import org.apache.jackrabbit.core.persistence.check.ConsistencyCheckListener;
import org.apache.jackrabbit.core.persistence.check.ConsistencyChecker;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReport;
import org.apache.jackrabbit.core.persistence.check.ReportItem;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public class CmdBundleCheck
extends AbstractCommand {
    public void bundlecheck(@Descriptor(value="automatically supplied shell session") CommandSession ses, String[] args) throws Exception {
        this.cmdSession = ses;
        Options opts = this.getOptions(args);
        String wsp = this.getSession().getWorkspace().getName();
        ConsoleSession cs = this.getConsoleSession(wsp);
        PersistenceManager pm = cs.getPersistenceManager();
        PersistenceManager vPM = cs.getVersionPersistenceManager();
        if (!(pm instanceof AbstractBundlePersistenceManager)) {
            System.err.println("bundlecheck needs a BundlePersistenceManager, but this workspace uses '" + pm.getClass() + "'");
            return;
        }
        AbstractBundlePersistenceManager_friend bundlePM = new AbstractBundlePersistenceManager_friend((AbstractBundlePersistenceManager)pm);
        String uuid = opts.getArg(0);
        Checker checker = new Checker(bundlePM, vPM, this.getSession(false));
        checker.setFix(opts.hasOption("f"));
        checker.setPrintPaths(opts.hasOption("p"));
        checker.setPrintInfos(!opts.hasOption("e"));
        checker.setRecursive(opts.hasOption("r"));
        checker.setCheckRefs(opts.hasOption("x"));
        checker.setFixRefs(opts.hasOption("X"));
        String output = opts.getOption("o");
        String lostNFound = opts.getOption("l");
        if (vPM == null && (checker.isFixRefs() || checker.isCheckRefs())) {
            System.err.println("bundlecheck is unable to check references because persistence manager of version store not available.");
            return;
        }
        if (lostNFound != null) {
            if (lostNFound.startsWith("[")) {
                int idx = lostNFound.indexOf(93);
                lostNFound = lostNFound.substring(1, idx);
            } else {
                try {
                    ItemImpl item = Util.getItem(this.cmdSession, lostNFound);
                    lostNFound = item.getId().toString();
                }
                catch (Exception e) {
                    throw new RepositoryException("Can't use lost+found node " + lostNFound + ": " + e.getMessage());
                }
            }
            System.out.println("Using node " + lostNFound + " as parent for orphaned nodes.");
            checker.setLostAndFound(lostNFound);
        }
        if (output == null) {
            checker.setOut(System.out);
        } else {
            checker.setOut(new PrintStream((OutputStream)new FileOutputStream(output), true, "utf-8"));
        }
        if (opts.hasOption("a")) {
            checker.checkAllBundles();
        } else {
            NodeId nodeId;
            try {
                nodeId = NodeId.valueOf((String)uuid);
            }
            catch (Exception e) {
                ItemImpl item = Util.getItem(this.cmdSession, uuid);
                if (item.getId() instanceof NodeId) {
                    nodeId = (NodeId)item.getId();
                }
                System.err.println("Path refers to a property '" + item.getPath() + "'");
                return;
            }
            checker.checkBundle(nodeId);
        }
        if (output != null) {
            checker.getOut().close();
        }
    }

    public String getOptionsFormat() {
        return "arfpeo:l:xX$";
    }

    public String getName() {
        return "bundlecheck";
    }

    public String getDescription() {
        return "Checks node bundles";
    }

    public String getHelpString() {
        return "Synopsis:\n    bundlecheck [options] [path | uuid]\n\nDescription:\n    Checks either the current node's bundle, the bundle for a given node path, the bundle\n    for a node UUID or all stored bundles (regardless of hierarchy information). This command\n    only works with bundle persistence managers (eg. DB bundle and TarPM).\n\nOptions:\n    -a        check all bundles in the PM storage (-r does not apply)\n    -r        recursively check subnodes\n    -f        try to fix missing child node errors\n    -p        print node paths and verify parent relations (slower)\n    -x        check node references (slower)\n    -X        check node references and remove invalid (slower)\n    -e        only print errors (faster)\n    -o <file> dump output to file.\n    -l <path> move orphaned nodes to this lost+found parent node";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Checker {
        private boolean fix;
        private boolean printPaths;
        private boolean printInfos;
        private PrintStream out;
        private boolean recursive;
        private boolean checkRefs;
        private boolean fixRefs;
        private String lostNFound;
        private final AbstractBundlePersistenceManager_friend bundlePM;
        private final PersistenceManager vPM;
        private final Session session;
        private static final Set<Name> VERSION_PROPS = new HashSet<Name>();
        private static final Name MIX_VERSIONABLE;

        private Checker(AbstractBundlePersistenceManager_friend bundlePM, PersistenceManager vPM, Session session) {
            this.bundlePM = bundlePM;
            this.vPM = vPM;
            this.session = session;
        }

        public void setFix(boolean fix) {
            this.fix = fix;
        }

        public void setLostAndFound(String path) {
            this.lostNFound = path;
        }

        public void setPrintPaths(boolean printPaths) {
            this.printPaths = printPaths;
        }

        public void setPrintInfos(boolean printInfos) {
            this.printInfos = printInfos;
        }

        public PrintStream getOut() {
            return this.out;
        }

        public void setOut(PrintStream out) {
            this.out = out;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public boolean isCheckRefs() {
            return this.checkRefs;
        }

        public void setCheckRefs(boolean checkRefs) {
            this.checkRefs = checkRefs;
        }

        public boolean isFixRefs() {
            return this.fixRefs;
        }

        public void setFixRefs(boolean fixRefs) {
            this.fixRefs = fixRefs;
        }

        protected void checkBundle(NodeId nodeId) throws RepositoryException {
            boolean usedPMConsistencyChecker = false;
            if (this.bundlePM.getRealPM() instanceof ConsistencyChecker) {
                try {
                    ConsistencyCheckerReporter reporter = new ConsistencyCheckerReporter(this.out, this.out, this.printInfos, this.printPaths ? this.session : null);
                    reporter.reportResult(this.bundlePM.getRealPM().check(new String[]{nodeId.toString()}, this.recursive, this.fix, this.lostNFound, reporter));
                    if (!this.checkRefs && !this.fixRefs) {
                        return;
                    }
                    usedPMConsistencyChecker = true;
                }
                catch (Exception e) {
                    System.err.println("error executing jackrabbit consistency checker:" + e.toString());
                    System.out.println("calling fallback");
                }
            }
            int count = 0;
            ArrayList<NodePropBundle> modifications = new ArrayList<NodePropBundle>();
            Stack<NodeId> idStack = new Stack<NodeId>();
            idStack.add(nodeId);
            while (idStack.size() > 0) {
                try {
                    NodeId id = (NodeId)idStack.pop();
                    NodePropBundle bundle = this.bundlePM.loadBundle(id, true);
                    if (bundle == null) {
                        if (id.toString().endsWith("babecafebabe")) continue;
                        this.out.println("[WARN] No bundle found for uuid '" + id + "'" + (this.printPaths ? " " + this.getBundlePath(id, null, this.bundlePM) : ""));
                        continue;
                    }
                    if (usedPMConsistencyChecker) {
                        this.checkPropertyRefs(bundle, modifications);
                    } else {
                        this.checkBundleConsistency(id, bundle, modifications);
                    }
                    if (this.recursive) {
                        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                            idStack.push(entry.getId());
                        }
                    }
                    if (++count % 1000 != 0) continue;
                    this.out.println("Checked " + count + "/" + idStack.size() + " bundles...");
                    if (this.out == System.out) continue;
                    System.out.println("Checked " + count + "/" + idStack.size() + " bundles...");
                }
                catch (ItemStateException e) {
                    this.out.println("[ERROR] Broken bundle: " + e.getMessage());
                }
            }
            if (this.fix | this.fixRefs && !modifications.isEmpty()) {
                this.saveFixedBundles(this.printPaths, modifications, this.bundlePM);
            }
        }

        protected void checkAllBundles() throws RepositoryException {
            List iter;
            boolean usedPMConsistencyChecker = false;
            try {
                if (this.bundlePM.getRealPM() instanceof ConsistencyChecker) {
                    ConsistencyCheckerReporter reporter = new ConsistencyCheckerReporter(this.out, this.out, this.printInfos, this.printPaths ? this.session : null);
                    reporter.reportResult(this.bundlePM.getRealPM().check(null, this.recursive, this.fix, this.lostNFound, reporter));
                    if (!this.checkRefs && !this.fixRefs) {
                        return;
                    }
                    usedPMConsistencyChecker = true;
                }
            }
            catch (Exception e) {
                System.err.println("error executing jackrabbit consistency checker:" + e.toString());
                System.out.println("calling fallback");
            }
            int count = 0;
            ArrayList<NodePropBundle> modifications = new ArrayList<NodePropBundle>();
            try {
                iter = this.bundlePM.getRealPM().getAllNodeIds(null, 0);
            }
            catch (ItemStateException e) {
                System.err.println("Could not retrieve list of all bundles from PM: " + e.getMessage());
                return;
            }
            catch (RepositoryException e) {
                System.err.println("Could not retrieve list of all bundles from PM: " + e.getMessage());
                return;
            }
            for (NodeId id : iter) {
                try {
                    NodePropBundle bundle = this.bundlePM.loadBundle(id, true);
                    if (bundle == null) {
                        if (id.toString().endsWith("babecafebabe")) continue;
                        this.out.println("[WARN] No bundle found for uuid '" + id + "'" + (this.printPaths ? " " + this.getBundlePath(id, null, this.bundlePM) : ""));
                        continue;
                    }
                    if (usedPMConsistencyChecker) {
                        this.checkPropertyRefs(bundle, modifications);
                    } else {
                        this.checkBundleConsistency(id, bundle, modifications);
                    }
                    if (++count % 1000 != 0) continue;
                    this.out.println("Checked " + count + " bundles...");
                    if (this.out == System.out) continue;
                    System.out.println("Checked " + count + " bundles...");
                }
                catch (ItemStateException e) {
                    this.out.println("[ERROR] Broken bundle: " + e.getMessage());
                }
            }
            if ((this.fix || this.fixRefs) && !modifications.isEmpty()) {
                this.saveFixedBundles(this.printPaths, modifications, this.bundlePM);
            }
        }

        protected void checkBundleConsistency(NodeId id, NodePropBundle bundle, Collection<NodePropBundle> modifications) {
            String bundlePath;
            String string = bundlePath = this.printPaths ? " " + this.getBundlePath(id, bundle, this.bundlePM) : "";
            if (this.printInfos) {
                this.out.println("Checking bundle '" + id + "'" + bundlePath);
            }
            ArrayList<NodePropBundle.ChildNodeEntry> missingChildren = new ArrayList<NodePropBundle.ChildNodeEntry>();
            for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                try {
                    NodePropBundle child = this.bundlePM.loadBundle(entry.getId(), true);
                    if (child == null) {
                        if (entry.getId().toString().endsWith("babecafebabe")) continue;
                        this.out.println("[ERROR] NodeState '" + this.getBundlePath(id, bundle, this.bundlePM) + "' ('" + id + "') references " + "inexistent child '" + entry.getName() + "' with id '" + entry.getId() + "' (FIXABLE)");
                        missingChildren.add(entry);
                        continue;
                    }
                    NodeId cp = child.getParentId();
                    if (cp == null) {
                        this.out.println("[ERROR] ChildNode '" + entry.getName() + "' has invalid parent uuid: <null>");
                        continue;
                    }
                    if (cp.equals((Object)id)) continue;
                    this.out.println("[ERROR] ChildNode '" + entry.getName() + "' has invalid parent uuid: '" + cp + "' " + "(instead of '" + id + "')");
                }
                catch (ItemStateException e) {
                    this.out.println("[ERROR] Broken bundle: " + e.getMessage());
                }
            }
            if (this.fix && !missingChildren.isEmpty()) {
                for (NodePropBundle.ChildNodeEntry aMissingChildren : missingChildren) {
                    bundle.getChildNodeEntries().remove(aMissingChildren);
                }
                modifications.add(bundle);
            }
            NodeId parentId = bundle.getParentId();
            try {
                if (parentId != null && !id.toString().endsWith("babecafebabe") && this.bundlePM.loadBundle(parentId) == null) {
                    this.out.println("[ERROR] NodeState '" + id + "' references inexistent parent uuid '" + parentId + "'");
                }
            }
            catch (ItemStateException e) {
                this.out.println("[ERROR] Error reading node '" + parentId + "' (parent of '" + id + "'): " + (Object)((Object)e));
            }
            if (this.checkRefs || this.fixRefs) {
                this.checkPropertyRefs(bundle, modifications);
            }
        }

        private void checkPropertyRefs(NodePropBundle bundle, Collection<NodePropBundle> modifications) {
            boolean versionError = false;
            block2: for (NodePropBundle.PropertyEntry p : bundle.getPropertyEntries()) {
                if (p.getType() != 9) continue;
                InternalValue[] vs = p.getValues();
                for (int i = 0; i < vs.length; ++i) {
                    NodeId targetId = vs[i].getNodeId();
                    String pId = p.getId().toString();
                    pId = pId + "[" + i + "]";
                    try {
                        AbstractBundlePersistenceManager pm = this.bundlePM.getRealPM();
                        if (!pm.existsReferencesTo(targetId)) {
                            if (VERSION_PROPS.contains(p.getId().getName())) {
                                pm = this.vPM;
                                if (!this.vPM.existsReferencesTo(targetId)) {
                                    versionError = true;
                                    this.out.println("[ERROR] Node reference " + pId + " to " + targetId + " broken.");
                                    continue block2;
                                }
                            } else {
                                pm = null;
                            }
                        }
                        if (pm == null) {
                            this.out.println("[ERROR] Node reference " + pId + " to " + targetId + " broken.");
                            if (!this.fixRefs) continue;
                            this.out.println("[ERROR] Fixing of non-version ref properties not supported yet.");
                            continue;
                        }
                        NodeReferences refs = pm.loadReferencesTo(targetId);
                        Iterator pIter = refs.getReferences().iterator();
                        boolean ok = false;
                        while (pIter.hasNext()) {
                            if (!p.getId().equals(pIter.next())) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            this.out.println("[ERROR] Node reference " + pId + " to " + targetId + " broken (back reference missing).");
                            if (!this.fixRefs) continue;
                            this.out.println("[ERROR] Back reference fix not implemented yet.");
                            continue;
                        }
                        if (!this.printInfos) continue;
                        this.out.println("[INFO] Node reference " + pId + " to " + targetId + " ok.");
                        continue;
                    }
                    catch (ItemStateException e) {
                        this.out.println("[ERROR] Error reading node reference '" + targetId + "'): " + (Object)((Object)e));
                    }
                }
            }
            if (versionError && this.fixRefs) {
                if (!bundle.getMixinTypeNames().remove(MIX_VERSIONABLE)) {
                    this.out.println("[ERROR] Unable to fix references of versionable node. has no mix:versionable");
                } else {
                    for (Name VERSION_PROP : VERSION_PROPS) {
                        bundle.removeProperty(VERSION_PROP, this.bundlePM.getBlobStore());
                    }
                    modifications.add(bundle);
                }
            }
        }

        protected void saveFixedBundles(boolean printPaths, Collection<NodePropBundle> modifications, AbstractBundlePersistenceManager_friend bundlePM) {
            this.out.println("Fixing " + modifications.size() + " inconsistent bundle(s)...");
            for (NodePropBundle bundle : modifications) {
                try {
                    this.out.println("Fixing bundle '" + bundle.getId() + "'" + (printPaths ? " " + this.getBundlePath(bundle.getId(), bundle, bundlePM) : ""));
                    ChangeLog changeLog = new ChangeLog();
                    changeLog.added((ItemState)bundle.createNodeState((PersistenceManager)bundlePM.getRealPM()));
                    bundlePM.getRealPM().store(changeLog);
                }
                catch (ItemStateException e) {
                    this.out.println("[ERROR] Error storing fixed bundle: " + (Object)((Object)e));
                }
            }
        }

        protected String getBundlePath(NodeId id, NodePropBundle bundle, AbstractBundlePersistenceManager_friend bundlePM) {
            NodePropBundle parentBundle;
            if (bundle == null) {
                return "{{missing-bundle}}";
            }
            if (id.equals((Object)RepositoryImpl.VERSION_STORAGE_NODE_ID)) {
                return "/jcr:system/jcr:versionStorage";
            }
            if (id.equals((Object)RepositoryImpl.NODETYPES_NODE_ID)) {
                return "/jcr:system/jcr:nodeTypes";
            }
            if (id.equals((Object)RepositoryImpl.SYSTEM_ROOT_NODE_ID)) {
                return "/jcr:system";
            }
            if (id.equals((Object)RepositoryImpl.ROOT_NODE_ID)) {
                return "/";
            }
            if (bundle.getParentId() == null) {
                return "/";
            }
            if (bundle.getParentId().equals((Object)id)) {
                return "/";
            }
            try {
                parentBundle = bundlePM.loadBundle(bundle.getParentId());
            }
            catch (ItemStateException e) {
                this.out.println("[ERROR] Broken bundle '" + bundle.getParentId() + "': " + e.getMessage());
                return "{{broken-bundle}}";
            }
            if (parentBundle == null) {
                return "{{missing-parent}}";
            }
            String name = null;
            for (NodePropBundle.ChildNodeEntry entry : parentBundle.getChildNodeEntries()) {
                if (!entry.getId().equals((Object)id)) continue;
                name = this.nameToString(entry.getName());
                break;
            }
            String parentPath = this.getBundlePath(parentBundle.getId(), parentBundle, bundlePM);
            if (name == null) {
                this.out.println("[ERROR] Parent '" + parentPath + "' ('" + parentBundle.getId() + "') has no child node entry pointing to bundle '" + id + "'");
                name = "{{missing-entry}}";
            }
            if ("/".equals(parentPath)) {
                return parentPath + name;
            }
            return parentPath + "/" + name;
        }

        public String nameToString(Name name) {
            String uri = name.getNamespaceURI();
            if (uri == null || uri.equals("")) {
                return name.getLocalName();
            }
            return name.toString();
        }

        static {
            VERSION_PROPS.add(NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/1.0", "predecessors"));
            VERSION_PROPS.add(NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/1.0", "mergeFailed"));
            VERSION_PROPS.add(NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/1.0", "versionHistory"));
            VERSION_PROPS.add(NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/1.0", "baseVersion"));
            VERSION_PROPS.add(NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/1.0", "isCheckedOut"));
            MIX_VERSIONABLE = NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/mix/1.0", "versionable");
        }

        private class ConsistencyCheckerReporter
        implements ConsistencyCheckListener {
            int count = 0;
            int error = 0;
            private PrintStream out;
            private PrintStream err;
            private boolean verbose;
            private Session ses = null;

            public ConsistencyCheckerReporter(PrintStream outChannel, PrintStream errChannel, boolean verbose, Session session) {
                this.out = outChannel;
                this.err = errChannel;
                this.verbose = verbose;
                this.ses = session;
            }

            public void startCheck(String id) {
                String path = null;
                if (this.verbose) {
                    if (this.ses != null) {
                        try {
                            path = this.ses.getNodeByIdentifier(id).getPath().toString();
                        }
                        catch (Exception ignore) {
                            path = "???";
                        }
                    }
                    this.out.println("checking " + id + (path == null ? "" : " " + path));
                } else if (++this.count % 1000 == 0) {
                    this.out.println("checked " + this.count + " nodes with " + this.error + " error(s) so far.");
                }
            }

            public void report(ReportItem item) {
                ++this.error;
                this.err.println("Error in node " + item.getNodeId() + ": " + item.getMessage());
            }

            public void error(String id, String message) {
                this.err.println("ERROR: " + message + (id == null ? "" : " (node " + id + ")"));
            }

            public void info(String id, String message) {
                this.out.println(message + (id == null ? "" : " (node " + id + ")"));
            }

            public void reportResult(ConsistencyReport rep) {
                this.out.println("Consistency check of " + rep.getNodeCount() + " nodes finished in " + rep.getElapsedTimeMs() + " milliseconds.");
                boolean found = false;
                for (ReportItem item : rep.getItems()) {
                    if (!found) {
                        this.err.println("Nodes with error:");
                        this.err.println("-----------------");
                        found = true;
                    }
                    this.err.println(item.getNodeId() + ": " + item.getMessage());
                }
                if (!found) {
                    this.out.println("No errors found.");
                }
            }
        }
    }
}

