/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.ConsoleSession;
import com.adobe.granite.crx.console.util.Options;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;

public class CmdCp
extends AbstractCommand {
    public void cp(@Descriptor(value="automatically supplied shell session") CommandSession ses, String[] args) throws Exception {
        this.cmdSession = ses;
        Options opts = this.getOptions(args);
        String srcPath = opts.getArgs()[0];
        String dstPath = opts.getArgs()[1];
        String srcWsp = opts.getOption("w");
        ConsoleSession cs = this.getConsoleSession(srcWsp);
        String s = cs.getCurrentPath(srcPath);
        String d = cs.getCurrentPath(dstPath);
        if (srcWsp == null) {
            this.getSession().getWorkspace().copy(s, d);
        } else {
            this.getSession().getWorkspace().copy(srcWsp, s, d);
        }
    }

    public String getName() {
        return "cp";
    }

    public boolean isName(String cmd) {
        return "copy".equals(cmd) || super.isName(cmd);
    }

    public String getDescription() {
        return "Copies a node.";
    }

    public String getOptionsFormat() {
        return "w:!!";
    }

    public String getHelpString() {
        return "Synopsis:\n    cp [options] source destination\n\nDescription:\n    Copies the node at the <source> path to the specified destination.\n\nOptions:\n    -w wsp  define the source workspace to copy from.\n";
    }
}

