/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Util;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;

public class CmdLogin
extends AbstractCommand {
    public Repository rep;

    public void login(@Descriptor(value="automatically supplied shell session") CommandSession s, String[] a) throws Exception {
        this.cmdSession = s;
        Options opts = this.getOptions(a);
        String[] args = opts.getArgs();
        String wsp = null;
        if (opts.hasOption("w")) {
            wsp = opts.getOption("w");
        }
        String user = null;
        String pw = null;
        if (args.length >= 1) {
            user = args[0];
            pw = args.length > 1 ? args[1] : "";
        }
        this.login(user == null ? null : new SimpleCredentials(user, pw.toCharArray()), wsp);
    }

    private void login(SimpleCredentials creds, String ws) throws Exception {
        Session oldSession = this.getSession(false);
        Session newSession = null;
        newSession = creds == null ? this.rep.login(ws) : this.rep.login((Credentials)creds, ws);
        if (newSession == null) {
            System.err.println("Can't login.");
            return;
        }
        if (oldSession != null) {
            oldSession.logout();
        }
        this.cmdSession.put("console.session", (Object)newSession);
        Workspace wsp = newSession.getWorkspace();
        this.cmdSession.put("console.workspace", (Object)(wsp == null ? null : wsp.getName()));
        this.cmdSession.put("console.login", (Object)newSession.getUserID());
        System.out.println("successfully logged in as " + newSession.getUserID() + (wsp == null ? "." : " in workspace " + wsp.getName()));
        try {
            Util.cd(this.cmdSession, "/");
        }
        catch (Exception e) {
            System.err.println("Couldn't change to root directory: " + e.toString());
        }
    }

    public String getName() {
        return "login";
    }

    public String getDescription() {
        return "Perform a login on the repository.";
    }

    public String getOptionsFormat() {
        return "w:$$";
    }

    public String getHelpString() {
        return "Synopsis:\n    login [user] [pass]\n\nDescription:\n    Performs a login on the repository using the specfied\n    user and password.\n\nOptions:\n    -w name workspace\n";
    }

    protected void bindRep(Repository repository) {
        this.rep = repository;
    }

    protected void unbindRep(Repository repository) {
        if (this.rep == repository) {
            this.rep = null;
        }
    }
}

