/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.ConsoleNode;
import com.adobe.granite.crx.console.util.ConsoleSession;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdPatch
extends AbstractCommand {
    public void patch(@Descriptor(value="automatically supplied shell session") CommandSession ses, String[] args) throws Exception {
        this.cmdSession = ses;
        Options opts = this.getOptions(args);
        String uuid = opts.getArg(0, "");
        NodeId nodeId = this.loadNodeId(uuid);
        if (nodeId == null) {
            return;
        }
        ConsoleSession s = this.getConsoleSession();
        ConsoleNode node = s.getNode(nodeId);
        String newParentId = opts.getOption("p");
        try {
            List<String> divorceParentIds;
            if (newParentId != null) {
                this.updateParent(node, newParentId);
            }
            if ((divorceParentIds = CmdPatch.getInputAsList(opts.getOption("a"), ",")) != null && !divorceParentIds.isEmpty()) {
                this.removeChildLinkFromParents(node, divorceParentIds, newParentId == null);
            }
            System.out.println("Changes were written directly to the persistence layer it is advisable to restart the console.");
        }
        catch (Exception e) {
            System.err.println("Couldn't patch " + nodeId + ": " + e.toString());
        }
    }

    private NodeId loadNodeId(String uuid) throws Exception {
        NodeId nodeId;
        if (uuid == null) {
            return null;
        }
        try {
            nodeId = new NodeId(uuid);
        }
        catch (Exception e) {
            ItemImpl item = Util.getItem(this.cmdSession, uuid);
            if (item.getId() instanceof NodeId) {
                nodeId = (NodeId)item.getId();
            }
            System.err.println("Path refers to a property '" + item.getPath() + "'");
            return null;
        }
        return nodeId;
    }

    private void updateParent(ConsoleNode node, String parentId) throws Exception {
        NodeState state = node.getNodeState();
        state.setParentId(new NodeId(parentId));
        state.setStatus(2);
        node.store();
    }

    private static List<String> getInputAsList(String inputIds, String separator) {
        String[] ids;
        if (inputIds == null || inputIds.trim().length() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> cleanInput = new ArrayList<String>();
        for (String id : ids = inputIds.split(separator)) {
            if (id.trim().length() == 0) continue;
            cleanInput.add(id);
        }
        return cleanInput;
    }

    private void removeChildLinkFromParents(ConsoleNode node, List<String> parents, boolean updateParentIdBasedOnPath) throws Exception {
        NodeState state = node.getNodeState();
        ArrayList<ConsoleNode> parentNodes = new ArrayList<ConsoleNode>();
        ConsoleSession cs = this.getConsoleSession();
        for (String p : parents) {
            NodeId parent = this.loadNodeId(p);
            if (parent == null) {
                System.err.println("Unable to load parent with ID '" + p + "', will continue.");
                continue;
            }
            ConsoleNode n = cs.getNode(parent);
            parentNodes.add(n);
        }
        String parentId = state.getParentId().toString();
        if (updateParentIdBasedOnPath) {
            Path path = node.getPath();
            String newParentId = null;
            for (ConsoleNode p : parentNodes) {
                if (!path.isDescendantOf(p.getPath())) continue;
                newParentId = p.getNodeState().getId().toString();
            }
            if (newParentId == null) {
                System.err.println("None of the provided parentIds could be identified as the real parent for node " + state.getId() + ". Will continue to use the old parentId " + parentId);
            } else {
                parentId = newParentId;
                this.updateParent(node, newParentId);
            }
        }
        for (ConsoleNode p : parentNodes) {
            NodeState nodeState = p.getNodeState();
            if (parentId.equals(nodeState.getParentId())) continue;
            nodeState.removeChildNodeEntry(state.getNodeId());
            nodeState.setStatus(2);
            p.store();
        }
    }

    @Override
    public String getName() {
        return "patch";
    }

    @Override
    public String getDescription() {
        return "Patch lowlevel data of an item state.";
    }

    @Override
    public String getOptionsFormat() {
        return "pa:$";
    }

    @Override
    public String getHelpString() {
        return "Synopsis:\n    patch [options] [path | uuid]\n\nDescription:\n    Patch lowlevel information of an item state. Currently only nodes supported.\nOptions:\n  -p argument is a uuid of the parent node state.\n  -a argument is a list of uuids of parent node states that need the child link removed (separated by a comma): 'p1uuid,p2uuid[,...]' .\n";
    }
}

