/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.ConsoleNode;
import com.adobe.granite.crx.console.util.ConsoleSession;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Util;
import javax.jcr.RepositoryException;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;

public class CmdRm
extends AbstractCommand {
    public void rm(@Descriptor(value="automatically supplied shell session") CommandSession s, String[] args) throws Exception {
        this.cmdSession = s;
        Options opts = this.getOptions(args);
        String name = opts.getArg(0);
        boolean cne = opts.hasOption("c");
        this.rm(name, cne);
    }

    private void rm(String name, boolean childNodeEntry) throws Exception {
        block13: {
            try {
                if (childNodeEntry) {
                    String cwd = this.getConsoleSession().getCurrentPath("");
                    ItemImpl item = Util.getItem(this.cmdSession, cwd);
                    if (item.isNode()) {
                        NodeId cId = NodeId.valueOf((String)name);
                        this.rm(((NodeImpl)item).getNodeId(), cId);
                    } else {
                        System.out.println("Cannot remove property with -c option.");
                    }
                    break block13;
                }
                if (name.startsWith("[")) {
                    ConsoleSession s = this.getConsoleSession();
                    int idx = name.indexOf(93);
                    NodeId id = NodeId.valueOf((String)name.substring(1, idx));
                    ConsoleNode node = s.getNode(id);
                    String path = node.getSafePath();
                    try {
                        ItemImpl item = Util.getItem(this.cmdSession, path);
                        item.remove();
                        System.out.println("Node " + path + " removed transiently. use 'save' to persist.");
                        return;
                    }
                    catch (RepositoryException e) {
                        System.out.println("Item " + id + " might be corrupt. partial path: " + path + " try to remove on persistence layer.");
                        NodeState ns = node.getNodeState();
                        ChangeLog cl = new ChangeLog();
                        try {
                            ConsoleNode p = s.getNode(ns.getParentId());
                            NodeState pns = p.getNodeState();
                            if (pns.removeChildNodeEntry(id)) {
                                pns.setStatus(2);
                                cl.modified((ItemState)pns);
                            }
                        }
                        catch (RepositoryException e2) {
                            System.out.println("Parent of " + id + " does not exist. Node is orphaned.");
                        }
                        this.rm(cl, path, s, node);
                        try {
                            s.getPersistenceManager().store(cl);
                            System.out.println("Changes were written directly to the persistence layer it is advisable to restart the console.");
                        }
                        catch (ItemStateException e3) {
                            System.err.println("Error while saving changes: " + e3.toString());
                        }
                        break block13;
                    }
                }
                ItemImpl item = Util.getItem(this.cmdSession, name);
                String path = item.getPath();
                item.remove();
                System.out.println("Item " + path + " removed transiently. use 'save' to persist.");
            }
            catch (Exception e) {
                System.err.println("Can not remove node " + name + ":" + e.toString());
            }
        }
    }

    private void rm(ChangeLog cl, String path, ConsoleSession s, ConsoleNode node) {
        NodeState ns = node.getNodeState();
        ns.setStatus(3);
        cl.deleted((ItemState)ns);
        System.out.println("removed node " + ns.getNodeId() + " at " + path);
        for (ChildNodeEntry e : ns.getChildNodeEntries()) {
            try {
                ConsoleNode c = s.getNode(e.getId());
                this.rm(cl, path + "/" + e.getName(), s, c);
            }
            catch (RepositoryException e1) {
                System.out.println("child node " + path + "/" + e.getName() + " does not exist");
            }
        }
    }

    private void rm(NodeId id, NodeId cId) throws Exception {
        ConsoleSession s = this.getConsoleSession();
        ConsoleNode node = s.getNode(id);
        NodeState state = node.getNodeState();
        if (!state.hasChildNodeEntry(cId)) {
            System.out.println("Childnode entry does not exists: " + cId);
        } else {
            state.removeChildNodeEntry(cId);
            state.setStatus(2);
            node.store();
            System.out.println("Changes were written directly to the persistence layer it is advisable to restart the console.");
        }
    }

    public String getName() {
        return "rm";
    }

    public String getDescription() {
        return "Removes a node or property.";
    }

    public String getOptionsFormat() {
        return "c!";
    }

    public String getHelpString() {
        return "Synopsis:\n    rm [options] [ name | \"[\" uuid \"]\"\n\nDescription:\n    Removes the specified node or property transiently. If a \n    orphaned node is specified it (and it's subtree) is deleted \n    directly in the persistence layer.\n\nOptions:\n  -c argument is a uuid of a child node entry (experts only!)\n     the entry is removed directly on the persistence manager\n     and the console should be restarted afterwards.";
    }
}

