/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Spooler;
import java.util.LinkedList;
import javax.jcr.Session;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;

public class CmdSpool
extends AbstractCommand {
    public void spool(@Descriptor(value="automatically supplied shell session") CommandSession ses, String[] args) throws Exception {
        this.cmdSession = ses;
        Options opts = this.getOptions(args);
        String srcWsp = opts.getArg(0);
        String dstWsp = opts.getArg(1);
        LinkedList<String> excludes = new LinkedList<String>();
        if (opts.hasOption("e")) {
            for (String string : opts.getOptions("e")) {
                excludes.add(string);
            }
        }
        try {
            Session dstSession = this.getSession().getRepository().login(dstWsp);
            PersistenceManager srcPm = this.getConsoleSession(srcWsp).getPersistenceManager();
            PersistenceManager dstPm = this.getConsoleSession(dstWsp).getPersistenceManager();
            Spooler spooler = new Spooler(srcPm, dstPm);
            spooler.setExcludes(excludes);
            NodeId rootNodeId = ((NodeImpl)this.getSession().getRootNode()).getNodeId();
            spooler.spool(rootNodeId, "");
            dstSession.logout();
        }
        catch (Exception e) {
            System.err.println("Couldn't spool: " + e.toString());
        }
    }

    public String getName() {
        return "spool";
    }

    public String getDescription() {
        return "Spools (copies) a workspace.";
    }

    public String getOptionsFormat() {
        return "e*:!!";
    }

    public String getHelpString() {
        return "Synopsis:\n    spool [options] source destination\n\nDescription:\n    Lowlevel copies the item states from the persistence\n    manager in workspace <source> to the persistence manager\n    in workspace <destination..\n\nOptions:\n    -e exclude exclude path from spool. eg: -e /{}testRoot (can be multiple)\n";
    }
}

