/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.Options;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.WorkspaceImpl;

public class CmdWorkspace
extends AbstractCommand {
    public void workspace(@Descriptor(value="automatically supplied shell session") CommandSession ses, String[] args) throws Exception {
        this.cmdSession = ses;
        Options opts = this.getOptions(args);
        if (opts.hasOption("c")) {
            for (String s : opts.getOptions("c")) {
                ((WorkspaceImpl)this.getSession().getWorkspace()).createWorkspace(s);
            }
        }
        if (opts.hasOption("r")) {
            System.err.println("removing workspaces not implemented!");
        }
        System.out.println("Workspaces seen by user '" + this.getSession().getUserID() + "'");
        for (String s : this.getSession().getWorkspace().getAccessibleWorkspaceNames()) {
            System.out.println(" " + s);
        }
    }

    public String getName() {
        return "workspace";
    }

    public boolean isName(String cmd) {
        return "wsp".equals(cmd) || super.isName(cmd);
    }

    public String getDescription() {
        return "Manages workspaces";
    }

    public String getOptionsFormat() {
        return "c*:";
    }

    public String getHelpString() {
        return "Synopsis:\n    workspace [commands]\n\nDescription:\n    Manipulates workspaces. with no argument it displays the list     of all workspaces of the repository.\n\nCommands:\n    -c name  creates a new workspace (can be multiple)\n";
    }
}

