/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console.util;

import com.adobe.granite.crx.console.util.ConsoleNode;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.RepositoryImpl_friend;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

public class ConsoleSession
implements NamePathResolver {
    private static NamespaceResolver NS_RESOLVER = new NamespaceResolver(){

        public String getURI(String string) throws NamespaceException {
            return string;
        }

        public String getPrefix(String string) throws NamespaceException {
            return string;
        }
    };
    private static NamePathResolver RESOLVER = new DefaultNamePathResolver(NS_RESOLVER);
    private final PersistenceManager pMgr;
    private PersistenceManager vPM;
    private final String workspaceName;

    public ConsoleSession(RepositoryImpl rep, String workspace) throws RepositoryException {
        RepositoryImpl_friend friend = new RepositoryImpl_friend(rep);
        this.pMgr = friend.getPersistenceManager(workspace);
        try {
            this.vPM = friend.getVersionPersistenceManager();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.workspaceName = workspace;
    }

    public ConsoleNode getNode(NodeId id) throws RepositoryException {
        try {
            NodeState state = this.pMgr.load(id);
            return new ConsoleNode(this, state);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Path getPath(NodeState state) throws RepositoryException {
        try {
            PathBuilder builder = new PathBuilder();
            NodeId id = state.getParentId();
            while (id != null) {
                Name qName;
                if (!this.pMgr.exists(id)) {
                    builder.addFirst(NameFactoryImpl.getInstance().create("", id.toString()));
                    break;
                }
                NodeState parent = this.pMgr.load(id);
                if (!parent.hasChildNodeEntry(state.getNodeId())) {
                    qName = NameFactoryImpl.getInstance().create("", state.getNodeId().toString());
                } else {
                    ChildNodeEntry e = parent.getChildNodeEntry(state.getNodeId());
                    qName = e.getName();
                }
                builder.addFirst(qName);
                state = parent;
                id = state.getParentId();
            }
            builder.addRoot();
            return builder.getPath();
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getCurrentPath(String path) {
        return path;
    }

    public PropertyState getProperty(PropertyId id) throws RepositoryException {
        try {
            return this.pMgr.load(id);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public PersistenceManager getPersistenceManager() {
        return this.pMgr;
    }

    public PersistenceManager getVersionPersistenceManager() {
        return this.vPM;
    }

    public Name getQName(String string) throws IllegalNameException, NamespaceException {
        return RESOLVER.getQName(string);
    }

    public String getJCRName(Name name) throws NamespaceException {
        return RESOLVER.getJCRName(name);
    }

    public Path getQPath(String string) throws MalformedPathException, IllegalNameException, NamespaceException {
        return RESOLVER.getQPath(string);
    }

    public Path getQPath(String path, boolean normalizeIdentifier) throws MalformedPathException, IllegalNameException, NamespaceException {
        return RESOLVER.getQPath(path, normalizeIdentifier);
    }

    public String getJCRPath(Path path) throws NamespaceException {
        return RESOLVER.getJCRPath(path);
    }

    public void login(SimpleCredentials user) {
    }
}

