/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spooler {
    private final PersistenceManager src;
    private final PersistenceManager dst;
    private final ChangeLog changeLog = new ChangeLog();
    private String[] excludes = new String[0];

    public Spooler(PersistenceManager src, PersistenceManager dst) {
        this.src = src;
        this.dst = dst;
    }

    public void setExcludes(Collection<String> paths) {
        this.excludes = paths.toArray(new String[paths.size()]);
    }

    public void spool(NodeId id, String path) throws ItemStateException {
        System.out.println("adding " + path);
        NodeState node = this.src.load(id);
        LinkedList entries = new LinkedList(node.getChildNodeEntries());
        Iterator iter = entries.iterator();
        block0: while (iter.hasNext()) {
            ChildNodeEntry entry = (ChildNodeEntry)iter.next();
            String cp = path + "/" + entry.getName();
            for (int i = 0; i < this.excludes.length; ++i) {
                if (!cp.startsWith(this.excludes[i])) continue;
                System.out.println("excluding " + cp);
                node.removeChildNodeEntry(entry.getId());
                iter.remove();
                continue block0;
            }
        }
        if (this.dst.exists(id)) {
            NodeState dstNode = this.dst.load(id);
            for (ChildNodeEntry entry : dstNode.getChildNodeEntries()) {
                if (node.hasChildNodeEntry(entry.getId())) continue;
                node.addChildNodeEntry(entry.getName(), entry.getId());
            }
            this.changeLog.modified((ItemState)node);
        } else {
            this.changeLog.added((ItemState)node);
        }
        for (Name name : node.getPropertyNames()) {
            PropertyId pid = new PropertyId(id, name);
            PropertyState prop = this.src.load(pid);
            if (this.dst.exists(pid)) {
                this.changeLog.modified((ItemState)prop);
            } else {
                this.changeLog.added((ItemState)prop);
            }
            System.out.println("adding " + path + "/" + name);
        }
        if (this.src.existsReferencesTo(id)) {
            this.changeLog.modified(this.src.loadReferencesTo(id));
            System.out.println("adding " + path + "(ref)");
        }
        this.dst.store(this.changeLog);
        this.changeLog.reset();
        for (ChildNodeEntry entry : entries) {
            this.spool(entry.getId(), path + "/" + entry.getName());
        }
    }
}

