/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.Dictionary;
import java.util.Properties;
import org.osgi.service.component.ComponentContext;

public class PropertyAccess {
    public static final String REPOSITORY_HOME = "repository.home";
    public static final String REPOSITORY_CONFIG = "repository.config";
    public static final String BOOTSTRAP_PROPERTIES = "bootstrap.properties";
    private final Properties bootstrapProperties;
    private final ComponentContext componentContext;
    private File bootstrapFile;

    public PropertyAccess(ComponentContext context) {
        this.componentContext = context;
        this.bootstrapProperties = new Properties();
        this.initBootstrapFile();
    }

    public File getBootstrapFile() {
        return this.bootstrapFile;
    }

    public String getProperty(String name) {
        Dictionary properties = this.componentContext.getProperties();
        Object value = properties.get(name);
        if (this.isNullOrEmpty(value)) {
            value = this.bootstrapProperties.getProperty(name);
        }
        if (this.isNullOrEmpty(value)) {
            value = this.componentContext.getBundleContext().getProperty(name);
        }
        if (this.isNullOrEmpty(value)) {
            value = System.getProperty(name);
        }
        if (!this.isNullOrEmpty(value)) {
            return value.toString().trim();
        }
        if (BOOTSTRAP_PROPERTIES.equals(name)) {
            return BOOTSTRAP_PROPERTIES;
        }
        if (REPOSITORY_HOME.equals(name)) {
            return new File("crx-quickstart", "repository").getPath();
        }
        if (REPOSITORY_CONFIG.equals(name)) {
            String home = this.getProperty(REPOSITORY_HOME);
            return new File(home, "repository.xml").getPath();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBootstrapFile() {
        this.bootstrapFile = new File(this.getProperty(BOOTSTRAP_PROPERTIES));
        if (!this.bootstrapFile.exists()) {
            return;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.bootstrapFile);
            this.bootstrapProperties.load(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean isNullOrEmpty(Object value) {
        return value == null || value.toString().trim().length() == 0;
    }
}

