/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl;

import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexEntryVisitor;
import com.day.crx.persistence.tar.index.IndexSet;
import com.day.crx.sling.server.impl.Utils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.sling.jcr.api.SlingRepository;

public class ChangeHistoryPlugin
extends AbstractWebConsolePlugin {
    private static final String LABEL = "changehistory";
    private static final String TITLE = "CRX Change History";
    private static final String RESOURCE_PREFIX = "/changehistory/";
    private SlingRepository repository;

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Object rawRoot = req.getAttribute("felix.webconsole.appRoot");
        if (!(rawRoot instanceof String)) {
            res.sendError(500);
            return;
        }
        String root = rawRoot.toString();
        Output output = new Output(root, res);
        String uri = req.getRequestURI();
        String pathInfo = uri.substring(root.length());
        if (pathInfo.equals("/changehistory")) {
            output.index();
            return;
        }
        String[] elements = pathInfo.split("/");
        String tarFile = Utils.decodeUriComponent(elements[2]);
        String mod = (req.getParameter("mod") + "").trim();
        boolean details = "true".equals((req.getParameter("details") + "").trim());
        try {
            if (details) {
                output.details(tarFile, mod);
            } else {
                output.summary(tarFile, mod);
            }
        }
        catch (RepositoryException e) {
            res.sendError(500);
        }
    }

    protected String[] getCssReferences() {
        return new String[]{"/changehistory/res/changehistory.css"};
    }

    private URL getResource(String path) {
        return path != null && path.startsWith("/changehistory/res/") ? ((Object)((Object)this)).getClass().getResource(path.substring(RESOURCE_PREFIX.length() - 1)) : null;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    private class Output {
        private String root;
        private PrintWriter pw;
        private boolean details;
        private String current;
        private String currentPath;
        private long currentLength;
        private int currentCount;

        public Output(String root, HttpServletResponse res) throws IOException {
            this.root = root;
            this.pw = res.getWriter();
        }

        public void index() throws IOException {
            this.pw.println("<ol>");
            for (TarSetHandler tarset : OptimizeThread.getInstance().getTarSets()) {
                String path = tarset.getLocalPath().replace('\\', '/');
                String[] elements = path.split("/");
                if (!elements[elements.length - 2].equals("workspaces")) continue;
                for (TarFile file : tarset.getDataFiles()) {
                    String fileName = file.getFileName().replace('\\', '/');
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                    long time = new File(file.getFileName()).lastModified();
                    String mod = new Timestamp(time).toString();
                    mod = (mod + ".").substring(0, mod.indexOf(46));
                    this.pw.print("<li>Changes up to ");
                    this.pw.print(WebConsoleUtil.escapeHtml((String)mod));
                    this.pw.print(" (");
                    this.pw.print(WebConsoleUtil.escapeHtml((String)fileName));
                    this.pw.print("): ");
                    this.pw.print("<a href='" + this.getUrl(file.getFileName(), mod, false) + "'>Summary</a>");
                    this.pw.println(" <a href='" + this.getUrl(file.getFileName(), mod, true) + "'>Details</a></li>");
                }
            }
            this.pw.println("</ol>");
        }

        public void summary() throws IOException {
            this.pw.println("<h2>Summary</h2>");
            this.pw.println("<ol>");
            for (TarSetHandler tarset : OptimizeThread.getInstance().getTarSets()) {
                String path = tarset.getLocalPath().replace('\\', '/');
                String[] elements = path.split("/");
                if (!elements[elements.length - 2].equals("workspaces")) continue;
                IndexSet index = tarset.getIndex();
                TreeMap<Integer, Long> sizeMap = new TreeMap<Integer, Long>();
                Iterator it = index.getAllEntries(null);
                while (it.hasNext()) {
                    IndexEntry e = (IndexEntry)it.next();
                    int file = e.getFileId();
                    long length = e.getLength();
                    length = length + 4L + 511L & 0xFFFFFFFFFFFFFE00L;
                    long old = sizeMap.containsKey(file) ? (Long)sizeMap.get(file) : 0L;
                    sizeMap.put(file, old + (length += 512L));
                }
                for (TarFile file : tarset.getDataFiles()) {
                    String fileName = file.getFileName().replace('\\', '/');
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                    long time = new File(file.getFileName()).lastModified();
                    String mod = new Timestamp(time).toString();
                    mod = (mod + ".").substring(0, mod.indexOf(46));
                    long mb = file.getFileLength() / 1024L / 1024L;
                    mb = mb == 0L ? 1L : mb;
                    long used = sizeMap.containsKey(file.getId()) ? (Long)sizeMap.get(file.getId()) : 0L;
                    this.pw.print("<li>");
                    this.pw.print(WebConsoleUtil.escapeHtml((String)fileName));
                    this.pw.print(" size ");
                    this.pw.print(mb);
                    this.pw.println(" MB; used ~ " + (used /= 0x100000L) + " MB</li>");
                }
            }
            this.pw.println("</ol>");
        }

        public void summary(String tarFile, String mod) throws IOException, RepositoryException {
            String path = tarFile.replace('\\', '/');
            String[] elements = path.split("/");
            String workspace = elements[elements.length - 2];
            String fileName = elements[elements.length - 1];
            this.pw.print("<h2>Changes up to ");
            this.pw.print(WebConsoleUtil.escapeHtml((String)mod));
            this.pw.print(" (");
            this.pw.print(WebConsoleUtil.escapeHtml((String)fileName));
            this.pw.println(")</h2>");
            this.pw.println("<div><textarea cols='100' rows='100'>");
            this.pw.flush();
            this.startTransaction(null);
            this.print(workspace, tarFile);
            this.startTransaction(null);
            this.pw.println("</textarea></div>");
            this.pw.flush();
        }

        public void details(String tarFile, String mod) throws IOException, RepositoryException {
            this.details = true;
            String path = tarFile.replace('\\', '/');
            String[] elements = path.split("/");
            String workspace = elements[elements.length - 2];
            String fileName = elements[elements.length - 1];
            this.pw.print("<h2>Changes up to ");
            this.pw.print(WebConsoleUtil.escapeHtml((String)mod));
            this.pw.print(" (");
            this.pw.print(WebConsoleUtil.escapeHtml((String)fileName));
            this.pw.println(")</h2>");
            this.pw.println("<dl>");
            this.pw.flush();
            this.print(workspace, tarFile);
            this.pw.println("</dl>");
            this.pw.flush();
        }

        private void print(String workspace, String tarFile) throws IOException, RepositoryException {
            if (tarFile.length() == 0) {
                return;
            }
            final Session session = ChangeHistoryPlugin.this.repository.loginAdministrative(workspace);
            TarFile file = new TarFile(tarFile, 0, false, "r");
            file.scanIndex(0L, new IndexEntryVisitor(){

                public boolean isStopped() {
                    return false;
                }

                public void visitEntry(TarFile file, IndexEntry entry) throws IOException {
                    if (entry != null && entry.getType() == 0) {
                        NodeId ni = entry.getUUID();
                        String uuid = ni.toString();
                        if (uuid.endsWith("babecafebabe")) {
                            return;
                        }
                        uuid = ni.toString();
                        if (uuid.endsWith("babecafebabe")) {
                            return;
                        }
                        try {
                            Node node = session.getNodeByIdentifier(uuid);
                            Output.this.visitNode(node.getPath(), entry.getLength());
                        }
                        catch (RepositoryException e) {
                            // empty catch block
                        }
                    }
                }

                public void visitEndOfFile(TarFile file) {
                }

                public void visitTransaction(TarFile file, String transactionName) {
                    try {
                        String mod = new Timestamp(Long.parseLong(transactionName)).toString();
                        Output.this.startTransaction(mod);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                public boolean getFailOnError() {
                    return true;
                }
            }, true);
        }

        private void startTransaction(String mod) throws IOException {
            if (this.details) {
                this.pw.print("<dt>Changes at ");
                this.pw.print(WebConsoleUtil.escapeHtml((String)mod));
                this.pw.println("</dt>");
                return;
            }
            if (this.current != null && this.currentPath != null) {
                if (this.currentPath.length() == 0) {
                    this.currentPath = "/";
                }
                this.pw.print(WebConsoleUtil.escapeHtml((String)this.current.substring(0, 19)));
                this.pw.print(" ");
                this.pw.print(WebConsoleUtil.escapeHtml((String)this.currentPath));
                this.pw.print(" (");
                this.pw.print(this.currentCount);
                this.pw.print(this.currentCount == 1 ? " node" : " nodes");
                if (this.currentLength > 1024L) {
                    this.pw.print(", ");
                    this.pw.print(this.currentLength / 1024L);
                    this.pw.print(" KB");
                }
                this.pw.println(")");
            }
            this.current = mod;
            this.currentLength = 0L;
            this.currentCount = 0;
            this.currentPath = null;
        }

        private void visitNode(String path, long length) throws IOException {
            if (this.details) {
                this.pw.print("<dd>");
                this.pw.print(WebConsoleUtil.escapeHtml((String)path));
                if (length > 1024L) {
                    this.pw.print(" (");
                    this.pw.print(length / 1024L);
                    this.pw.print(" KB)");
                }
                this.pw.println("</dd>");
                this.pw.flush();
                return;
            }
            this.currentPath = this.getCommonPath(this.currentPath, path);
            this.currentLength += length;
            ++this.currentCount;
        }

        private String getCommonPath(String common, String path) {
            if (common == null) {
                common = path;
            } else if (!common.startsWith(path)) {
                int idx;
                while (!path.startsWith(common) && (idx = path.lastIndexOf(47)) >= 0) {
                    common = path.substring(0, idx);
                }
            }
            return common;
        }

        private String getUrl(String tarFileName, String mod, boolean details) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getUrl("/" + Utils.encodeUriComponent(tarFileName)));
            sb.append("?mod=");
            sb.append(Utils.encodeUriComponent(mod));
            if (details) {
                sb.append("&details=true");
            }
            return sb.toString();
        }

        private String getUrl(String path) {
            return this.root + "/" + ChangeHistoryPlugin.LABEL + path;
        }
    }
}

