/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl;

import com.day.crx.CRXRepository;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.core.SessionFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.AbstractNamespaceMappingRepository;
import org.osgi.framework.BundleContext;

public class SlingRepositoryWrapper
extends AbstractNamespaceMappingRepository
implements SlingRepository {
    private final CRXRepository delegatee;
    private final SessionFactory sessionFactory;
    private final String defaultWorkspaceName;

    public SlingRepositoryWrapper(CRXRepository delegatee, SessionFactory sessionFactory, String defaultWorkspaceName, BundleContext bundleContext) {
        this.delegatee = delegatee;
        this.sessionFactory = sessionFactory;
        this.defaultWorkspaceName = defaultWorkspaceName;
        this.setup(bundleContext);
    }

    public void dispose() {
        this.tearDown();
    }

    public String getDefaultWorkspace() {
        return this.defaultWorkspaceName;
    }

    public Session loginAdministrative(String workspace) throws RepositoryException {
        if (workspace == null) {
            workspace = this.defaultWorkspaceName;
        }
        return this.sessionFactory.createAdminSession(workspace);
    }

    public String[] getDescriptorKeys() {
        return this.delegatee.getDescriptorKeys();
    }

    public boolean isStandardDescriptor(String key) {
        return this.delegatee.isStandardDescriptor(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.delegatee.isSingleValueDescriptor(key);
    }

    public Value getDescriptorValue(String key) {
        return this.delegatee.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.delegatee.getDescriptorValues(key);
    }

    public String getDescriptor(String key) {
        return this.delegatee.getDescriptor(key);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.getNamespaceAwareSession(this.delegatee.login(credentials, workspaceName));
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.getNamespaceAwareSession(this.delegatee.login(credentials));
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.getNamespaceAwareSession(this.delegatee.login(workspaceName));
    }

    public Session login() throws LoginException, RepositoryException {
        return this.getNamespaceAwareSession(this.delegatee.login());
    }
}

