/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl.jmx;

import com.day.crx.core.cluster.ClusterController;
import com.day.crx.core.cluster.ClusterProperties;
import com.day.crx.core.config.CRXConfigurationEntityResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ClusterInstaller {
    private static final String EN_CLUSTER = "Cluster";
    private static final String EN_JOURNAL = "Journal";
    private static final String AN_CLASS = "class";
    private static final String EN_PARAM = "param";
    private static final String AN_NAME = "name";
    private static final String AN_VALUE = "value";
    private static final String EN_MODULES = "Modules";
    private static final String TJ_CLASS = "com.day.crx.persistence.tar.TarJournal";
    private static final String PN_PORT_LIST = "portList";
    private File parentFolder;
    private Document repository;
    private File bootstrapProps;
    private File repositoryHome;
    private File repositoryConfig;
    private int[] candidatePorts;

    public void init(File repHome, File repConfig, File bootstrapProps) throws Exception {
        this.parentFolder = repHome.getParentFile();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(CRXConfigurationEntityResolver.INSTANCE);
        this.repository = builder.parse(new InputSource(new FileInputStream(repConfig)));
        this.bootstrapProps = bootstrapProps;
    }

    public boolean isClustered() {
        if (this.repository == null) {
            String msg = "Installer not initialized.";
            throw new IllegalStateException(msg);
        }
        return ClusterInstaller.getElement(this.repository.getDocumentElement(), EN_CLUSTER) != null;
    }

    public void createCluster(File sharedFolder) throws Exception {
        if (this.repository == null) {
            String msg = "Installer not initialized.";
            throw new IllegalStateException(msg);
        }
        if (sharedFolder.exists()) {
            String msg = "Shared folder already exists: " + sharedFolder.getPath();
            throw new IllegalArgumentException(msg);
        }
        if (!sharedFolder.mkdirs()) {
            String msg = "Unable to create shared folder: " + sharedFolder.getPath();
            throw new IllegalArgumentException(msg);
        }
        this.createRepositoryHome();
        this.generateRepositoryConfig(sharedFolder.getPath());
        this.generateBootstrapProperties("Join cluster at " + sharedFolder.getPath());
    }

    public void joinCluster(File sharedFolder) throws Exception {
        if (this.repository == null) {
            String msg = "Installer not initialized.";
            throw new IllegalStateException(msg);
        }
        if (!sharedFolder.isDirectory()) {
            String msg = "Path is not a directory: " + sharedFolder.getPath();
            throw new IllegalArgumentException(msg);
        }
        this.createRepositoryHome();
        this.generateRepositoryConfig(sharedFolder.getPath());
        this.generateBootstrapProperties("Join cluster at " + sharedFolder.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinCluster(Properties props, String host, String clusterNodeId) throws Exception {
        if (this.repository == null) {
            String msg = "Installer not initialized.";
            throw new IllegalStateException(msg);
        }
        String sharedPath = null;
        boolean sharedNothing = Boolean.parseBoolean(props.getProperty("sharedNothing"));
        if (!sharedNothing) {
            String s = props.getProperty("sharedPath");
            if (s == null) {
                throw new IllegalArgumentException("Master controller is not configured to run with nothing shared. This requires a property named 'sharedPath', which was not found.");
            }
            File sharedFolder = new File(s);
            if (!sharedFolder.isDirectory()) {
                String msg = "Shared path is not a directory: " + sharedFolder.getPath();
                throw new IllegalArgumentException(msg);
            }
            sharedPath = sharedFolder.getPath();
        }
        this.createRepositoryHome();
        this.generateRepositoryConfig(sharedPath);
        clusterNodeId = this.generateClusterNodeId(clusterNodeId);
        ClusterProperties cprops = this.generateClusterProperties(props, clusterNodeId);
        ClusterController controller = ClusterController.getInstance((File)this.repositoryHome);
        if (this.candidatePorts != null) {
            controller.setCandidatePorts(this.candidatePorts);
        }
        controller.join(cprops.getClusterId(), InetAddress.getByName(host));
        try {
            if (controller.isMaster()) {
                throw new IOException("Unable to start slave on new repository home: " + this.repositoryHome);
            }
            controller.remoteCopy("repository/namespaces/ns_idx.properties");
            controller.remoteCopy("repository/namespaces/ns_reg.properties");
            controller.remoteCopy("repository/nodetypes/custom_nodetypes.xml");
            this.generateBootstrapProperties("Join cluster");
        }
        finally {
            controller.stop();
        }
    }

    public void leaveCluster() throws Exception {
        if (this.repository == null) {
            String msg = "Installer not initialized.";
            throw new IllegalStateException(msg);
        }
        if (this.bootstrapProps.exists() && !this.bootstrapProps.delete()) {
            String msg = "Unable to remove " + this.bootstrapProps.getPath();
            throw new IOException(msg);
        }
    }

    private void createRepositoryHome() throws IOException {
        DecimalFormat format = new DecimalFormat("0000");
        for (int i = 0; i < 10000; ++i) {
            File folder = new File(this.parentFolder, "crx." + format.format(i));
            if (folder.exists() || !folder.mkdir()) continue;
            this.repositoryHome = folder;
            return;
        }
        String msg = "Unable to create repository home in " + this.parentFolder.getParent();
        throw new IOException(msg);
    }

    private void generateRepositoryConfig(String sharedPath) throws TransformerException {
        Element journal;
        this.repositoryConfig = new File(this.repositoryHome, "repository.xml");
        Element root = this.repository.getDocumentElement();
        Element cluster = ClusterInstaller.getElement(root, EN_CLUSTER);
        if (cluster == null) {
            cluster = this.repository.createElement(EN_CLUSTER);
            root.appendChild(cluster);
            Element modules = ClusterInstaller.getElement(root, EN_MODULES);
            if (modules != null) {
                root.insertBefore(cluster, modules);
            }
        }
        if ((journal = ClusterInstaller.getElement(cluster, EN_JOURNAL)) != null) {
            String journalClass = journal.getAttribute(AN_CLASS);
            if (!TJ_CLASS.equals(journalClass)) {
                cluster.removeChild(journal);
                journal = null;
            } else {
                String s = ClusterInstaller.getParameter(journal, PN_PORT_LIST);
                if (s != null) {
                    this.candidatePorts = com.day.crx.cluster.ClusterController.parsePortList((String)s);
                }
            }
        }
        if (journal == null) {
            journal = this.repository.createElement(EN_JOURNAL);
            journal.setAttribute(AN_CLASS, TJ_CLASS);
            cluster.appendChild(journal);
        }
        if (sharedPath != null) {
            Element param = this.repository.createElement(EN_PARAM);
            param.setAttribute(AN_NAME, "sharedPath");
            param.setAttribute(AN_VALUE, sharedPath);
            journal.appendChild(param);
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Transformer transformer = factory.newTransformer();
        try {
            transformer.setOutputProperty("indent", "yes");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        transformer.transform(new DOMSource(root), new StreamResult(this.repositoryConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateBootstrapProperties(String comments) throws IOException {
        Properties props = new Properties();
        props.setProperty("repository.home", this.repositoryHome.getPath());
        props.setProperty("repository.config", new File(this.repositoryHome + File.separator + "repository.xml").getPath());
        FileOutputStream fos = new FileOutputStream(this.bootstrapProps);
        try {
            props.store(fos, comments);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private ClusterProperties generateClusterProperties(Properties props, String slaveId) throws IOException {
        ClusterProperties cprops = new ClusterProperties(new File(this.repositoryHome, "cluster.properties"), props);
        cprops.addMember(slaveId);
        cprops.save();
        return cprops;
    }

    private String generateClusterNodeId(String id) throws IOException {
        File file = new File(this.repositoryHome, "cluster_node.id");
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        FileUtils.writeStringToFile((File)file, (String)id);
        return id;
    }

    private static Element getElement(Element parent, String name) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    private static String getParameter(Element parent, String name) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element param;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !EN_PARAM.equals(child.getNodeName()) || !name.equals((param = (Element)child).getAttribute(AN_NAME))) continue;
            return param.getAttribute(AN_VALUE);
        }
        return null;
    }
}

