/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl.jmx;

import com.day.crx.core.data.ClusterDataStore;
import com.day.crx.persistence.tar.TarPersistenceManager;
import com.day.crx.persistence.tar.utils.DataStoreGarbageCollector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.api.management.MarkEventListener;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.core.data.GarbageCollector;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GarbageCollection {
    private static final int MAX_LINES_IN_MEMORY = 65536;
    private final Logger log = LoggerFactory.getLogger(GarbageCollection.class);
    private final Session session;
    private final RepositoryContext context;
    private final RepositoryImpl repository;
    private File dataStoreHome;
    private MyScanEventListener listener;
    private final boolean delete;
    private final long sleep;
    private final boolean fast;
    private GCThread fastGCThread;
    private Throwable fastGCException;
    long lastNodeCount;
    long lastDeletedCount;

    public GarbageCollection(Session session, RepositoryContext context, boolean delete, long sleep, boolean fast) throws RepositoryException {
        FileDataStore fs;
        this.session = session;
        this.context = context;
        this.repository = context.getRepository();
        this.delete = delete;
        this.sleep = sleep;
        this.fast = fast;
        DataStore store = this.repository.getConfig().getDataStore();
        String path = null;
        if (store instanceof FileDataStore) {
            fs = (FileDataStore)store;
            path = fs.getPath();
        }
        if (store instanceof ClusterDataStore) {
            fs = (ClusterDataStore)store;
            path = fs.getPath();
        }
        if (path != null) {
            this.dataStoreHome = new File(path);
            if (!this.dataStoreHome.isAbsolute()) {
                this.dataStoreHome = new File(this.repository.getConfig().getHomeDir(), path);
            }
        }
    }

    private boolean isFastGCApplicable() throws RepositoryException {
        if (this.dataStoreHome == null) {
            return false;
        }
        InternalVersionManagerImpl internalVersionManager = this.context.getInternalVersionManager();
        if (internalVersionManager != null && !(internalVersionManager.getPersistenceManager() instanceof TarPersistenceManager)) {
            return false;
        }
        for (String workspaceName : this.context.getWorkspaceManager().getWorkspaceNames()) {
            RepositoryImpl.WorkspaceInfo workspaceInfo = this.context.getWorkspaceInfo(workspaceName);
            if (workspaceInfo == null || workspaceInfo.getPersistenceManager() instanceof TarPersistenceManager) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flush(NavigableSet<String> nodes, List<File> files) throws IOException {
        File tempFile = File.createTempFile("dsgc", ".txt");
        tempFile.deleteOnExit();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "utf-8")));
            for (String s : nodes) {
                writer.println(s);
            }
            nodes.clear();
        }
        finally {
            files.add(tempFile);
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws RepositoryException {
        long time = System.currentTimeMillis();
        if (this.fast && this.isFastGCApplicable()) {
            this.fastGCThread = new GCThread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DataStoreGarbageCollector gc = new DataStoreGarbageCollector(GarbageCollection.this.repository.getConfig().getHomeDir(), 1, 0, 0);
                    gc.setLogSystemOut(false);
                    try {
                        File touchScript;
                        block31: {
                            gc.init();
                            gc.scanRepository();
                            String homeDir = GarbageCollection.this.repository.getConfig().getHomeDir();
                            touchScript = new File(homeDir, "dataStoreTouch.sh");
                            ArrayList files = new ArrayList();
                            TreeSet<String> nodes = new TreeSet<String>();
                            BufferedReader reader = null;
                            try {
                                File dsFile;
                                String line;
                                reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(touchScript), "utf-8"));
                                while ((line = ((LineNumberReader)reader).readLine()) != null && !this.isCancelled()) {
                                    if (nodes.size() == 65536) {
                                        GarbageCollection.flush(nodes, files);
                                    }
                                    nodes.add(line.replace("touch ", ""));
                                }
                                if (!files.isEmpty()) {
                                    GarbageCollection.flush(nodes, files);
                                    TreeSet<TempFileWrapper> merger = new TreeSet<TempFileWrapper>();
                                    for (File file : files) {
                                        merger.add(new TempFileWrapper(file));
                                    }
                                    PrintWriter writer = null;
                                    try {
                                        writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(homeDir, "dataStoreTouchSorted")), "utf-8")));
                                        String lastLine = "";
                                        do {
                                            if (this.isCancelled()) {
                                                break;
                                            }
                                            TempFileWrapper wrapper = (TempFileWrapper)merger.first();
                                            merger.remove(wrapper);
                                            if (!lastLine.equals(wrapper.current)) {
                                                writer.println(wrapper.current);
                                                lastLine = wrapper.current;
                                            }
                                            if (!wrapper.next()) continue;
                                            merger.add(wrapper);
                                        } while (!merger.isEmpty());
                                    }
                                    finally {
                                        if (writer != null) {
                                            writer.close();
                                        }
                                    }
                                    reader = null;
                                    try {
                                        reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(new File(homeDir, "dataStoreTouchSorted")), "utf-8"));
                                        while ((line = ((LineNumberReader)reader).readLine()) != null) {
                                            if (this.isCancelled()) {
                                                break block31;
                                            }
                                            dsFile = new File(GarbageCollection.this.dataStoreHome, line);
                                            if (!dsFile.exists()) continue;
                                            FileUtils.touch((File)dsFile);
                                        }
                                        break block31;
                                    }
                                    finally {
                                        if (reader != null) {
                                            reader.close();
                                        }
                                    }
                                }
                                for (String s : nodes) {
                                    if (this.isCancelled()) {
                                        break;
                                    }
                                    dsFile = new File(GarbageCollection.this.dataStoreHome, s);
                                    if (!dsFile.exists()) continue;
                                    FileUtils.touch((File)dsFile);
                                }
                            }
                            finally {
                                if (reader != null) {
                                    reader.close();
                                }
                                boolean clean = true;
                                for (File f : files) {
                                    clean &= f.delete();
                                }
                                if (!clean) {
                                    GarbageCollection.this.log.warn("Failed to delete all temporary files");
                                }
                            }
                        }
                        if (GarbageCollection.this.delete && !this.isCancelled()) {
                            GarbageCollection.this.repository.getConfig().getDataStore().deleteAllOlderThan(touchScript.lastModified() - 60000L);
                        }
                    }
                    catch (IOException e) {
                        GarbageCollection.this.fastGCException = new RepositoryException("I/O error occurred during garbage collection", (Throwable)e);
                    }
                    catch (RepositoryException e) {
                        GarbageCollection.this.fastGCException = e;
                    }
                    catch (Throwable e) {
                        GarbageCollection.this.fastGCException = e;
                    }
                }
            };
            this.fastGCThread.setName("Data Store Garbage Collection");
            this.fastGCThread.setDaemon(true);
            try {
                this.fastGCThread.start();
                this.fastGCThread.join();
            }
            catch (InterruptedException ignore) {
                this.log.info("Data store garbage collection cancelled.");
            }
            finally {
                if (this.fastGCException != null) {
                    if (this.fastGCException instanceof RuntimeException) {
                        throw (RuntimeException)this.fastGCException;
                    }
                    if (this.fastGCException instanceof RepositoryException) {
                        throw (RepositoryException)this.fastGCException;
                    }
                    this.log.error("Unexpected error during data store garbage collection", this.fastGCException);
                }
            }
        } else {
            this.lastNodeCount = 0L;
            this.lastDeletedCount = 0L;
            GarbageCollector gc = this.repository.createDataStoreGarbageCollector();
            try {
                this.verifyRepositoryIsWritable();
                this.testSetLastModified(gc.getDataStore());
                this.listener = new MyScanEventListener();
                gc.setMarkEventListener((MarkEventListener)this.listener);
                gc.setPersistenceManagerScan(false);
                gc.mark();
                this.sleep(5000L);
                this.lastNodeCount = this.listener.getNodeCount();
                this.log.info("Initial scan completed ({} nodes).", (Object)this.lastNodeCount);
                this.verifyRepositoryIsWritable();
                gc.setPersistenceManagerScan(false);
                gc.mark();
                this.log.info("Final scan completed.");
                this.verifyRepositoryIsWritable();
                if (this.delete) {
                    this.lastDeletedCount = gc.sweep();
                    this.log.info("Deleted {} unused objects.", (Object)this.lastDeletedCount);
                }
                this.log.info("Data store garbage collection successfully finished in {} second(s); scanned {} nodes.", (Object)((System.currentTimeMillis() - time) / 1000L), (Object)this.lastNodeCount);
            }
            catch (CancelGarbageCollectionException ignore) {
                this.log.info("Data store garbage collection cancelled.");
            }
            finally {
                gc.close();
                if (this.session != null) {
                    this.session.logout();
                }
            }
        }
    }

    public boolean stop() {
        if (this.listener != null) {
            this.listener.stop();
            return true;
        }
        GCThread t = this.fastGCThread;
        if (t != null && t.isAlive()) {
            t.cancel();
            t.interrupt();
        }
        return false;
    }

    void verifyRepositoryIsWritable() throws RepositoryException {
        String dummy = UUID.randomUUID().toString();
        Node dummyNode = this.session.getRootNode().addNode(dummy);
        this.session.save();
        dummyNode.remove();
        this.session.save();
        this.log.info("Repository access has been tested");
    }

    private void sleep(long ms) throws RepositoryException {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RepositoryException("Data store garbage collection interrupted", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testSetLastModified(DataStore ds) throws RepositoryException {
        String path;
        if (ds instanceof FileDataStore) {
            FileDataStore fds = (FileDataStore)ds;
            path = fds.getPath();
        } else {
            if (!(ds instanceof ClusterDataStore)) return;
            ClusterDataStore cds = (ClusterDataStore)ds;
            path = cds.getPath();
        }
        File file = new File(path, "test.tmp");
        try {
            file.delete();
            file.createNewFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!file.isFile()) {
            throw new RepositoryException("Could not create file " + file.getAbsolutePath());
        }
        try {
            long fileTime = file.lastModified();
            long sysTime = System.currentTimeMillis();
            if (Math.abs(fileTime - sysTime) > 4000L) {
                throw new RepositoryException("File time does not match system time: File last modified = " + new Timestamp(fileTime) + " Current system time = " + new Timestamp(sysTime));
            }
            long lastTime = sysTime + 10000L;
            while (sysTime < lastTime) {
                sysTime = System.currentTimeMillis();
                file.setLastModified(sysTime);
                if (file.lastModified() != fileTime) {
                    return;
                }
                Thread.sleep(200L);
            }
            throw new RepositoryException("Could not set the last modified time for more than 10 seconds.");
        }
        catch (InterruptedException e) {
            throw new RepositoryException("Interrupted", (Throwable)e);
        }
        finally {
            file.delete();
        }
    }

    static abstract class GCThread
    extends Thread {
        private volatile boolean cancelled;

        GCThread() {
        }

        void cancel() {
            this.cancelled = true;
        }

        boolean isCancelled() {
            return this.cancelled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TempFileWrapper
    implements Comparable<TempFileWrapper> {
        private final File file;
        private final LineNumberReader reader;
        private String current;

        TempFileWrapper(File file) throws IOException {
            this.file = file;
            this.reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            this.current = this.reader.readLine();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean next() throws IOException {
            if (this.current == null) {
                return false;
            }
            try {
                this.current = this.reader.readLine();
                boolean bl = this.current != null;
                return bl;
            }
            finally {
                if (this.current == null) {
                    this.reader.close();
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof TempFileWrapper) {
                TempFileWrapper wrapper = (TempFileWrapper)obj;
                return wrapper.file.equals(this.file);
            }
            return false;
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        @Override
        public int compareTo(TempFileWrapper wrapper) {
            int res = 0;
            if (wrapper.file != this.file && (res = this.current.compareTo(wrapper.current)) == 0) {
                res = wrapper.file.getName().compareTo(this.file.getName());
            }
            return res;
        }
    }

    class MyScanEventListener
    implements MarkEventListener {
        private long nodeCount = 0L;
        private long lastLogTime = System.currentTimeMillis();
        private boolean shallStop = false;

        MyScanEventListener() {
        }

        public long getNodeCount() {
            return this.nodeCount;
        }

        public void stop() {
            this.shallStop = true;
        }

        public void beforeScanning(Node n) throws RepositoryException {
            long now;
            if (this.shallStop) {
                throw new CancelGarbageCollectionException();
            }
            ++this.nodeCount;
            if (this.nodeCount % 10L == 0L && GarbageCollection.this.sleep > 0L) {
                GarbageCollection.this.sleep(GarbageCollection.this.sleep);
            }
            if ((now = System.currentTimeMillis()) > this.lastLogTime + 10000L) {
                GarbageCollection.this.log.info("Scanning " + this.getNodeName(n));
                this.lastLogTime = now;
            }
        }

        public String getNodeName(Node n) throws RepositoryException {
            if (n != null) {
                return n.getPath();
            }
            return "item #" + this.nodeCount;
        }
    }

    class CancelGarbageCollectionException
    extends RepositoryException {
        public CancelGarbageCollectionException() {
            super("GarbageCollection cancelled due to user request");
        }
    }
}

