/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl.jmx;

import com.day.crx.sling.server.impl.jmx.ManagedRepository;
import com.day.crx.sling.server.jmx.ManagedRepositoryMBean;
import java.util.Dictionary;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectionConfig {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollectionConfig.class);
    static final String JOB_NAME = "jobname";
    static final String SCHEDULE = "schedule";
    static final String DELETE_NODES = "deleteNodes";
    private String jobName = null;
    private boolean deleteNodes = false;
    private String schedule = null;
    private ManagedRepositoryMBean managedRepositoryMBean;
    private Scheduler scheduler;

    private void activate(ComponentContext context) throws Exception {
        Dictionary props = context.getProperties();
        this.jobName = PropertiesUtil.toString(props.get(JOB_NAME), (String)GarbageCollectionConfig.class.getName());
        this.schedule = PropertiesUtil.toString(props.get(SCHEDULE), null);
        this.deleteNodes = PropertiesUtil.toBoolean(props.get(DELETE_NODES), (boolean)false);
        Runnable job = new Runnable(){

            public void run() {
                if (GarbageCollectionConfig.this.managedRepositoryMBean instanceof ManagedRepository) {
                    try {
                        ManagedRepository m = (ManagedRepository)GarbageCollectionConfig.this.managedRepositoryMBean;
                        m.runDataStoreGarbageCollection(GarbageCollectionConfig.this.jobName, GarbageCollectionConfig.this.deleteNodes, true);
                    }
                    catch (Exception e) {
                        log.error("error executing garbage collection job " + GarbageCollectionConfig.this.jobName, (Throwable)e);
                    }
                } else {
                    log.error("can't perform scheduled garbage collection because MBean {} is not a ManagedRepository", (Object)GarbageCollectionConfig.this.managedRepositoryMBean);
                }
            }
        };
        try {
            this.scheduler.removeJob(this.jobName);
            if (this.schedule != null && !this.schedule.isEmpty()) {
                this.scheduler.addJob(this.jobName, (Object)job, null, this.schedule, false);
            }
        }
        catch (Exception e) {
            log.error("Can't add job", (Throwable)e);
        }
    }

    private void deactivate() {
        if (this.jobName != null) {
            this.scheduler.removeJob(this.jobName);
            log.info("deactivated garbage collection job {}", (Object)this.jobName);
        }
    }

    protected void bindManagedRepositoryMBean(ManagedRepositoryMBean managedRepositoryMBean) {
        this.managedRepositoryMBean = managedRepositoryMBean;
    }

    protected void unbindManagedRepositoryMBean(ManagedRepositoryMBean managedRepositoryMBean) {
        if (this.managedRepositoryMBean == managedRepositoryMBean) {
            this.managedRepositoryMBean = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }
}

