/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl.jmx;

import com.adobe.granite.jmx.annotation.OpenAnnotatedStandardMBean;
import com.adobe.granite.license.ProductInfoService;
import com.day.crx.CRXRepository;
import com.day.crx.CRXSession;
import com.day.crx.License;
import com.day.crx.core.CRXRepositoryImpl;
import com.day.crx.core.backup.BackupManager;
import com.day.crx.core.cluster.ClusterController;
import com.day.crx.core.cluster.ClusterNodeInfo;
import com.day.crx.mount.virtual.VirtualRepository;
import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.index.IndexSet;
import com.day.crx.sling.server.ExclusiveAccess;
import com.day.crx.sling.server.PropertyAccess;
import com.day.crx.sling.server.impl.SlingRepositoryWrapper;
import com.day.crx.sling.server.impl.jmx.ClusterInstaller;
import com.day.crx.sling.server.impl.jmx.ClusterNodeInfoTabular;
import com.day.crx.sling.server.impl.jmx.GarbageCollection;
import com.day.crx.sling.server.impl.jmx.SimpleMap;
import com.day.crx.sling.server.impl.virtual.VirtualRepositoryWrapper;
import com.day.crx.sling.server.jmx.ManagedRepositoryMBean;
import com.day.io.disk.DiskSpaceUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.TabularData;
import org.apache.jackrabbit.api.jmx.QueryStatManagerMBean;
import org.apache.jackrabbit.api.stats.QueryStat;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.SessionFactory;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.jmx.QueryStatManager;
import org.apache.jackrabbit.core.stats.QueryStatCore;
import org.apache.jackrabbit.core.stats.RepositoryStatisticsImpl;
import org.apache.jackrabbit.util.Base64;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedRepository
extends OpenAnnotatedStandardMBean
implements ManagedRepositoryMBean {
    private static final Logger log = LoggerFactory.getLogger(ManagedRepository.class);
    static final String JMX_OBJECTNAME = "jmx.objectname";
    static final String REPOSITORY_HOME = "repository.home";
    static final String REPOSITORY_CONFIG = "repository.config";
    static final String BOOTSTRAP_PROPERTIES = "bootstrap.properties";
    static final String VIRTUAL_REPOSITORY_CONFIG_PATH = "repository.virtual.config.path";
    static final String VIRTUAL_REPOSITORY_CONFIG_WORKSPACE_NAME = "repository.virtual.config.workspace";
    private ProductInfoService productInfo;
    private ComponentContext componentContext;
    private File bootstrapFile;
    private File repositoryHome;
    private File repositoryConfig;
    private RepositoryContext context;
    private CRXRepositoryImpl repository;
    private VirtualRepositoryWrapper virtualRepositoryWrapper;
    private ClusterController cluster;
    private LinkedList<ServiceRegistration> services = new LinkedList();
    private Integer dataStoreGarbageCollectionDelay = 10;
    private Double tarOptimizationDelay = 1.0;
    private long lastNodeCount;
    private long lastDeletedCount;
    private String lastGCRun;
    private GarbageCollection gc;

    public ManagedRepository() throws NotCompliantMBeanException {
        super(ManagedRepositoryMBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(ComponentContext context) throws Exception {
        this.componentContext = context;
        PropertyAccess pa = new PropertyAccess(context);
        this.bootstrapFile = pa.getBootstrapFile();
        this.repositoryHome = new File(pa.getProperty(REPOSITORY_HOME)).getAbsoluteFile();
        this.repositoryConfig = new File(pa.getProperty(REPOSITORY_CONFIG)).getAbsoluteFile();
        this.context = CRXRepositoryImpl.create((File)this.repositoryHome, (File)this.repositoryConfig);
        boolean ok = false;
        try {
            if (!ExclusiveAccess.isLocked(this.repositoryHome)) {
                this.repository = (CRXRepositoryImpl)this.context.getRepository();
                this.cluster = this.repository.getClusterController();
                this.repository.setLicense((License)new BackwardsCompatibleLicense());
            }
            this.virtualRepositoryWrapper = new VirtualRepositoryWrapper();
            this.virtualRepositoryWrapper.setConfigPath(pa.getProperty(VIRTUAL_REPOSITORY_CONFIG_PATH));
            this.virtualRepositoryWrapper.setConfigWspName(pa.getProperty(VIRTUAL_REPOSITORY_CONFIG_WORKSPACE_NAME));
            this.virtualRepositoryWrapper.wrap((CRXSession)this.repository.internalGetSystemSession(this.context.getWorkspaceManager().getDefaultWorkspaceName()), context.getBundleContext());
            this.registerRepository(context.getBundleContext());
            this.registerJMX(context.getBundleContext());
            ok = true;
        }
        finally {
            if (!ok) {
                log.error("Repository activation failed, so shutting down.");
                this.deactivate(context);
            }
        }
    }

    private void registerRepository(BundleContext context) throws RepositoryException {
        VirtualRepository repo = this.virtualRepositoryWrapper.getRepository();
        if (repo == null) {
            repo = this.repository;
        }
        log.info("Using repository instance: " + repo.toString());
        String defaultWorkspaceName = this.context.getWorkspaceManager().getDefaultWorkspaceName();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("name", "virtual-crx");
        properties.put("service.description", "Adobe CRX Repository");
        properties.put("service.vendor", this.repository.getDescriptor("jcr.repository.vendor"));
        this.services.addFirst(context.registerService(new String[]{Repository.class.getName(), CRXRepository.class.getName()}, (Object)repo, properties));
        this.services.addFirst(context.registerService(SlingRepository.class.getName(), (Object)new SlingRepositoryWrapper((CRXRepository)repo, new SessionFactory(this.context), defaultWorkspaceName, context), properties));
    }

    private void registerJMX(BundleContext context) throws Exception {
        RepositoryStatisticsImpl statistics = this.context.getRepositoryStatistics();
        for (RepositoryStatistics.Type type : RepositoryStatistics.Type.values()) {
            this.addJmxService(context, "TimeSeries", type.name().toString(), null, new StandardMBean(statistics.getTimeSeries(type), TimeSeries.class));
        }
        QueryStatCore queryStat = this.context.getStatManager().getQueryStat();
        queryStat.setEnabled(true);
        this.addJmxService(context, "QueryStat", null, null, new StandardMBean(new QueryStatManager((QueryStat)queryStat), QueryStatManagerMBean.class));
        this.registerWorkspacesJMX(context);
    }

    private void registerWorkspacesJMX(BundleContext context) {
        String[] workspaceNames;
        for (String workspaceName : workspaceNames = this.getWorkspaceNames()) {
            this.registerWorkspaceJMX(context, workspaceName);
        }
    }

    private void registerWorkspaceJMX(BundleContext context, String workspaceName) {
        this.registerWorkspaceTypeJMX(context, workspaceName, "WS_SIZE_COUNTER");
        this.registerWorkspaceTypeJMX(context, workspaceName, "WS_NODE_COUNTER");
    }

    private void registerWorkspaceTypeJMX(BundleContext bundleContext, String workspaceName, String type) {
        String timeSeriesType;
        RepositoryStatisticsImpl statistics;
        TimeSeries timeSeries;
        StandardMBean mbean;
        if (bundleContext == null) {
            bundleContext = this.componentContext.getBundleContext();
        }
        if ((mbean = this.getMBeanForTimeSeries(timeSeries = (statistics = this.context.getRepositoryStatistics()).getTimeSeries(timeSeriesType = type + "_" + workspaceName, false))) != null) {
            this.addJmxService(bundleContext, "TimeSeries", type, workspaceName, mbean);
        }
    }

    private StandardMBean getMBeanForTimeSeries(TimeSeries timeSeries) {
        try {
            return new StandardMBean(timeSeries, TimeSeries.class);
        }
        catch (NotCompliantMBeanException e) {
            log.error("Error registering to JMX", (Throwable)e);
            return null;
        }
    }

    private <T> void addJmxService(BundleContext context, String type, String name, String id, Object mbean) {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put("type", type);
        if (name != null) {
            attributes.put("name", name);
        }
        if (id != null) {
            attributes.put("id", id);
        }
        try {
            ObjectName on = new ObjectName("com.adobe.granite", attributes);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put(JMX_OBJECTNAME, on.toString());
            this.services.addFirst(context.registerService(mbean.getClass().getName(), mbean, properties));
        }
        catch (Exception e) {
            log.error("Error registering to JMX", (Throwable)e);
        }
    }

    public void modified(ComponentContext context) throws Exception {
        this.deactivate(context);
        this.activate(context);
    }

    public void deactivate(ComponentContext context) {
        for (ServiceRegistration service : this.services) {
            service.unregister();
        }
        this.services.clear();
        this.repository.shutdown();
        this.virtualRepositoryWrapper.destroy();
    }

    @Override
    public String getName() {
        return this.repository.getDescriptor("jcr.repository.name");
    }

    @Override
    public String getVersion() {
        return this.repository.getDescriptor("jcr.repository.version");
    }

    @Override
    public String getCustomerName() {
        com.adobe.granite.license.License license = this.productInfo.getLicense();
        return license != null ? license.getCustomerName() : "";
    }

    @Override
    public String getLicenseKey() {
        com.adobe.granite.license.License license = this.productInfo.getLicense();
        return license != null ? license.getDownloadId() : "";
    }

    @Override
    public Long getAvailableDiskSpace() {
        File home = this.repository.getHomeDir();
        return DiskSpaceUtil.getInstance().getAvailableDiskSpaceMB(home);
    }

    @Override
    public Integer getMaximumNumberOfOpenFiles() {
        return DiskSpaceUtil.getInstance().getMaxOpenFiles();
    }

    @Override
    public Boolean getSessionTracker() {
        return Boolean.getBoolean("crx.debug.sessions");
    }

    @Override
    public void setSessionTracker(Boolean tracker) {
        System.setProperty("crx.debug.sessions", Boolean.toString(tracker));
    }

    @Override
    public TabularData getDescriptors() {
        SimpleMap map = new SimpleMap();
        for (String key : this.repository.getDescriptorKeys()) {
            String value = this.repository.getDescriptor(key);
            map.put(key, value);
        }
        return map.toTabularData();
    }

    @Override
    public String[] getWorkspaceNames() {
        return this.context.getWorkspaceManager().getWorkspaceNames();
    }

    @Override
    public void createWorkspace(String name) throws RepositoryException {
        this.context.getWorkspaceManager().createWorkspace(name);
        this.registerWorkspaceJMX(null, name);
    }

    @Override
    public String getDataStoreGarbageCollectionLastRunInfo() {
        return this.lastGCRun;
    }

    public void setDataStoreGarbageCollectionLastRunInfo(String lastRun) {
        this.lastGCRun = lastRun;
    }

    @Override
    public Integer getDataStoreGarbageCollectionDelay() {
        return this.dataStoreGarbageCollectionDelay;
    }

    @Override
    public void setDataStoreGarbageCollectionDelay(Integer delay) {
        this.dataStoreGarbageCollectionDelay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDataStoreGarbageCollection(String jobName, Boolean delete, Boolean fast) throws RepositoryException {
        if (this.gc != null) {
            throw new RepositoryException("GarbageCollection already running");
        }
        this.gc = new GarbageCollection(this.createAdminSession(), this.context, delete, this.dataStoreGarbageCollectionDelay.intValue(), fast);
        try {
            this.lastGCRun = (jobName == null ? "triggered via JMX" : "scheduled job '" + jobName + "'") + " started " + new Date().toString();
            this.gc.run();
        }
        finally {
            this.lastNodeCount = this.gc.lastNodeCount;
            this.lastDeletedCount = this.gc.lastDeletedCount;
            this.lastGCRun = this.lastGCRun + ", finished " + new Date().toString();
            this.gc = null;
        }
    }

    @Override
    public void runDataStoreGarbageCollection(Boolean delete) throws RepositoryException {
        this.runDataStoreGarbageCollection(null, delete, true);
    }

    @Override
    public void runDataStoreClassicGarbageCollection(Boolean delete) throws RepositoryException {
        this.runDataStoreGarbageCollection(null, delete, false);
    }

    @Override
    public String stopDataStoreGarbageCollection() {
        boolean stopped = this.gc != null ? this.gc.stop() : false;
        return stopped ? "GarbageCollection stopped" : "no GarbageCollection running";
    }

    private Session createAdminSession() throws RepositoryException {
        String ws = this.context.getWorkspaceManager().getDefaultWorkspaceName();
        return new SessionFactory(this.context).createAdminSession(ws);
    }

    @Override
    public Long getLastDataStoreGarbageCollectionNodeCount() {
        return this.lastNodeCount;
    }

    public void setLastDataStoreGarbageCollectionNodeCount(long nodeCount) {
        this.lastNodeCount = nodeCount;
    }

    @Override
    public Long getLastDataStoreGarbageCollectionDeletedCount() {
        return this.lastDeletedCount;
    }

    public void setLastDataStoreGarbageCollectionDeletedCount(long deletedNodeCount) {
        this.lastDeletedCount = deletedNodeCount;
    }

    @Override
    public Integer getBackupDelay() {
        return BackupManager.getInstance().getDelay();
    }

    @Override
    public void setBackupDelay(Integer delay) {
        BackupManager.getInstance().setDelay(delay.intValue());
    }

    @Override
    public Boolean getBackupInProgress() {
        return BackupManager.getInstance().isBackupInProgress();
    }

    @Override
    public Integer getBackupProgress() {
        return BackupManager.getInstance().getBackupProgress();
    }

    @Override
    public String getCurrentBackupTarget() {
        File target = BackupManager.getInstance().getBackupTarget();
        if (target == null) {
            return null;
        }
        return target.getAbsolutePath();
    }

    @Override
    public Boolean getBackupWasSuccessful() {
        return BackupManager.getInstance().getBackupWasSuccessful();
    }

    @Override
    public String getBackupResult() {
        return BackupManager.getInstance().getBackupResult();
    }

    @Override
    public void startBackup(String target) throws RepositoryException {
        BackupManager.getInstance().startBackup(this.repository, target);
    }

    @Override
    public void startBackup(String installDir, String target) throws RepositoryException {
        if (installDir == null || installDir.length() == 0) {
            BackupManager.getInstance().startBackup(this.repository, target);
        } else {
            try {
                BackupManager.getInstance().startBackup(new File(installDir).getCanonicalFile(), target);
            }
            catch (IOException e) {
                throw new RepositoryException("failed to determine canonical path of " + installDir, (Throwable)e);
            }
        }
    }

    @Override
    public void cancelBackup() {
        BackupManager.getInstance().cancelBackup();
    }

    @Override
    public void blockRepositoryWrites() throws RepositoryException {
        BackupManager.getInstance().notifyBeforeBackup();
    }

    @Override
    public void unblockRepositoryWrites() {
        BackupManager.getInstance().notifyAfterBackup();
    }

    @Override
    public Long getTarOptimizationRunningSince() {
        OptimizeThread optimize = OptimizeThread.getInstance();
        for (TarSetHandler tarset : optimize.getTarSets()) {
            File file = new File(tarset.getLocalPath(), "optimizeNow.tar");
            if (!file.exists()) continue;
            return file.lastModified();
        }
        return 0L;
    }

    @Override
    public Double getTarOptimizationDelay() {
        return this.tarOptimizationDelay;
    }

    @Override
    public void setTarOptimizationDelay(Double delay) {
        this.tarOptimizationDelay = delay;
    }

    @Override
    public Long getTarOptimizationWork() {
        return OptimizeThread.getInstance().getOptimizationWorkKBytes();
    }

    @Override
    public Long getTarOptimizationRate() {
        return OptimizeThread.getInstance().getOptimizationRateKBytesPerSecond();
    }

    @Override
    public void startTarOptimization() throws RepositoryException {
        try {
            OptimizeThread optimize = OptimizeThread.getInstance();
            for (TarSetHandler tarset : optimize.getTarSets()) {
                tarset.setOptimizeSleep(this.tarOptimizationDelay.doubleValue());
                File file = new File(tarset.getLocalPath(), "optimize.tar");
                file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to start Tar PM optimization", (Throwable)e);
        }
    }

    @Override
    public void stopTarOptimization() throws RepositoryException {
        OptimizeThread optimize = OptimizeThread.getInstance();
        for (TarSetHandler tarset : optimize.getTarSets()) {
            File file = new File(tarset.getLocalPath(), "optimizeNow.tar");
            file.delete();
        }
    }

    @Override
    public void tarIndexMerge(Boolean background) throws RepositoryException {
        try {
            OptimizeThread optimize = OptimizeThread.getInstance();
            for (TarSetHandler tarset : optimize.getTarSets()) {
                IndexSet index = tarset.getIndex();
                if (background.booleanValue()) {
                    index.mergeTopIndexFiles();
                    continue;
                }
                index.mergeTopIndexFilesSynchronous();
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Tar PM index merge failure", (Throwable)e);
        }
    }

    @Override
    public TabularData getClusterProperties() {
        SimpleMap map = new SimpleMap();
        if (this.cluster != null) {
            Properties properties = this.cluster.getProperties();
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                map.put(name, properties.getProperty(name));
            }
        }
        return map.toTabularData();
    }

    @Override
    public TabularData getClusterNodes() {
        ClusterNodeInfoTabular map = new ClusterNodeInfoTabular();
        if (this.cluster != null) {
            try {
                ClusterNodeInfo master = this.cluster.getMasterInfo();
                if (master != null) {
                    map.add(master);
                }
            }
            catch (UnknownHostException ignore) {
                // empty catch block
            }
            ClusterNodeInfo[] slaves = this.cluster.getSlaveInfos();
            if (slaves != null) {
                for (ClusterNodeInfo slave : this.cluster.getSlaveInfos()) {
                    map.add(slave);
                }
            }
        }
        return map.toTabularData();
    }

    @Override
    public String getClusterId() {
        return this.cluster == null ? null : this.cluster.getClusterId();
    }

    @Override
    public String getClusterMasterId() {
        try {
            ClusterNodeInfo master;
            if (this.cluster != null && (master = this.cluster.getMasterInfo()) != null) {
                return master.getId();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getClusterNodeId() {
        return this.cluster == null ? null : this.cluster.getClusterNodeId();
    }

    @Override
    public Long getClusterNodeRevision() {
        ClusterNode clusterNode = this.repository.getClusterNode();
        return clusterNode != null ? clusterNode.getRevision() : 0L;
    }

    @Override
    public void becomeClusterMaster() throws RepositoryException {
        if (this.cluster == null) {
            throw new RepositoryException("Unable to become cluster master because clustering is disabled");
        }
        try {
            this.cluster.becomeMaster();
        }
        catch (Exception e) {
            throw new RepositoryException("Unable to become cluster master", (Throwable)e);
        }
    }

    @Override
    public String joinCluster(String master, String username, String password) throws Exception {
        URL url;
        String path;
        if (this.cluster == null) {
            throw new RepositoryException("Unable to join cluster because clustering is disabled");
        }
        master = this.normalize(master);
        username = this.normalize(username);
        password = this.normalize(password);
        if (master == null) {
            return "Error: Cluster master not specified";
        }
        log.info("Joining cluster {}", (Object)master);
        if (!master.startsWith("http://") && !master.startsWith("https://")) {
            master = "http://" + master;
        }
        if (!master.endsWith("/")) {
            master = master + "/";
        }
        if (!(path = (url = new URL(master)).getPath()).endsWith("/cluster.jsp")) {
            url = new URL(url, "crx/config/cluster.jsp");
        }
        Properties props = null;
        try {
            props = this.readProperties(url, username, password);
        }
        catch (Exception e) {
            return "Error: Could not read cluster properties";
        }
        String clusterNodeId = this.cluster.getClusterNodeId();
        ClusterInstaller installer = new ClusterInstaller();
        installer.init(this.repositoryHome, this.repositoryConfig, this.bootstrapFile);
        try {
            installer.joinCluster(props, url.getHost(), clusterNodeId);
        }
        catch (IOException e) {
            return "Error: Cluster join failed. " + e.getMessage();
        }
        this.modified(this.componentContext);
        return "Success";
    }

    private String normalize(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(URL url, String username, String password) throws IOException {
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("Accept", "text/plain");
        if (username != null && password != null) {
            connection.addRequestProperty("Authorization", "Basic " + Base64.encode((String)(username + ":" + password)));
        }
        InputStream stream = connection.getInputStream();
        try {
            Properties properties = new Properties();
            properties.load(stream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            stream.close();
        }
    }

    @Override
    public String getHomeDir() {
        return this.repositoryHome.getPath();
    }

    @Override
    public String traversalCheck(String rootNodeName, Boolean logEach, Boolean fixInconsistencies) {
        return this.performCheck(rootNodeName, fixInconsistencies, true, logEach);
    }

    @Override
    public String consistencyCheck(String rootNodeName, Boolean fixInconsistencies) {
        return this.performCheck(rootNodeName, fixInconsistencies, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String performCheck(String rootNodeName, boolean fixInconsistencies, boolean travMode, boolean logEach) {
        SessionImpl session = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        try {
            String ws = this.context.getWorkspaceManager().getDefaultWorkspaceName();
            session = new SessionFactory(this.context).createAdminSession(ws);
            Node rootNode = session.getNode(rootNodeName == null || rootNodeName.length() == 0 ? "/" : rootNodeName);
            pw.println(travMode ? "Performing traversal check..." : "Performing consistency check starting with " + rootNode.getPath());
            if (fixInconsistencies && session instanceof SessionImpl) {
                session.setAttribute("org.apache.jackrabbit.autoFixCorruptions", "true");
                pw.println("Automatically fixing inconsistencies (see log file for details)...");
            }
            Stats s = new Stats();
            s.calcSize = true;
            long t1 = System.currentTimeMillis();
            if (travMode) {
                ManagedRepository.traverse(pw, rootNode, s, logEach);
            } else {
                ManagedRepository.dataStoreConsistency(pw, rootNode, s);
            }
            long t = System.currentTimeMillis() - t1;
            pw.println((travMode ? "Traversed " : "Checked ") + s.numNodes + " nodes, " + s.numProps + " properties in " + t + " ms");
            pw.println(s.sizeProps + " bytes");
        }
        catch (Exception e) {
            log.error((travMode ? "Traversal" : "Consistency") + " check failed", (Throwable)e);
            pw.println("check failed: " + e.toString());
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        pw.flush();
        return ((Object)out).toString();
    }

    private static void traverse(PrintWriter out, Node n, Stats s, boolean logEachNode) throws IOException {
        s.numNodes++;
        try {
            long now = System.currentTimeMillis();
            if (logEachNode || s.nextLog == 0L || now > s.nextLog) {
                out.println(n.getPath());
                out.flush();
                s.nextLog = 5000L + now;
            }
            PropertyIterator piter = n.getProperties();
            while (piter.hasNext()) {
                Property p = piter.nextProperty();
                s.numProps++;
                if (!s.calcSize) continue;
                if (p.isMultiple()) {
                    for (long l : p.getLengths()) {
                        s.sizeProps += l;
                    }
                    continue;
                }
                s.sizeProps += p.getLength();
            }
            NodeIterator iter = n.getNodes();
            while (iter.hasNext()) {
                ManagedRepository.traverse(out, iter.nextNode(), s, logEachNode);
            }
        }
        catch (RepositoryException e) {
            try {
                out.println("Error while traversing " + n.getPath() + ": " + e.toString());
            }
            catch (RepositoryException e1) {
                out.println("Error while traversing " + n + ": " + e.toString());
            }
        }
    }

    private static void dataStoreConsistency(PrintWriter out, Node n, Stats s) throws IOException {
        s.numNodes++;
        try {
            PropertyIterator piter = n.getProperties();
            while (piter.hasNext()) {
                Property p = piter.nextProperty();
                try {
                    if (p.getType() == 2) {
                        if (p.getDefinition().isMultiple()) {
                            Value[] values = p.getValues();
                            for (int i = 0; i < values.length; ++i) {
                                values[i].getStream().close();
                            }
                        } else {
                            p.getStream().close();
                        }
                    }
                }
                catch (Exception e) {
                    String es = e.toString();
                    int idx = es.indexOf("datastore");
                    if (idx >= 0) {
                        if ((idx = (es = es.substring(idx + "datastore".length())).indexOf(58)) >= 0) {
                            es = es.substring(0, idx);
                        }
                        out.println("missing file: " + es);
                    } else {
                        out.println("error: " + e.toString());
                    }
                    out.println("in property: " + p.toString());
                    s.numErrors++;
                    out.flush();
                }
                s.numProps++;
            }
            NodeIterator iter = n.getNodes();
            while (iter.hasNext()) {
                ManagedRepository.dataStoreConsistency(out, iter.nextNode(), s);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            try {
                out.println("Error while traversing " + n.getPath() + ": " + e.toString());
            }
            catch (RepositoryException e1) {
                out.println("Error while traversing " + n + ": " + e.toString());
            }
        }
    }

    protected void bindProductInfo(ProductInfoService productInfoService) {
        this.productInfo = productInfoService;
    }

    protected void unbindProductInfo(ProductInfoService productInfoService) {
        if (this.productInfo == productInfoService) {
            this.productInfo = null;
        }
    }

    private static class Stats {
        private long numNodes;
        private long numProps;
        private long numErrors;
        private long sizeProps;
        private long nextLog;
        private boolean calcSize;

        private Stats() {
        }
    }

    private class BackwardsCompatibleLicense
    implements License {
        private BackwardsCompatibleLicense() {
        }

        public String getDownloadId() {
            return ManagedRepository.this.getLicenseKey();
        }

        public String getCustomerName() {
            return ManagedRepository.this.getCustomerName();
        }

        public String getProductVersion() {
            com.adobe.granite.license.License license = ManagedRepository.this.productInfo.getLicense();
            if (license != null) {
                return license.getProductVersion();
            }
            return "";
        }

        public String getProductName() {
            com.adobe.granite.license.License license = ManagedRepository.this.productInfo.getLicense();
            if (license != null) {
                return license.getProductName();
            }
            return "";
        }
    }
}

