/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl.virtual;

import com.day.crx.mount.virtual.MountPoint;
import com.day.crx.mount.virtual.WorkspaceAddress;
import com.day.crx.sling.server.impl.virtual.OsgiWorkspaceAddress;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiMountPoint
extends MountPoint {
    private static final Logger log = LoggerFactory.getLogger(OsgiMountPoint.class);
    private Repository repository;
    private BundleContext bundleContext;

    public OsgiMountPoint(BundleContext bundleContext, OsgiWorkspaceAddress address, String path, Map<String, ?> parameters) {
        super((WorkspaceAddress)address, path, parameters);
        this.bundleContext = bundleContext;
    }

    protected synchronized Repository getRepository() throws RepositoryException {
        if (this.repository == null) {
            String ref = this.address.repositoryReference;
            String filterString = this.address.getName();
            try {
                Filter filter = this.bundleContext.createFilter(filterString);
                ServiceTracker tracker = new ServiceTracker(this.bundleContext, filter, null);
                tracker.open();
                Object obj = tracker.getService();
                if (obj instanceof Repository) {
                    this.repository = (Repository)tracker.getService();
                }
                tracker.close();
                if (this.repository == null) {
                    log.warn("No repository returned using filter: {}", (Object)filter.toString());
                }
            }
            catch (InvalidSyntaxException e) {
                throw new RepositoryException("Invalid Osgi workspace address filter", (Throwable)e);
            }
        }
        return this.repository;
    }
}

