/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token;

import com.day.text.Text;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenCookie {
    private static final Logger log = LoggerFactory.getLogger(TokenCookie.class);
    public static final String NAME = "login-token";
    public static final String PARAM_NAME = "j_login_token";
    public static final String ATTR_NAME = TokenCookie.class.getName();
    private final Map<String, Info> infos = new TreeMap<String, Info>();

    public Map<String, Info> getInfos() {
        return this.infos;
    }

    public static TokenCookie fromRequest(HttpServletRequest request) {
        TokenCookie t = (TokenCookie)request.getAttribute(ATTR_NAME);
        if (t == null) {
            String tokenString = TokenCookie.getCookie(request, NAME);
            if (tokenString == null || tokenString.length() == 0) {
                tokenString = request.getParameter(PARAM_NAME);
            }
            t = TokenCookie.fromString(tokenString);
            request.setAttribute(ATTR_NAME, (Object)t);
        }
        return t;
    }

    public static Info getTokenInfo(HttpServletRequest request) {
        return TokenCookie.getTokenInfo(request, TokenCookie.getPort(request));
    }

    public static Info getTokenInfo(HttpServletRequest request, String repoId) {
        Info info = (Info)request.getAttribute(Info.ATTR_NAME);
        if (info == null) {
            TokenCookie t = TokenCookie.fromRequest(request);
            info = t.getInfos().get(repoId);
            if (info == null) {
                info = Info.INVALID;
            }
            request.setAttribute(Info.ATTR_NAME, (Object)info);
        }
        return info;
    }

    public static String getPort(HttpServletRequest request) {
        String host = request.getHeader("Host");
        String port = "";
        if (host == null || host.length() == 0) {
            log.warn("Request to {} does not include a host header. Using default port.", (Object)request.getRequestURI());
        } else {
            int idx = host.indexOf(58);
            if (idx > 0) {
                port = host.substring(idx + 1);
            }
        }
        if (port.length() == 0) {
            port = request.isSecure() ? "443" : "80";
        }
        return port;
    }

    public static void update(HttpServletRequest request, HttpServletResponse response, String token, String wsp) {
        TokenCookie.update(request, response, TokenCookie.getPort(request), token, wsp, false);
    }

    public static void update(HttpServletRequest request, HttpServletResponse response, String repoId, String token, String wsp, boolean isHttpOnly) {
        String v;
        TokenCookie t = TokenCookie.fromRequest(request);
        Info newInfo = Info.INVALID;
        if (token == null) {
            t.getInfos().remove(repoId);
        } else {
            newInfo = new Info(token, wsp);
            t.getInfos().put(repoId, newInfo);
        }
        request.setAttribute(Info.ATTR_NAME, (Object)newInfo);
        String path = request.getContextPath();
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if ((v = t.toString()).length() == 0) {
            TokenCookie.setCookie(response, NAME, v, 0, path, null, isHttpOnly, request.isSecure());
        } else {
            TokenCookie.setCookie(response, NAME, v, -1, path, null, isHttpOnly, request.isSecure());
        }
    }

    public static TokenCookie fromString(String value) {
        String[] infos;
        TokenCookie t = new TokenCookie();
        if (value == null) {
            return t;
        }
        value = Text.unescape((String)value);
        for (String info : infos = Text.explode((String)value.trim(), (int)59)) {
            String[] parts = Text.explode((String)info.trim(), (int)58, (boolean)true);
            if (parts.length != 3) {
                log.warn("invalid value in cookie: {}", (Object)info);
                continue;
            }
            t.infos.put(parts[0].trim(), new Info(Text.unescape((String)parts[1].trim()), Text.unescape((String)parts[2].trim())));
        }
        return t;
    }

    public boolean remove(String repoId) {
        return this.infos.remove(repoId) != null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String delim = "";
        for (Map.Entry<String, Info> e : this.infos.entrySet()) {
            b.append(delim);
            if (e.getKey().length() > 0) {
                b.append(e.getKey()).append(":");
            }
            b.append(e.getValue());
            delim = ";";
        }
        return Text.escape((String)b.toString());
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name) || cookie.getValue().equals("")) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAge, String path) {
        TokenCookie.setCookie(response, name, value, maxAge, path, null, false, false);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAge, String path, String domain, boolean isHttpOnly, boolean isSecure) {
        StringBuilder header = new StringBuilder();
        header.append(name).append("=").append(value);
        header.append("; Path=").append(path);
        if (isHttpOnly) {
            header.append("; HttpOnly");
        }
        if (domain != null) {
            header.append("; Domain=").append(domain);
        }
        if (maxAge >= 0) {
            header.append("; Max-Age=").append(maxAge);
        }
        if (isSecure) {
            header.append("; Secure");
        }
        response.addHeader("Set-Cookie", header.toString());
    }

    public static class Info {
        public static final Info INVALID = new Info(null, null);
        public static final String ATTR_NAME = Info.class.getName();
        public final String token;
        public final String workspace;

        public Info(String token, String workspace) {
            this.workspace = workspace;
            this.token = token;
        }

        public boolean isValid() {
            return this.token != null && this.token.length() > 0;
        }

        public String toString() {
            if (this.token == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(Text.escape((String)this.token)).append(":");
            sb.append(Text.escape((String)this.workspace));
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            if (this.token != null ? !this.token.equals(info.token) : info.token != null) {
                return false;
            }
            return !(this.workspace != null ? !this.workspace.equals(info.workspace) : info.workspace != null);
        }

        public int hashCode() {
            int result = this.token != null ? this.token.hashCode() : 0;
            result = 31 * result + (this.workspace != null ? this.workspace.hashCode() : 0);
            return result;
        }
    }
}

