/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlexClientResponseHelper {
    private static final Logger log = LoggerFactory.getLogger(FlexClientResponseHelper.class);
    public static final String PAR_J_FLEX = "j_flex";
    public static final String PAR_J_LOGOUT = "logout";
    public static final String RES_AUTHENTICATED = "authenticated";
    public static final String RES_AUTHSTATE = "authstate";
    public static final String RES_AUTHTYPE = "authtype";
    public static final String RES_USERID = "userid";
    public static final String RES_REASON = "reason";

    FlexClientResponseHelper() {
    }

    public static void writeResponse(HttpServletResponse response, Map<String, String> responseContent) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : responseContent.entrySet()) {
            sb.append(e.getKey()).append('=').append(e.getValue()).append('&');
        }
        if (sb.length() != 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        try {
            response.setStatus(200);
            response.setContentType("text/plain");
            response.setCharacterEncoding("ISO-8859-1");
            PrintWriter pw = response.getWriter();
            pw.write(sb.toString());
            response.flushBuffer();
        }
        catch (IOException ioe) {
            log.error("Failed to send response", (Throwable)ioe);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AuthFailedReason {
        TOKEN_EXPIRED,
        WRONG_CREDENTIALS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AuthState {
        FAILED,
        COMPLETE,
        LOGGED_OUT,
        CREDENTIAL_CHALLENGE;

    }
}

