/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token.impl;

import com.day.crx.security.token.TokenCookie;
import com.day.crx.security.token.impl.FlexClientResponseHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.spi.AbstractAuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.DefaultAuthenticationFeedbackHandler;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenAuthenticationHandler
extends AbstractAuthenticationHandler
implements AuthenticationFeedbackHandler {
    private static final String REQUEST_METHOD = "POST";
    private static final String REQUEST_URL_SUFFIX = "/j_security_check";
    private static final String PAR_J_USERNAME = "j_username";
    private static final String PAR_J_PASSWORD = "j_password";
    private static final String PAR_J_REASON = "j_reason";
    private static final String PAR_J_SET_COOKIE = "j_set_cookie";
    private static final String REASON_WRONG_CREDENTIALS = "invalid_login";
    private static final String REASON_TOKEN_EXPIRED = "session_timed_out";
    private static final String CREDENTIALS = "user.jcr.credentials";
    private static final String AUTH_TYPE = "TOKEN";
    private static final String ATTR_TOKEN = ".token";
    private static final String ATTR_TOKEN_IP = "ip";
    private static final String ATTR_TOKEN_IP_MANDATORY = ".token.ip";
    private static final String ATTR_TOKEN_AGENT = "useragent";
    private static final String ATTR_TOKEN_AGENT_MANDATORY = ".token.useragent";
    private static final String ATTR_REFERER = "referer";
    private static final String REQUIRED_ATTR_IP_AGENT = "ip_agent";
    private static final String REQUIRED_ATTR_IP = "ip";
    private static final String REQUIRED_ATTR_AGENT = "agent";
    private static final String REQUIRED_ATTR_NONE = "none";
    private static final String PROP_REQUIRED_ATTR = "token.required.attr";
    private static final String PROP_ALTERNATE_URL = "token.alternate.url";
    private static final String NO_TOKEN = "";
    private static final char[] NO_PASSWORD = new char[0];
    private static final String REPO_DESC_ID = "crx.repository.systemid";
    private static final String REPO_DESC_CLUSTER_ID = "crx.cluster.id";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DESCRIPTION = "Token Authentication Handler";
    private SlingRepository repository;
    private SlingSettingsService settings;
    private String repositoryId;
    private String attrIp;
    private String attrAgent;
    private String alternateAuthUrl;

    private void activate(Map<String, Object> configuration) {
        String id = this.repository.getDescriptor(REPO_DESC_CLUSTER_ID);
        if (id == null && (id = this.repository.getDescriptor(REPO_DESC_ID)) == null && (id = this.settings.getSlingId()) == null) {
            id = UUID.randomUUID().toString();
            this.log.error("activate: Failure to acquire unique ID for this token authenticator. Using random UUID {}", (Object)id);
        }
        this.repositoryId = id;
        this.log.info("activate: Supporting tokens bound to Repository (Cluster) {}", (Object)this.repositoryId);
        String reqAttr = OsgiUtil.toString((Object)configuration.get(PROP_REQUIRED_ATTR), (String)REQUIRED_ATTR_IP_AGENT);
        if ("ip".equals(reqAttr)) {
            this.log.info("activate: Validating Cookie with Client IP");
            this.attrIp = ATTR_TOKEN_IP_MANDATORY;
            this.attrAgent = ATTR_TOKEN_AGENT;
        } else if (REQUIRED_ATTR_AGENT.equals(reqAttr)) {
            this.log.info("activate: Validating Cookie with Client User-Agent");
            this.attrIp = "ip";
            this.attrAgent = ATTR_TOKEN_AGENT_MANDATORY;
        } else if (REQUIRED_ATTR_NONE.equals(reqAttr)) {
            this.log.info("activate: Validating Token Only");
            this.attrIp = "ip";
            this.attrAgent = ATTR_TOKEN_AGENT;
        } else {
            this.log.info("activate: Validating Cookie with Client IP and User-Agent");
            this.attrIp = ATTR_TOKEN_IP_MANDATORY;
            this.attrAgent = ATTR_TOKEN_AGENT_MANDATORY;
        }
        this.alternateAuthUrl = OsgiUtil.toString((Object)configuration.get(PROP_ALTERNATE_URL), null);
        if (this.alternateAuthUrl != null && !this.alternateAuthUrl.startsWith("/")) {
            this.alternateAuthUrl = "/" + this.alternateAuthUrl;
        }
    }

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        AuthenticationInfo userNameInfo = this.getTokenFormPars(request);
        if (userNameInfo != null) {
            request.setAttribute(REQUEST_URL_SUFFIX, (Object)AUTH_TYPE);
            return userNameInfo;
        }
        TokenCookie.Info info = TokenCookie.getTokenInfo(request, this.repositoryId);
        if (info.token != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Extracted token information: {}@{}", (Object)info.token, (Object)info.workspace);
            }
            if (info.workspace != null && info.workspace.length() > 0) {
                request.setAttribute("j_workspace", (Object)info.workspace);
            }
            TokenCredentials creds = TokenAuthenticationHandler.createCredentials(info.token);
            return this.createAuthenticationInfo(creds, request);
        }
        return null;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) {
        return false;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) {
        this.removeTokenNode(request);
        TokenCookie.update(request, response, this.repositoryId, null, null, true);
        if (this.isFlexRequest(request) && request.getAttribute(PAR_J_REASON) == null) {
            HashMap<String, String> responseContent = new HashMap<String, String>();
            responseContent.put("authenticated", "false");
            responseContent.put("authstate", FlexClientResponseHelper.AuthState.LOGGED_OUT.name());
            FlexClientResponseHelper.writeResponse(response, responseContent);
        }
    }

    public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        FlexClientResponseHelper.AuthFailedReason flexFailureReason;
        if (TokenCookie.getTokenInfo((HttpServletRequest)request, (String)this.repositoryId).token != null) {
            request.setAttribute(PAR_J_REASON, (Object)REASON_TOKEN_EXPIRED);
            flexFailureReason = FlexClientResponseHelper.AuthFailedReason.TOKEN_EXPIRED;
        } else {
            request.setAttribute(PAR_J_REASON, (Object)REASON_WRONG_CREDENTIALS);
            flexFailureReason = FlexClientResponseHelper.AuthFailedReason.WRONG_CREDENTIALS;
        }
        this.dropCredentials(request, response);
        if (this.isFlexRequest(request)) {
            HashMap<String, String> responseContent = new HashMap<String, String>();
            responseContent.put("reason", flexFailureReason.name());
            responseContent.put("authenticated", "false");
            responseContent.put("authstate", FlexClientResponseHelper.AuthState.FAILED.name());
            FlexClientResponseHelper.writeResponse(response, responseContent);
        }
    }

    public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        String resource;
        boolean doRedirect = REQUEST_METHOD.equals(request.getMethod()) && this.isLoginURL(request);
        TokenCookie.Info tokenInfo = TokenCookie.getTokenInfo(request, this.repositoryId);
        if ((doRedirect || this.needsCookieUpdate(tokenInfo, request)) && (tokenInfo = this.createTokenInfo(request, authInfo)) != null) {
            TokenCookie.update(request, response, this.repositoryId, tokenInfo.token, tokenInfo.workspace, true);
        }
        boolean result = false;
        if (this.isFlexRequest(request) && !this.logoutRequest(request)) {
            HashMap<String, String> responseContent = new HashMap<String, String>();
            responseContent.put("authenticated", "true");
            responseContent.put("authstate", FlexClientResponseHelper.AuthState.COMPLETE.name());
            responseContent.put("authtype", AUTH_TYPE);
            Object rrObj = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
            if (rrObj instanceof ResourceResolver) {
                String userId = ((ResourceResolver)rrObj).getUserID();
                responseContent.put("userid", userId);
            }
            FlexClientResponseHelper.writeResponse(response, responseContent);
            result = true;
        } else if (doRedirect && !DefaultAuthenticationFeedbackHandler.handleRedirect((HttpServletRequest)request, (HttpServletResponse)response) && (resource = AuthUtil.getLoginResource((HttpServletRequest)request, null)) != null) {
            try {
                response.sendRedirect(resource);
            }
            catch (IOException ioe) {
                this.log.error("Failed to send redirect to: " + resource, (Throwable)ioe);
            }
            result = true;
        }
        return result;
    }

    private boolean isLoginURL(HttpServletRequest request) {
        boolean result = request.getRequestURI().endsWith(REQUEST_URL_SUFFIX);
        if (!result && this.alternateAuthUrl != null) {
            result = request.getRequestURI().endsWith(this.alternateAuthUrl);
        }
        return result;
    }

    private boolean logoutRequest(HttpServletRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("logout"));
    }

    private boolean isFlexRequest(HttpServletRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("j_flex"));
    }

    private AuthenticationInfo getTokenFormPars(HttpServletRequest request) {
        if (REQUEST_METHOD.equals(request.getMethod()) && this.isLoginURL(request) && request.getParameter(PAR_J_USERNAME) != null) {
            if (!TokenAuthenticationHandler.isValidateRequest((HttpServletRequest)request)) {
                String loginResource = AuthUtil.getLoginResource((HttpServletRequest)request, (String)request.getContextPath());
                if (loginResource == null || loginResource.length() == 0) {
                    loginResource = "/";
                }
                TokenAuthenticationHandler.setLoginResourceAttribute((HttpServletRequest)request, (String)loginResource);
            }
            SimpleCredentials creds = TokenAuthenticationHandler.createCredentials(request.getParameter(PAR_J_USERNAME), request.getParameter(PAR_J_PASSWORD));
            return this.createAuthenticationInfo(creds, request);
        }
        return null;
    }

    public String toString() {
        return DESCRIPTION;
    }

    private static TokenCredentials createCredentials(String token) {
        TokenCredentials creds = new TokenCredentials(token);
        return creds;
    }

    private static SimpleCredentials createCredentials(String userId, String password) {
        SimpleCredentials creds = new SimpleCredentials(userId, password != null ? password.toCharArray() : NO_PASSWORD);
        creds.setAttribute(ATTR_TOKEN, (Object)NO_TOKEN);
        return creds;
    }

    private AuthenticationInfo createAuthenticationInfo(SimpleCredentials creds, HttpServletRequest request) {
        String referrer;
        String ip;
        String xff = request.getHeader("X-Forwarded-For");
        if (xff == null) {
            ip = request.getRemoteAddr();
        } else {
            String[] ips = xff.split(",");
            ip = ips[ips.length - 1].trim();
        }
        creds.setAttribute(this.attrIp, (Object)ip);
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            creds.setAttribute(this.attrAgent, (Object)userAgent);
        }
        if ((referrer = request.getHeader("Referer")) != null) {
            creds.setAttribute(ATTR_REFERER, (Object)referrer);
        }
        AuthenticationInfo info = new AuthenticationInfo(AUTH_TYPE);
        info.put(CREDENTIALS, (Object)creds);
        return info;
    }

    private AuthenticationInfo createAuthenticationInfo(TokenCredentials creds, HttpServletRequest request) {
        String referrer;
        String ip;
        String xff = request.getHeader("X-Forwarded-For");
        if (xff == null) {
            ip = request.getRemoteAddr();
        } else {
            String[] ips = xff.split(",");
            ip = ips[ips.length - 1].trim();
        }
        String attrIp = !NO_TOKEN.equals(creds.getAttribute(ATTR_TOKEN)) ? ATTR_TOKEN_IP_MANDATORY : this.attrIp;
        creds.setAttribute(attrIp, ip);
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            String attrAgent = !NO_TOKEN.equals(creds.getAttribute(ATTR_TOKEN)) ? ATTR_TOKEN_AGENT_MANDATORY : this.attrAgent;
            creds.setAttribute(attrAgent, userAgent);
        }
        if ((referrer = request.getHeader("Referer")) != null) {
            creds.setAttribute(ATTR_REFERER, referrer);
        }
        AuthenticationInfo info = new AuthenticationInfo(AUTH_TYPE);
        info.put(CREDENTIALS, (Object)creds);
        return info;
    }

    private boolean needsCookieUpdate(TokenCookie.Info info, HttpServletRequest request) {
        return info.token == null || "true".equalsIgnoreCase(request.getParameter(PAR_J_SET_COOKIE));
    }

    private TokenCookie.Info createTokenInfo(HttpServletRequest request, AuthenticationInfo info) {
        Session session;
        String token = null;
        Object creds = info.get((Object)CREDENTIALS);
        if (creds instanceof SimpleCredentials) {
            Object a = ((SimpleCredentials)creds).getAttribute(ATTR_TOKEN);
            if (a != null) {
                token = a.toString();
            }
        } else if (creds instanceof TokenCredentials) {
            token = ((TokenCredentials)creds).getToken();
        }
        String workspace = null;
        Object rrObj = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
        if (rrObj instanceof ResourceResolver && (session = (Session)((ResourceResolver)rrObj).adaptTo(Session.class)) != null) {
            workspace = session.getWorkspace().getName();
        }
        if (token != null && workspace != null) {
            return new TokenCookie.Info(token, workspace);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTokenNode(HttpServletRequest request) {
        TokenCookie.Info tokenInfo = TokenCookie.getTokenInfo(request, this.repositoryId);
        if (tokenInfo != null && tokenInfo.token != null) {
            Session s = null;
            try {
                String token = tokenInfo.token;
                int pos = token.indexOf(95);
                String id = pos == -1 ? token : token.substring(0, pos);
                s = this.repository.loginAdministrative(tokenInfo.workspace);
                s.getNodeByIdentifier(id).remove();
                s.save();
            }
            catch (ItemNotFoundException infe) {
                this.log.debug("removeTokenNode: Token node " + tokenInfo.workspace + ":" + tokenInfo.token + " not found", (Throwable)infe);
            }
            catch (RepositoryException re) {
                this.log.info("removeTokenNode: Failed removing token node", (Throwable)re);
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettings(SlingSettingsService slingSettingsService) {
        this.settings = slingSettingsService;
    }

    protected void unbindSettings(SlingSettingsService slingSettingsService) {
        if (this.settings == slingSettingsService) {
            this.settings = null;
        }
    }
}

