/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token.impl;

import com.day.crx.security.token.impl.helper.AllTokensIterator;
import com.day.crx.security.token.impl.helper.Token;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCleanupTask
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;

    public void run() {
        String mp = this.repository.getDescriptor("crx.cluster.master");
        if ("false".equals(mp)) {
            this.log.debug("TokenCleanupTask: not the master node");
        } else {
            this.log.debug("TokenCleanupTask: Starting cleanup");
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long start = System.currentTimeMillis();
        int numRemoved = 0;
        int numLive = 0;
        Session admin = null;
        try {
            admin = this.repository.loginAdministrative(null);
            long currentTime = System.currentTimeMillis();
            AllTokensIterator tokens = new AllTokensIterator(admin);
            while (tokens.hasNext()) {
                Token token = tokens.next();
                if (token.getExpiry().getTimeInMillis() < currentTime) {
                    this.log.debug("TokenCleanupTask: Removing token {} of user {}", (Object)token.getIdentifier(), (Object)tokens.getCurrentUserName());
                    token.remove();
                    ++numRemoved;
                    continue;
                }
                ++numLive;
            }
            if (admin.hasPendingChanges()) {
                try {
                    admin.refresh(true);
                    admin.save();
                }
                catch (InvalidItemStateException iise) {
                    this.log.info("TokenCleanupTask: Concurrent modification to one or more of the tokens to be removed. Retrying later");
                }
                catch (RepositoryException re) {
                    this.log.info("TokenCleanupTask: Failed persisting token removal. Retrying later");
                }
            }
        }
        catch (Throwable t) {
            this.log.error("TokenCleanupTask: General failure while trying to cleanup tokens", t);
        }
        finally {
            if (admin != null) {
                admin.logout();
            }
        }
        long end = System.currentTimeMillis();
        this.log.info("TokenCleanupTask: Removed {} token(s) in {}ms ({} token(s) still active)", new Object[]{numRemoved, end - start, numLive});
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

