/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token.impl;

import com.day.crx.security.token.impl.helper.AllTokensIterator;
import com.day.crx.security.token.impl.helper.Token;
import com.day.crx.security.token.impl.helper.TokenIterator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.jcr.api.SlingRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenManagerPlugin
extends AbstractWebConsolePlugin {
    private static final String LABEL = "tokenmgr";
    private static final String TITLE = "CRX Login Tokens";
    private static final String PARAM_CRX_TOKEN = "crx_token";
    private static final String PARAM_CRX_TOKEN_EXPIRED_OWNER = "crx_token_expired_owner";
    SlingRepository repository;

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter pw = resp.getWriter();
        Session adminSession = null;
        try {
            String expiredOwner;
            adminSession = this.createAdminSession(req);
            String tokenIdentifier = req.getParameter(PARAM_CRX_TOKEN);
            if (tokenIdentifier != null) {
                Node tokenNode = adminSession.getNodeByIdentifier(tokenIdentifier);
                tokenNode.remove();
                adminSession.save();
            }
            if ((expiredOwner = req.getParameter(PARAM_CRX_TOKEN_EXPIRED_OWNER)) != null) {
                long currentTime = System.currentTimeMillis();
                Node ownerNode = adminSession.getNodeByIdentifier(expiredOwner);
                TokenIterator tokens = new TokenIterator(ownerNode);
                while (tokens.hasNext()) {
                    Token token = tokens.next();
                    if (token.getExpiry().getTimeInMillis() >= currentTime) continue;
                    token.remove();
                }
                if (adminSession.hasPendingChanges()) {
                    adminSession.save();
                }
            }
            resp.sendRedirect(req.getRequestURI());
        }
        catch (RepositoryException re) {
            pw.println("<p>Failure finding Tokens</p>");
            pw.println("<pre>");
            re.printStackTrace(pw);
            pw.println("</pre>");
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws IOException {
        PrintWriter pw = res.getWriter();
        pw.println("<p class='statline'>CRX Token Login operative</p>");
        Session adminSession = null;
        try {
            adminSession = this.createAdminSession(req);
            AllTokensIterator tokens = new AllTokensIterator(adminSession);
            String previousName = null;
            while (tokens.hasNext()) {
                if (previousName != tokens.getCurrentUserName()) {
                    if (previousName != null) {
                        pw.println("</table>");
                        pw.println("<br/>");
                    }
                    previousName = tokens.getCurrentUserName();
                    pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
                    pw.printf("    <span style='float: left; margin-left: 1em'>Existing Tokens for %s</span>%n", previousName);
                    pw.println(this.getForm("Remove Expired Tokens", PARAM_CRX_TOKEN_EXPIRED_OWNER, tokens.getCurrentUserIdentifier()));
                    pw.println("</div>");
                    pw.println("<table id='repoTable' class='nicetable'>");
                }
                Token token = tokens.next();
                Calendar exp = token.getExpiry();
                String expiry = ISO8601.format((Calendar)exp);
                if (exp.getTimeInMillis() < System.currentTimeMillis()) {
                    expiry = "<font style='color:red;'>Expired " + expiry + "</font>";
                }
                pw.println("<tbody>");
                pw.println("<tr><th colspan='2'>");
                pw.println("<div class='buttonGroup'>");
                pw.printf("<span style='float: left'>Token %s</span>%n", token.getIdentifier());
                pw.println(this.getForm("Remove", PARAM_CRX_TOKEN, token.getIdentifier()));
                pw.println("</div>");
                pw.printf("<tr><td width='10%%'>Expires</td><td>%s</td></tr>%n", expiry);
                pw.print("<tr><td>Mandatory Attributes</td><td>");
                this.printAttributes(pw, token.getMandatoryProperties());
                pw.println("</td></tr>");
                pw.print("<tr><td>Informative Attributes</td><td>");
                this.printAttributes(pw, token.getInformationProperties());
                pw.println("</td></tr>");
                pw.println("</tbody>");
            }
            if (previousName != null) {
                pw.println("</table>");
            }
        }
        catch (RepositoryException re) {
            pw.println("<p>Failure finding Tokens</p>");
            pw.println("<pre>");
            re.printStackTrace(pw);
            pw.println("</pre>");
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    private Session createAdminSession(HttpServletRequest request) throws RepositoryException {
        return this.repository.loginAdministrative(null);
    }

    private String getForm(String buttonLabel, String hiddenName, String hiddenValue) {
        StringBuilder form = new StringBuilder();
        form.append("<form method='POST'>");
        form.append("<input type='hidden' name='").append(hiddenName);
        form.append("' value='").append(hiddenValue).append("'/>");
        form.append("<input type='submit' value='").append(buttonLabel).append("'/>");
        form.append("</form>");
        return form.toString();
    }

    private void printAttributes(PrintWriter writer, Map<String, String> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            writer.println("None");
        } else {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                writer.printf("%s = %s<br/>%n", entry.getKey(), entry.getValue());
            }
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

