/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token.impl.helper;

import com.day.crx.security.token.impl.helper.Token;
import com.day.crx.security.token.impl.helper.TokenIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.apache.jackrabbit.util.ISO9075;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllTokensIterator
implements Iterator<Token> {
    private static final String TOKEN_QUERY = "/jcr:root//element(*,rep:User)[" + ISO9075.encode((String)".tokens") + "/@jcr:primaryType]";
    private NodeIterator userNodes;
    private TokenIterator perUser;

    public AllTokensIterator(Session session) throws RepositoryException {
        Query q = session.getWorkspace().getQueryManager().createQuery(TOKEN_QUERY, "xpath");
        this.userNodes = q.execute().getNodes();
        this.perUser = this.seek(null);
    }

    @Override
    public boolean hasNext() {
        return this.perUser != null && this.perUser.hasNext();
    }

    @Override
    public Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Token result = this.perUser.next();
        this.perUser = this.seek(this.perUser);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public String getCurrentUserName() throws RepositoryException {
        return this.perUser != null ? this.perUser.getUserName() : null;
    }

    public String getCurrentUserIdentifier() throws RepositoryException {
        return this.perUser != null ? this.perUser.getUserIdentifier() : null;
    }

    private TokenIterator seek(TokenIterator current) {
        if (current == null || !current.hasNext()) {
            while (this.userNodes.hasNext()) {
                TokenIterator next = new TokenIterator(this.userNodes.nextNode());
                if (!next.hasNext()) continue;
                return next;
            }
        }
        return current;
    }
}

