/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token.impl.helper;

import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token {
    private static final String PROP_EXPIRY = ".token.exp";
    private static final String PROP_PREFIX_MANDATORY = ".token";
    private final Node tokenNode;
    private Calendar expiry;
    Map<String, String> mandatory;
    Map<String, String> info;

    public Token(Node tokenNode) {
        this.tokenNode = tokenNode;
    }

    public String getIdentifier() throws RepositoryException {
        return this.tokenNode.getIdentifier();
    }

    public Calendar getExpiry() throws RepositoryException {
        if (this.expiry == null) {
            if (this.tokenNode.hasProperty(PROP_EXPIRY)) {
                this.expiry = this.tokenNode.getProperty(PROP_EXPIRY).getDate();
            } else {
                this.expiry = Calendar.getInstance();
                this.expiry.setTimeInMillis(-1L);
            }
        }
        return this.expiry;
    }

    public boolean isExpired(long cutoffMillisUtc) throws RepositoryException {
        return this.getExpiry().getTimeInMillis() < cutoffMillisUtc;
    }

    public Map<String, String> getMandatoryProperties() throws RepositoryException {
        if (this.mandatory == null) {
            this.readProperties();
        }
        return this.mandatory;
    }

    public Map<String, String> getInformationProperties() throws RepositoryException {
        if (this.info == null) {
            this.readProperties();
        }
        return this.info;
    }

    public void remove() throws RepositoryException {
        this.tokenNode.remove();
    }

    private void readProperties() throws RepositoryException {
        TreeMap<String, String> mandatory = new TreeMap<String, String>();
        TreeMap<String, String> info = new TreeMap<String, String>();
        PropertyIterator props = this.tokenNode.getProperties();
        while (props.hasNext()) {
            Property prop = props.nextProperty();
            String name = prop.getName();
            if (PROP_EXPIRY.equals(name)) {
                if (this.expiry != null) continue;
                this.expiry = prop.getDate();
                continue;
            }
            if (name.startsWith(PROP_PREFIX_MANDATORY)) {
                mandatory.put(name, prop.getString());
                continue;
            }
            info.put(name, prop.getString());
        }
        this.mandatory = mandatory;
        this.info = info;
    }
}

