/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token.impl.helper;

import com.day.crx.security.token.impl.helper.Token;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenIterator
implements Iterator<Token> {
    static final String NODE_TOKENS = ".tokens";
    private final Node userNode;
    private String userName;
    private NodeIterator tokenNodes;
    private Token nextToken;

    public TokenIterator(Node userNode) {
        this.userNode = userNode;
        try {
            if (userNode.hasNode(NODE_TOKENS)) {
                Node tokensNode = userNode.getNode(NODE_TOKENS);
                this.tokenNodes = tokensNode.getNodes();
                this.nextToken = this.seek();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextToken != null;
    }

    @Override
    public Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Token result = this.nextToken;
        this.nextToken = this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public String getUserName() throws RepositoryException {
        if (this.userName == null) {
            String email;
            String given = this.getUserProperty("profile/givenName");
            String family = this.getUserProperty("profile/familyName");
            this.userName = given.length() > 0 || family.length() > 0 ? (given + " " + family).trim() : ((email = this.getUserProperty("profile/email")).length() > 0 ? email : this.userNode.getProperty("rep:principalName").getString());
        }
        return this.userName;
    }

    public String getUserIdentifier() throws RepositoryException {
        return this.userNode.getIdentifier();
    }

    private String getUserProperty(String propName) throws RepositoryException {
        if (this.userNode.hasProperty(propName)) {
            return this.userNode.getProperty(propName).getString();
        }
        return "";
    }

    private Token seek() {
        if (this.tokenNodes.hasNext()) {
            return new Token(this.tokenNodes.nextNode());
        }
        return null;
    }
}

