/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs;

import com.day.jcr.vault.fs.api.AccessType;
import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.ExportArtifact;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.impl.AbstractArtifact;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValueArtifact
extends AbstractArtifact
implements ExportArtifact {
    private final Property property;
    private final String path;
    private File tmpFile;
    private Long contentLength;
    private final long lastModified;
    private final int valueIndex;

    public PropertyValueArtifact(Artifact parent, String relPath, String ext, ArtifactType type, Property prop, long lastModified) throws RepositoryException {
        this(parent, relPath, ext, type, prop, -1, lastModified);
    }

    public PropertyValueArtifact(Artifact parent, String relPath, String ext, ArtifactType type, Property prop, int index, long lastModified) throws RepositoryException {
        super(parent, relPath, ext, type);
        this.property = prop;
        this.path = prop.getPath();
        if (prop.getDefinition().isMultiple()) {
            if (index < 0) {
                index = 0;
            }
        } else if (index >= 0) {
            index = -1;
        }
        this.valueIndex = index;
        this.lastModified = lastModified;
    }

    public static Collection<PropertyValueArtifact> create(Artifact parent, String relPath, String ext, ArtifactType type, Property prop, long lastModified) throws RepositoryException {
        LinkedList<PropertyValueArtifact> list = new LinkedList<PropertyValueArtifact>();
        if (prop.getDefinition().isMultiple()) {
            Value[] values = prop.getValues();
            for (int i = 0; i < values.length; ++i) {
                StringBuffer n = new StringBuffer(relPath);
                n.append('[').append(i).append(']');
                list.add(new PropertyValueArtifact(parent, n.toString(), ext, type, prop, i, lastModified));
            }
        } else {
            list.add(new PropertyValueArtifact(parent, relPath, ext, type, prop, lastModified));
        }
        return list;
    }

    @Override
    public SerializationType getSerializationType() {
        return SerializationType.GENERIC;
    }

    @Override
    public AccessType getPreferredAccess() {
        return AccessType.STREAM;
    }

    @Override
    public InputStream getInputStream() throws IOException, RepositoryException {
        return this.tmpFile == null ? new PVAInputStream() : new FileInputStream(this.tmpFile);
    }

    public void detach() throws IOException, RepositoryException {
        if (this.tmpFile == null) {
            this.getContentType();
            this.tmpFile = File.createTempFile("jcrfs", "dat");
            this.tmpFile.setLastModified(this.getLastModified());
            this.tmpFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(this.tmpFile);
            InputStream in = this.getValue().getStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
        }
    }

    @Override
    public VaultInputSource getInputSource() throws IOException, RepositoryException {
        final InputStream in = this.getInputStream();
        return new VaultInputSource(){

            public String getSystemId() {
                return PropertyValueArtifact.this.path;
            }

            public InputStream getByteStream() {
                return in;
            }

            public long getContentLength() {
                return PropertyValueArtifact.this.getContentLength();
            }

            public long getLastModified() {
                return PropertyValueArtifact.this.getLastModified();
            }
        };
    }

    private Value getValue() throws RepositoryException {
        if (this.valueIndex < 0) {
            return this.property.getValue();
        }
        Value[] values = this.property.getValues();
        if (this.valueIndex >= values.length) {
            throw new RepositoryException("Illegal value index: " + this.valueIndex);
        }
        return values[this.valueIndex];
    }

    @Override
    public long getContentLength() {
        if (this.contentLength == null) {
            if (this.tmpFile == null) {
                this.contentLength = -1L;
                try {
                    if (this.valueIndex < 0) {
                        this.contentLength = this.property.getLength();
                    } else {
                        long[] lengths = this.property.getLengths();
                        if (this.valueIndex < lengths.length) {
                            this.contentLength = lengths[this.valueIndex];
                        }
                    }
                }
                catch (RepositoryException repositoryException) {}
            } else {
                this.contentLength = this.tmpFile.length();
            }
        }
        return this.contentLength;
    }

    public Property getProperty() {
        return this.property;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getContentType() {
        String ct = super.getContentType();
        if (ct == null && this.tmpFile == null) {
            try {
                Node parent = this.property.getParent();
                if (parent.hasProperty("jcr:mimeType")) {
                    ct = parent.getProperty("jcr:mimeType").getString();
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            super.setContentType(ct);
        }
        return ct;
    }

    private class PVAInputStream
    extends InputStream {
        private InputStream stream;
        private boolean closed;

        private PVAInputStream() {
        }

        private void assertOpen() throws IOException {
            if (this.stream == null) {
                if (this.closed) {
                    throw new IOException("Stream already closed.");
                }
                try {
                    this.stream = PropertyValueArtifact.this.getValue().getStream();
                }
                catch (RepositoryException e) {
                    throw new IOException("Error while opening stream: " + e.toString());
                }
            }
        }

        public int read() throws IOException {
            this.assertOpen();
            return this.stream.read();
        }

        public int read(byte[] b) throws IOException {
            this.assertOpen();
            return this.stream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.assertOpen();
            return this.stream.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            this.assertOpen();
            return this.stream.skip(n);
        }

        public int available() throws IOException {
            this.assertOpen();
            return this.stream.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                if (this.stream != null) {
                    this.stream.close();
                }
            }
            finally {
                this.closed = true;
                this.stream = null;
            }
        }

        public void mark(int readlimit) {
            try {
                this.assertOpen();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.stream.mark(readlimit);
        }

        public void reset() throws IOException {
            this.assertOpen();
            this.stream.reset();
        }

        public boolean markSupported() {
            try {
                this.assertOpen();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return this.stream.markSupported();
        }
    }
}

