/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs;

import com.day.jcr.vault.fs.api.AccessType;
import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.VaultFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;

public class VaultFileInputStream
extends InputStream {
    private final InputStream base;
    private File tmpFile;

    public VaultFileInputStream(VaultFile file) throws IOException {
        Artifact a = file.getArtifact();
        if (a == null || a.getPreferredAccess() == AccessType.NONE) {
            throw new IOException("invalid access.");
        }
        try {
            if (a.getPreferredAccess() == AccessType.STREAM) {
                this.base = a.getInputStream();
            } else {
                this.tmpFile = File.createTempFile("vltfs", ".spool");
                FileOutputStream out = new FileOutputStream(this.tmpFile);
                a.spool(out);
                out.close();
                this.base = new FileInputStream(this.tmpFile);
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e.toString());
        }
    }

    public int read() throws IOException {
        return this.base.read();
    }

    public int read(byte[] b) throws IOException {
        return this.base.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.base.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.base.skip(n);
    }

    public int available() throws IOException {
        return this.base.available();
    }

    public void close() throws IOException {
        this.base.close();
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile.deleteOnExit();
            this.tmpFile = null;
        }
    }

    public void mark(int readlimit) {
        this.base.mark(readlimit);
    }

    public void reset() throws IOException {
        this.base.reset();
    }

    public boolean markSupported() {
        return this.base.markSupported();
    }
}

