/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.api;

import java.io.PrintWriter;
import java.util.LinkedList;

public class DumpContext {
    private final PrintWriter out;
    private LinkedList<String> stack = new LinkedList();

    public DumpContext(PrintWriter out) {
        this.out = out;
        this.stack.add("");
    }

    public void println(String str) {
        this.out.println(str);
    }

    public void println(boolean isLast, String str) {
        this.out.print(this.stack.getLast());
        this.out.print(isLast ? "`-- " : "|-- ");
        this.out.println(str);
    }

    public void printf(boolean isLast, String format, Object ... args) {
        this.println(isLast, String.format(format, args));
    }

    public void indent(boolean isLast) {
        String ind = this.stack.getLast() + (isLast ? "    " : "|   ");
        this.stack.addLast(ind);
    }

    public void outdent() {
        this.stack.removeLast();
    }

    public void flush() {
        this.out.flush();
    }
}

