/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.api;

import com.day.jcr.vault.fs.api.FilterSet;
import com.day.jcr.vault.fs.api.PathFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathFilterSet
extends FilterSet<PathFilter> {
    public static final PathFilterSet INCLUDE_ALL = (PathFilterSet)new PathFilterSet().addInclude(PathFilter.ALL).seal();
    public static final PathFilterSet EXCLUDE_ALL = (PathFilterSet)new PathFilterSet().addExclude(PathFilter.ALL).seal();
    private boolean onlyRelativePatterns;

    public PathFilterSet() {
    }

    public PathFilterSet(String root) {
        super(root);
    }

    public boolean contains(String path) {
        if (!this.covers(path)) {
            return false;
        }
        if (this.entries == null || this.entries.isEmpty()) {
            return true;
        }
        boolean result = !((FilterSet.Entry)this.entries.get((int)0)).include;
        for (FilterSet.Entry entry : this.entries) {
            if (!((PathFilter)entry.filter).matches(path)) continue;
            result = entry.include;
        }
        return result;
    }

    @Override
    public FilterSet seal() {
        FilterSet ret = super.seal();
        this.onlyRelativePatterns = true;
        for (FilterSet.Entry entry : this.entries) {
            if (entry.include && !((PathFilter)entry.filter).isAbsolute()) continue;
            this.onlyRelativePatterns = false;
            break;
        }
        return ret;
    }

    public boolean hasOnlyRelativePatterns() {
        return this.onlyRelativePatterns;
    }
}

