/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.PropertyValueArtifact;
import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.ItemFilterSet;
import com.day.jcr.vault.fs.api.NodeNameList;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import com.day.jcr.vault.fs.impl.io.NameSpace;
import com.day.jcr.vault.fs.io.AccessControlHandling;
import com.day.jcr.vault.fs.spi.ACLManagement;
import com.day.jcr.vault.fs.spi.ServiceProviderFactory;
import com.day.jcr.vault.fs.spi.UserManagement;
import com.day.jcr.vault.util.DocViewProperty;
import com.day.jcr.vault.util.MimeTypes;
import com.day.jcr.vault.util.Text;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class DocViewSAXImporter
extends DefaultHandler
implements NamespaceResolver {
    static final Logger log = LoggerFactory.getLogger(DocViewSAXImporter.class);
    static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    static final Set<String> PROTECTED_PROPERTIES;
    private NameSpace nsStack = null;
    private final Session session;
    private final Node parentNode;
    private final String rootNodeName;
    private final int rootDepth;
    private StackElement stack;
    private final ItemFilterSet filter;
    private final WorkspaceFilter wspFilter;
    private Map<String, Map<String, BlobInfo>> binaries = new HashMap<String, Map<String, BlobInfo>>();
    private Set<String> hints = new HashSet<String>();
    private Set<String> saveProperties = new HashSet<String>();
    private final DefaultNamePathResolver npResolver = new DefaultNamePathResolver((NamespaceResolver)this);
    private ImportInfoImpl importInfo = new ImportInfoImpl();
    private final ACLManagement aclManagement;
    private final UserManagement userManagement;
    private AccessControlHandling aclHandling = AccessControlHandling.IGNORE;

    public DocViewSAXImporter(Node parentNode, String rootNodeName, ArtifactSetImpl artifacts, WorkspaceFilter wspFilter) throws RepositoryException {
        this.filter = artifacts.getCoverage();
        this.wspFilter = wspFilter;
        this.parentNode = parentNode;
        this.rootDepth = parentNode.getDepth() + 1;
        this.session = parentNode.getSession();
        this.rootNodeName = rootNodeName;
        this.aclManagement = ServiceProviderFactory.getProvider().getACLManagement();
        this.userManagement = ServiceProviderFactory.getProvider().getUserManagement();
        String rootPath = parentNode.getPath();
        if (!rootPath.equals("/")) {
            rootPath = rootPath + "/";
        }
        for (Artifact a : artifacts.values(ArtifactType.BINARY)) {
            this.registerBinary(a, rootPath);
        }
        for (Artifact a : artifacts.values(ArtifactType.FILE)) {
            this.registerBinary(a, rootPath);
        }
        for (Artifact a : artifacts.values(ArtifactType.HINT)) {
            this.hints.add(rootPath + a.getRelativePath());
        }
    }

    public AccessControlHandling getAclHandling() {
        return this.aclHandling;
    }

    public void setAclHandling(AccessControlHandling aclHandling) {
        this.aclHandling = aclHandling;
    }

    private void registerBinary(Artifact a, String rootPath) throws RepositoryException {
        String path = rootPath + a.getRelativePath();
        int idx = -1;
        int pos = path.indexOf(91, path.lastIndexOf(47));
        if (pos > 0) {
            idx = Integer.parseInt(path.substring(pos + 1, path.length() - 1));
            path = path.substring(0, pos);
        }
        if (a.getType() == ArtifactType.FILE && a instanceof PropertyValueArtifact) {
            String parentPath = ((PropertyValueArtifact)a).getProperty().getParent().getPath();
            this.saveProperties.add(parentPath + "/" + "jcr:data");
            this.saveProperties.add(parentPath + "/" + "jcr:lastModified");
        } else {
            BlobInfo info;
            this.saveProperties.add(path);
            this.saveProperties.add(path + "/jcr:content/jcr:data");
            this.saveProperties.add(path + "/jcr:content/jcr:lastModified");
            this.saveProperties.add(path + "/jcr:content/jcr:mimeType");
            String parentPath = Text.getRelativeParent(path, 1);
            String name = Text.getName(path);
            Map<String, BlobInfo> infoSet = this.binaries.get(parentPath);
            if (infoSet == null) {
                infoSet = new HashMap<String, BlobInfo>();
                this.binaries.put(parentPath, infoSet);
            }
            if ((info = infoSet.get(name)) == null) {
                info = new BlobInfo(idx >= 0);
                infoSet.put(name, info);
            }
            if (idx >= 0) {
                info.add(idx, a);
            } else {
                info.add(a);
            }
        }
        log.debug("scheduling binary: {}{}", (Object)rootPath, (Object)(a.getRelativePath() + a.getExtension()));
    }

    private boolean isIncluded(Item item, int depth) throws RepositoryException {
        String path = item.getPath();
        return this.wspFilter.contains(path) && (depth == 0 || this.filter.contains(item, path, depth));
    }

    public ImportInfoImpl getInfo() {
        return this.importInfo;
    }

    public void startDocument() throws SAXException {
        try {
            this.stack = new StackElement(null, this.parentNode);
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public void endDocument() throws SAXException {
        if (!this.stack.isRoot()) {
            throw new IllegalStateException("stack mismatch");
        }
        for (String parentPath : this.binaries.keySet()) {
            Map<String, BlobInfo> blobs = this.binaries.get(parentPath);
            log.debug("processing binaries at {}", (Object)parentPath);
            try {
                Node fNode;
                BlobInfo info;
                Node node;
                if (this.session.itemExists(parentPath)) {
                    node = (Node)this.session.getItem(parentPath);
                    for (String propName : blobs.keySet()) {
                        info = blobs.get(propName);
                        if (node.hasNode(propName)) {
                            this.handleBinNode(node.getNode(propName), info);
                            continue;
                        }
                        if (info.isFile()) {
                            fNode = node.addNode(propName, "nt:file");
                            this.importInfo.onCreated(fNode.getPath());
                            this.handleBinNode(fNode, info);
                            continue;
                        }
                        if (info.isMulti) {
                            node.setProperty(propName, info.getValues(this.session));
                        } else {
                            node.setProperty(propName, info.getValue(this.session));
                        }
                        this.importInfo.onModified(node.getPath());
                    }
                    continue;
                }
                log.warn("binaries parent path does not exist: {}", (Object)parentPath);
                node = null;
                for (String propName : blobs.keySet()) {
                    info = blobs.get(propName);
                    if (!info.isFile()) continue;
                    if (node == null) {
                        node = this.createNodeDeep(parentPath);
                    }
                    fNode = node.addNode(propName, "nt:file");
                    this.importInfo.onCreated(fNode.getPath());
                    this.handleBinNode(fNode, info);
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private Node createNodeDeep(String path) throws RepositoryException {
        Node node;
        if (this.session.itemExists(path)) {
            return (Node)this.session.getItem(path);
        }
        int idx = path.lastIndexOf(47);
        if (idx <= 0) {
            return this.session.getRootNode();
        }
        String parentPath = path.substring(0, idx);
        String name = path.substring(idx + 1);
        Node parentNode = this.createNodeDeep(parentPath);
        if (parentNode.isNodeType("nt:folder")) {
            try {
                node = parentNode.addNode(name);
            }
            catch (RepositoryException e) {
                node = parentNode.addNode(name, "nt:folder");
            }
        } else {
            node = this.createNodeDeep(parentPath).addNode(name);
        }
        this.importInfo.onCreated(node.getPath());
        return node;
    }

    private void handleBinNode(Node node, BlobInfo info) throws RepositoryException, IOException {
        Property data;
        log.debug("handling binary file at {}", (Object)node.getPath());
        if (info.isMulti) {
            throw new IllegalStateException("unable to add MV binary to node " + node.getPath());
        }
        if (node.isNodeType("nt:file")) {
            node = node.hasNode("jcr:content") ? node.getNode("jcr:content") : node.addNode("jcr:content", "nt:resource");
        }
        Artifact a = (Artifact)info.artifacts.get(0);
        boolean modified = false;
        ValueFactory factory = node.getSession().getValueFactory();
        Value value = factory.createValue(a.getInputStream());
        if (node.hasProperty("jcr:data")) {
            data = node.getProperty("jcr:data");
            if (!value.equals(data.getValue())) {
                data.setValue(value);
                this.importInfo.onModified(data.getPath());
                modified = true;
            }
        } else {
            data = node.setProperty("jcr:data", value);
            this.importInfo.onCreated(data.getPath());
            modified = true;
        }
        if (!node.hasProperty("jcr:lastModified") || node.getProperty("jcr:lastModified").getDate().getTimeInMillis() != a.getLastModified()) {
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(a.getLastModified());
            node.setProperty("jcr:lastModified", lastModified);
            modified = true;
        }
        if (!node.hasProperty("jcr:mimeType")) {
            String mimeType = a.getContentType();
            if (mimeType == null) {
                mimeType = Text.getName(a.getRelativePath(), '.');
                mimeType = MimeTypes.getMimeType(mimeType, "application/octet-stream");
            }
            node.setProperty("jcr:mimeType", mimeType);
            modified = true;
        }
        if (node.isNew()) {
            this.importInfo.onCreated(node.getPath());
        } else if (modified) {
            this.importInfo.onModified(node.getPath());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        String oldPrefix;
        log.debug("-> prefixMapping for {}:{}", (Object)prefix, (Object)uri);
        NameSpace ns = new NameSpace(prefix, uri);
        ns.next = this.nsStack;
        this.nsStack = ns;
        try {
            oldPrefix = this.session.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            try {
                this.session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
            }
            catch (RepositoryException e1) {
                throw new SAXException((Exception)((Object)e));
            }
            oldPrefix = prefix;
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
        if (!oldPrefix.equals(prefix)) {
            try {
                this.session.setNamespacePrefix(prefix, uri);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        log.debug("<- prefixMapping for {}", (Object)prefix);
        NameSpace ns = this.nsStack;
        NameSpace prev = null;
        while (ns != null && !ns.prefix.equals(prefix)) {
            prev = ns;
            ns = ns.next;
        }
        if (ns == null) {
            throw new SAXException("Illegal state: prefix " + prefix + " never mapped.");
        }
        if (prev == null) {
            this.nsStack = ns.next;
        } else {
            prev.next = ns.next;
        }
        ns = ns.next;
        while (ns != null && !ns.prefix.equals(prefix)) {
            ns = ns.next;
        }
        if (ns != null) {
            try {
                this.session.setNamespacePrefix(prefix, ns.uri);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
            log.debug("   remapped: {}:{}", (Object)prefix, (Object)ns.uri);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block15: {
            String label;
            if (this.stack.isRoot() && localName.equals(NameConstants.JCR_ROOT.getLocalName()) && uri.equals(NameConstants.JCR_ROOT.getNamespaceURI())) {
                qName = this.rootNodeName;
            }
            String name = label = ISO9075.decode((String)qName);
            log.debug("-> element {}", (Object)label);
            int idx = name.lastIndexOf(91);
            if (idx > 0) {
                name = name.substring(0, idx);
            }
            try {
                this.stack.addName(label);
                Node node = this.stack.getNode();
                if (node == null) {
                    this.stack = this.stack.push(null);
                    SysViewTransformer xform = this.stack.getTransformer();
                    if (xform != null) {
                        DocViewNode ni = new DocViewNode(name, label, attributes, (NamePathResolver)this.npResolver);
                        xform.startNode(ni);
                    } else {
                        log.debug("Skipping ignored element {}", (Object)name);
                    }
                    break block15;
                }
                if (attributes.getLength() == 0) {
                    log.debug("Skipping empty node {}", (Object)(node.getPath() + "/" + name));
                    this.stack = this.stack.push(null);
                    break block15;
                }
                try {
                    DocViewNode ni = new DocViewNode(name, label, attributes, (NamePathResolver)this.npResolver);
                    if (this.aclManagement.isACLNodeType(ni.primary)) {
                        if (this.aclHandling == AccessControlHandling.OVERWRITE || this.aclHandling == AccessControlHandling.MERGE) {
                            log.debug("ACL element detected. starting sysview transformation {}/{}", (Object)node.getPath(), (Object)name);
                            if (this.aclManagement.ensureAccessControllable(node)) {
                                log.warn("Adding ACL element to non ACL parent - adding mixin: {}", (Object)node.getPath());
                            }
                            this.stack = this.stack.push(null);
                            this.stack.transformer = new SysViewTransformer(node);
                            this.stack.transformer.startNode(ni);
                            this.importInfo.onCreated(node.getPath() + "/" + ni.name);
                        } else {
                            this.stack = this.stack.push(null);
                        }
                        break block15;
                    }
                    if (this.userManagement != null && this.userManagement.isAuthorizableNodeType(ni.primary)) {
                        log.info("Authorizable element detected. starting sysview transformation {}/{}", (Object)node.getPath(), (Object)name);
                        this.stack = this.stack.push(null);
                        this.stack.transformer = new SysViewTransformer(node);
                        this.stack.transformer.startNode(ni);
                        this.importInfo.onCreated(node.getPath() + "/" + ni.name);
                        break block15;
                    }
                    Node childNode = this.addNode(ni);
                    this.stack = this.stack.push(childNode);
                }
                catch (RepositoryException e) {
                    String errPath = node.getPath() + "/" + name;
                    log.error("Error during processing of {}: {}", (Object)errPath, (Object)e.toString());
                    this.importInfo.onError(errPath, (Exception)((Object)e));
                    this.stack = this.stack.push(null);
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private Node addNode(DocViewNode ni) throws RepositoryException, IOException {
        boolean isCheckedIn;
        Node currentNode = this.stack.getNode();
        Node oldNode = null;
        Node node = null;
        if (ni.label.equals("")) {
            node = currentNode;
        } else if (ni.uuid == null) {
            if (currentNode.hasNode(ni.label)) {
                node = currentNode.getNode(ni.label);
                if (ni.primary != null && !node.getPrimaryNodeType().getName().equals(ni.primary)) {
                    oldNode = node;
                    node = null;
                }
            }
        } else {
            try {
                node = this.session.getNodeByUUID(ni.uuid);
                if (!node.getParent().isSame((Item)currentNode)) {
                    log.warn("Packaged node at {} is referenceable and collides with existing node at {}. Will create new UUID.", (Object)(currentNode.getPath() + "/" + ni.label), (Object)node.getPath());
                    ni.uuid = null;
                    ni.props.remove("jcr:uuid");
                    ni.props.remove("jcr:baseVersion");
                    ni.props.remove("jcr:predecessors");
                    ni.props.remove("jcr:successors");
                    ni.props.remove("jcr:versionHistory");
                    node = null;
                }
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
            if (node == null) {
                if (currentNode.hasNode(ni.label)) {
                    node = currentNode.getNode(ni.label);
                    if (ni.primary != null && !node.getPrimaryNodeType().getName().equals(ni.primary)) {
                        oldNode = node;
                        node = null;
                    }
                }
            } else if (node.getName().equals(ni.name)) {
                if (ni.primary != null && !node.getPrimaryNodeType().getName().equals(ni.primary)) {
                    oldNode = node;
                    node = null;
                }
            } else {
                oldNode = node;
                node = null;
            }
        }
        if (oldNode != null && !this.isIncluded((Item)oldNode, oldNode.getDepth() - this.rootDepth)) {
            node = oldNode;
            oldNode = null;
        }
        if (oldNode != null) {
            new VersioningState(this.stack, oldNode).ensureCheckedOut();
            Node tmpNode = null;
            try {
                NodeIterator iter = oldNode.getNodes();
                while (iter.hasNext()) {
                    Node child = iter.nextNode();
                    if (tmpNode == null) {
                        tmpNode = this.session.getRootNode().addNode("tmp" + System.currentTimeMillis(), "nt:unstructured");
                    }
                    this.session.move(child.getPath(), tmpNode.getPath() + "/" + child.getName());
                }
            }
            catch (RepositoryException e) {
                log.warn("error while moving child nodes (ignored)", (Throwable)e);
            }
            Map<String, BlobInfo> blobs = this.binaries.get(oldNode.getPath());
            if (blobs != null) {
                for (BlobInfo info : blobs.values()) {
                    info.detach();
                }
            }
            oldNode.remove();
            node = this.createNode(currentNode, ni);
            if (tmpNode != null) {
                NodeIterator iter = tmpNode.getNodes();
                while (iter.hasNext()) {
                    Node child = iter.nextNode();
                    this.session.move(child.getPath(), node.getPath() + "/" + child.getName());
                }
                tmpNode.remove();
            }
            this.importInfo.onReplaced(node.getPath());
            return node;
        }
        DocViewProperty coProp = (DocViewProperty)ni.props.remove("jcr:isCheckedOut");
        boolean bl = isCheckedIn = coProp != null && coProp.values[0].equals("false");
        if (node == null) {
            if (!ni.props.containsKey("jcr:mixinTypes")) {
                ni.props.put("jcr:mixinTypes", new DocViewProperty("jcr:mixinTypes", new String[0], true, 7));
            }
            this.stack.ensureCheckedOut();
            node = this.createNode(currentNode, ni);
            if (node.isNodeType("nt:resource")) {
                if (!node.hasProperty("jcr:data")) {
                    this.importInfo.onMissing(node.getPath() + "/" + "jcr:data");
                }
            } else if (isCheckedIn && node.isNodeType("mix:versionable")) {
                this.importInfo.registerToVersion(node.getUUID());
            }
            this.importInfo.onCreated(node.getPath());
        } else if (this.isIncluded((Item)node, node.getDepth() - this.rootDepth)) {
            NodeType[] mixs;
            boolean modified = false;
            if (isCheckedIn && node.isNodeType("mix:versionable")) {
                this.importInfo.registerToVersion(node.getUUID());
            }
            VersioningState vs = new VersioningState(this.stack, node);
            ni.props.remove("jcr:primaryType");
            ni.props.remove("jcr:mixinTypes");
            ni.props.remove("jcr:uuid");
            ni.props.remove("jcr:baseVersion");
            ni.props.remove("jcr:predecessors");
            ni.props.remove("jcr:successors");
            ni.props.remove("jcr:versionHistory");
            HashSet<String> existingMixing = new HashSet<String>();
            for (NodeType nodeType : mixs = node.getMixinNodeTypes()) {
                existingMixing.add(nodeType.getName());
            }
            if (ni.mixins != null) {
                for (String string : ni.mixins) {
                    if (existingMixing.remove(string)) continue;
                    vs.ensureCheckedOut();
                    node.addMixin(string);
                    modified = true;
                }
            }
            for (String mixing : existingMixing) {
                vs.ensureCheckedOut();
                node.removeMixin(mixing);
                modified = true;
            }
            PropertyIterator propertyIterator = node.getProperties();
            while (propertyIterator.hasNext()) {
                Property p = propertyIterator.nextProperty();
                String propName = p.getName();
                if (PROTECTED_PROPERTIES.contains(propName) || ni.props.containsKey(propName) || this.saveProperties.contains(p.getPath())) continue;
                try {
                    vs.ensureCheckedOut();
                    p.remove();
                    modified = true;
                }
                catch (RepositoryException repositoryException) {}
            }
            for (DocViewProperty prop : ni.props.values()) {
                if (prop == null || PROTECTED_PROPERTIES.contains(prop.name)) continue;
                try {
                    modified |= prop.apply(node);
                }
                catch (RepositoryException repositoryException) {
                    try {
                        vs.ensureCheckedOut();
                        modified |= prop.apply(node);
                    }
                    catch (RepositoryException e1) {
                        log.warn("Error while setting property (ignore): " + (Object)((Object)e1));
                    }
                }
            }
            if (modified) {
                if (node.isNodeType("nt:resource") && !node.hasProperty("jcr:data")) {
                    this.importInfo.onMissing(node.getPath() + "/" + "jcr:data");
                }
                this.importInfo.onModified(node.getPath());
            } else {
                this.importInfo.onNop(node.getPath());
            }
        }
        return node;
    }

    private Node createNode(Node currentNode, DocViewNode ni) throws RepositoryException {
        try {
            String parentPath = currentNode.getPath();
            ContentHandler handler = this.session.getImportContentHandler(parentPath, 1);
            String[] prefixes = this.session.getNamespacePrefixes();
            handler.startDocument();
            for (String prefix : prefixes) {
                handler.startPrefixMapping(prefix, this.session.getNamespaceURI(prefix));
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", ni.name);
            handler.startElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node", attrs);
            boolean addMixRef = false;
            if (!ni.label.equals(ni.name) && ni.uuid == null) {
                ni.uuid = UUID.randomUUID().toString();
                ni.props.put("jcr:uuid", new DocViewProperty("jcr:uuid", new String[]{ni.uuid}, false, 1));
                DocViewProperty mix = (DocViewProperty)ni.props.get("jcr:mixinTypes");
                addMixRef = true;
                if (mix == null) {
                    mix = new DocViewProperty("jcr:mixinTypes", new String[]{"mix:referenceable"}, true, 7);
                    ni.props.put(mix.name, mix);
                } else {
                    for (String v : mix.values) {
                        if (!v.equals("mix:referenceable")) continue;
                        addMixRef = false;
                        break;
                    }
                    if (addMixRef) {
                        String[] vs = new String[mix.values.length + 1];
                        System.arraycopy(mix.values, 0, vs, 0, mix.values.length);
                        vs[mix.values.length] = "mix:referenceable";
                        mix = new DocViewProperty("jcr:mixinTypes", vs, true, 7);
                        ni.props.put(mix.name, mix);
                    }
                }
            }
            for (DocViewProperty p : ni.props.values()) {
                if (p == null || p.values == null || !PROTECTED_PROPERTIES.contains(p.name)) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", p.name);
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "type", "sv:type", "CDATA", PropertyType.nameFromValue((int)p.type));
                handler.startElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property", attrs);
                for (String v : p.values) {
                    handler.startElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value", EMPTY_ATTRIBUTES);
                    handler.characters(v.toCharArray(), 0, v.length());
                    handler.endElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value");
                }
                handler.endElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property");
            }
            handler.endElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node");
            handler.endDocument();
            Node node = null;
            if (ni.uuid != null) {
                try {
                    node = currentNode.getSession().getNodeByUUID(ni.uuid);
                }
                catch (RepositoryException e) {
                    log.warn("Newly created node not found by uuid {}: {}", (Object)(parentPath + "/" + ni.name), (Object)e.toString());
                }
            }
            if (node == null) {
                try {
                    node = currentNode.getNode(ni.label);
                }
                catch (RepositoryException e) {
                    log.warn("Newly created node not found by label {}: {}", (Object)(parentPath + "/" + ni.name), (Object)e.toString());
                }
            }
            if (node == null) {
                try {
                    node = currentNode.getNode(ni.name);
                }
                catch (RepositoryException e) {
                    log.warn("Newly created node not found by name {}: {}", (Object)(parentPath + "/" + ni.name), (Object)e.toString());
                    throw e;
                }
            }
            for (DocViewProperty p : ni.props.values()) {
                if (p == null || p.values == null || PROTECTED_PROPERTIES.contains(p.name)) continue;
                try {
                    p.apply(node);
                }
                catch (RepositoryException e) {
                    log.warn("Error while setting property (ignore): " + (Object)((Object)e));
                }
            }
            if (addMixRef) {
                node.removeMixin("mix:referenceable");
            }
            return node;
        }
        catch (SAXException e) {
            Exception root = e.getException();
            if (root instanceof RepositoryException) {
                throw (RepositoryException)((Object)root);
            }
            if (root instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            throw new RepositoryException("Error while creating node", (Throwable)root);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        log.debug("<- element {}", (Object)qName);
        try {
            NodeNameList childNames = this.stack.getChildNames();
            Node node = this.stack.getNode();
            if (node == null) {
                SysViewTransformer xform = this.stack.getTransformer();
                if (xform != null) {
                    xform.endNode();
                }
                if (this.stack.transformer != null) {
                    this.stack.transformer.close();
                    this.stack.transformer = null;
                    log.info("Sysview transformation complete.");
                }
            } else {
                NodeIterator iter = node.getNodes();
                while (iter.hasNext()) {
                    Node child = iter.nextNode();
                    String path = child.getPath();
                    String label = Text.getName(path);
                    if (!childNames.contains(label) && !this.hints.contains(path) && this.isIncluded((Item)child, child.getDepth() - this.rootDepth)) {
                        if (this.aclManagement.isACLNode(child)) {
                            if (this.aclHandling != AccessControlHandling.OVERWRITE && this.aclHandling != AccessControlHandling.MERGE && this.aclHandling != AccessControlHandling.CLEAR) continue;
                            this.importInfo.onDeleted(path);
                            this.aclManagement.clearACL(node);
                            continue;
                        }
                        this.importInfo.onDeleted(path);
                        child.remove();
                        continue;
                    }
                    if (this.aclHandling != AccessControlHandling.CLEAR || !this.aclManagement.isACLNode(child)) continue;
                    this.importInfo.onDeleted(path);
                    this.aclManagement.clearACL(node);
                }
                this.stack.restoreOrder();
            }
            this.stack = this.stack.pop();
            if (this.stack.isRoot()) {
                this.importInfo.setNameList(childNames);
                this.importInfo.setNode(node);
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.session.getNamespaceURI(prefix);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.session.getNamespacePrefix(uri);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    static {
        HashSet<String> props = new HashSet<String>();
        props.add("jcr:primaryType");
        props.add("jcr:mixinTypes");
        props.add("jcr:uuid");
        props.add("jcr:isCheckedOut");
        props.add("jcr:baseVersion");
        props.add("jcr:predecessors");
        props.add("jcr:successors");
        props.add("jcr:versionHistory");
        PROTECTED_PROPERTIES = Collections.unmodifiableSet(props);
    }

    private static class DocViewNode {
        private final String name;
        private final String label;
        private final Map<String, DocViewProperty> props = new HashMap<String, DocViewProperty>();
        private String uuid = null;
        private String[] mixins = null;
        private String primary = null;

        public DocViewNode(String name, String label, Attributes attributes, NamePathResolver npResolver) throws NamespaceException {
            this.name = name;
            this.label = label;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getType(i).equals("CDATA")) continue;
                Name pName = NameFactoryImpl.getInstance().create(attributes.getURI(i), ISO9075.decode((String)attributes.getLocalName(i)));
                DocViewProperty info = DocViewProperty.parse(npResolver.getJCRName(pName), attributes.getValue(i));
                this.props.put(info.name, info);
                if (pName.equals(NameConstants.JCR_UUID)) {
                    this.uuid = info.values[0];
                    continue;
                }
                if (pName.equals(NameConstants.JCR_PRIMARYTYPE)) {
                    this.primary = info.values[0];
                    continue;
                }
                if (!pName.equals(NameConstants.JCR_MIXINTYPES)) continue;
                this.mixins = info.values;
            }
        }
    }

    private static class SysViewTransformer {
        private ContentHandler handler;

        private SysViewTransformer(Node node) throws RepositoryException, SAXException {
            Session session = node.getSession();
            this.handler = session.getImportContentHandler(node.getPath(), 1);
            String[] prefixes = session.getNamespacePrefixes();
            this.handler.startDocument();
            for (String prefix : prefixes) {
                this.handler.startPrefixMapping(prefix, session.getNamespaceURI(prefix));
            }
        }

        public void close() throws SAXException {
            this.handler.endDocument();
        }

        public void startNode(DocViewNode ni) throws SAXException {
            log.debug("Transforming element to sysview {}", (Object)ni.name);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", ni.name);
            this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node", attrs);
            for (DocViewProperty p : ni.props.values()) {
                if (p == null || p.values == null) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", p.name);
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "type", "sv:type", "CDATA", PropertyType.nameFromValue((int)p.type));
                this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property", attrs);
                for (String v : p.values) {
                    this.handler.startElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value", EMPTY_ATTRIBUTES);
                    this.handler.characters(v.toCharArray(), 0, v.length());
                    this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value");
                }
                this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property");
            }
        }

        public void endNode() throws SAXException {
            this.handler.endElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node");
        }
    }

    private class StackElement {
        private final Node node;
        final StackElement parent;
        private final NodeNameList childNames = new NodeNameList();
        private boolean isCheckedOut;
        private SysViewTransformer transformer;

        public StackElement(StackElement parent, Node node) throws RepositoryException {
            this.node = node;
            this.parent = parent;
            this.isCheckedOut = node == null || !node.isNodeType("mix:versionable") || node.isCheckedOut();
        }

        public Node getNode() {
            return this.node;
        }

        public boolean isCheckedOut() {
            return this.isCheckedOut && (this.parent == null || this.parent.isCheckedOut());
        }

        public void ensureCheckedOut() throws RepositoryException {
            if (!this.isCheckedOut) {
                DocViewSAXImporter.this.importInfo.registerToVersion(this.node.getUUID());
                try {
                    this.node.checkout();
                }
                catch (RepositoryException e) {
                    log.warn("error while checkout node (ignored)", (Throwable)e);
                }
                this.isCheckedOut = true;
            }
            if (this.parent != null) {
                this.parent.ensureCheckedOut();
            }
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public void addName(String name) {
            this.childNames.addName(name);
        }

        public NodeNameList getChildNames() {
            return this.childNames;
        }

        public void restoreOrder() throws RepositoryException {
            if (this.childNames.needsReorder(this.node)) {
                this.ensureCheckedOut();
                this.childNames.restoreOrder(this.node);
            }
        }

        public StackElement push(Node node) throws RepositoryException {
            return new StackElement(this, node);
        }

        public StackElement pop() {
            return this.parent;
        }

        public void setTransformer(SysViewTransformer transformer) {
            this.transformer = transformer;
        }

        public SysViewTransformer getTransformer() {
            if (this.transformer != null) {
                return this.transformer;
            }
            return this.parent == null ? null : this.parent.getTransformer();
        }
    }

    private class VersioningState {
        private final StackElement stack;
        private final Node node;
        private boolean isCheckedOut;
        private boolean isParentCheckedOut;

        private VersioningState(StackElement stack, Node node) throws RepositoryException {
            this.stack = stack;
            this.node = node;
            this.isCheckedOut = node == null || !node.isNodeType("mix:versionable") || node.isCheckedOut();
            this.isParentCheckedOut = stack.isCheckedOut();
        }

        public void ensureCheckedOut() throws RepositoryException {
            if (!this.isCheckedOut) {
                DocViewSAXImporter.this.importInfo.registerToVersion(this.node.getUUID());
                try {
                    this.node.checkout();
                }
                catch (RepositoryException e) {
                    log.warn("error while checkout node (ignored)", (Throwable)e);
                }
                this.isCheckedOut = true;
            }
            if (!this.isParentCheckedOut) {
                this.stack.ensureCheckedOut();
                this.isParentCheckedOut = true;
            }
        }
    }

    private static class BlobInfo {
        private final boolean isMulti;
        private final List<Artifact> artifacts = new ArrayList<Artifact>();

        public BlobInfo(boolean multi) {
            this.isMulti = multi;
        }

        public boolean isFile() {
            return this.artifacts.size() > 0 && this.artifacts.get(0).getType() == ArtifactType.FILE;
        }

        public void add(Artifact a) {
            assert (this.artifacts.isEmpty());
            this.artifacts.add(a);
        }

        public void add(int idx, Artifact a) {
            while (idx >= this.artifacts.size()) {
                this.artifacts.add(null);
            }
            this.artifacts.set(idx, a);
        }

        public Value[] getValues(Session session) throws RepositoryException, IOException {
            Value[] values = new Value[this.artifacts.size()];
            for (int i = 0; i < values.length; ++i) {
                Artifact a = this.artifacts.get(i);
                values[i] = session.getValueFactory().createValue(a.getInputStream());
            }
            return values;
        }

        public Value getValue(Session session) throws RepositoryException, IOException {
            Artifact a = this.artifacts.get(0);
            return session.getValueFactory().createValue(a.getInputStream());
        }

        public void detach() {
            for (Artifact a : this.artifacts) {
                if (!(a instanceof PropertyValueArtifact)) continue;
                try {
                    ((PropertyValueArtifact)a).detach();
                }
                catch (IOException e) {
                    log.warn("error while detaching property artifact", (Throwable)e);
                }
                catch (RepositoryException e) {
                    log.warn("error while detaching property artifact", (Throwable)e);
                }
            }
        }
    }
}

