/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.api.ImportInfo;
import com.day.jcr.vault.fs.api.NodeNameList;
import com.day.jcr.vault.util.PathComparator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportInfoImpl
implements ImportInfo {
    static final Logger log = LoggerFactory.getLogger(ImportInfoImpl.class);
    private final TreeMap<String, ImportInfo.Type> mods = new TreeMap(new PathComparator());
    private NodeNameList nameList;
    private Node node;
    private int numModified;
    private Map<String, Exception> errorMap;
    private Set<String> toVersion = new LinkedHashSet<String>();

    public ImportInfoImpl() {
    }

    public ImportInfoImpl(ImportInfo base) {
        ImportInfoImpl baseImpl = (ImportInfoImpl)base;
        this.mods.putAll(baseImpl.mods);
        if (baseImpl.errorMap != null) {
            this.errorMap = new HashMap<String, Exception>(baseImpl.errorMap);
        }
        this.numModified = baseImpl.numModified;
        this.toVersion.addAll(baseImpl.toVersion);
    }

    @Override
    public NodeNameList getNameList() {
        return this.nameList;
    }

    public void setNameList(NodeNameList nameList) {
        this.nameList = nameList;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    @Override
    public void onModified(String path) {
        ImportInfo.Type prev = this.mods.get(path);
        if (prev == null || prev != ImportInfo.Type.CRE) {
            this.addMod(path, ImportInfo.Type.MOD);
        }
    }

    @Override
    public void onNop(String path) {
        if (!this.mods.containsKey(path)) {
            this.addMod(path, ImportInfo.Type.NOP);
        }
    }

    @Override
    public void onCreated(String path) {
        this.addMod(path, ImportInfo.Type.CRE);
    }

    @Override
    public void onDeleted(String path) {
        this.addMod(path, ImportInfo.Type.DEL);
    }

    @Override
    public void onReplaced(String path) {
        this.addMod(path, ImportInfo.Type.REP);
    }

    @Override
    public void onMissing(String path) {
        this.addMod(path, ImportInfo.Type.MIS);
    }

    @Override
    public void onError(String path, Exception e) {
        this.addMod(path, ImportInfo.Type.ERR);
        if (this.errorMap == null) {
            this.errorMap = new HashMap<String, Exception>();
        }
        this.errorMap.put(path, e);
    }

    private void addMod(String path, ImportInfo.Type mod) {
        if (this.mods.get(path) != ImportInfo.Type.ERR) {
            this.mods.put(path, mod);
            if (mod != ImportInfo.Type.NOP) {
                ++this.numModified;
            }
        }
        log.debug("{} {}", (Object)mod, (Object)path);
    }

    @Override
    public TreeMap<String, ImportInfo.Type> getModifications() {
        return this.mods;
    }

    @Override
    public Exception getError(String path) {
        return this.errorMap == null ? null : this.errorMap.get(path);
    }

    @Override
    public Collection<String> getToVersion() {
        return this.toVersion;
    }

    public void registerToVersion(String uuid) {
        this.toVersion.add(uuid);
    }

    public void checkinNodes(Session session) {
        Iterator<String> iter = this.toVersion.iterator();
        while (iter.hasNext()) {
            String uuid = iter.next();
            iter.remove();
            try {
                Node node = session.getNodeByUUID(uuid);
                try {
                    Version v = node.checkin();
                    log.info("Checked in versionable node {} (v={})", (Object)node.getPath(), (Object)v.getName());
                }
                catch (RepositoryException e) {
                    log.error("Error while checkin node {}: {}", (Object)node.getPath(), (Object)e.toString());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving node to be versioned.", (Throwable)e);
            }
        }
    }

    @Override
    public int numModified() {
        return this.numModified;
    }

    @Override
    public int numErrors() {
        return this.errorMap == null ? 0 : this.errorMap.size();
    }
}

