/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ImportMode;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.AbstractArtifactHandler;
import com.day.jcr.vault.fs.impl.io.CNDImporter;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import com.day.jcr.vault.util.PathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class NodeTypeArtifactHandler
extends AbstractArtifactHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportInfoImpl accept(WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        Artifact primary = artifacts.getPrimaryData();
        if (primary == null) {
            return null;
        }
        if (artifacts.size() != 1) {
            return null;
        }
        if (primary.getSerializationType() != SerializationType.CND) {
            return null;
        }
        String path = PathUtil.getPath(parent, primary.getRelativePath());
        if (wspFilter.getImportMode(path) == ImportMode.MERGE) {
            ImportInfoImpl info = new ImportInfoImpl();
            info.onNop(path);
            return info;
        }
        CNDImporter importer = new CNDImporter();
        InputStream in = primary.getInputStream();
        ImportInfoImpl info = null;
        try {
            InputStreamReader r = new InputStreamReader(in, "utf-8");
            info = importer.doImport(parent, primary.getRelativePath(), r, primary.getRelativePath());
        }
        finally {
            in.close();
        }
        return info;
    }
}

