/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.spi.ProgressTracker;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSave {
    private static final Logger log = LoggerFactory.getLogger(AutoSave.class);
    private int numModified;
    private int lastSave;
    private int threshold = 1024;
    private Set<String> missingMandatory = new HashSet<String>();
    private ProgressTracker tracker;
    private boolean dryRun;

    public AutoSave() {
    }

    public AutoSave(int threshold) {
        this.threshold = threshold;
    }

    public void setTracker(ProgressTracker tracker) {
        this.tracker = tracker;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean needsSave() {
        boolean res;
        boolean bl = res = this.numModified - this.lastSave >= this.threshold;
        if (res && !this.missingMandatory.isEmpty()) {
            log.info("Treshhold of {} reached but still unresolved mandatory items.", (Object)this.threshold);
            res = false;
        }
        return res;
    }

    public void save(Session session) throws RepositoryException {
        if (this.threshold == Integer.MAX_VALUE) {
            log.info("Save disabled.");
            return;
        }
        int diff = this.numModified - this.lastSave;
        log.info("Threshold of {} reached. {} approx {} transient changes. {} unresolved", new Object[]{this.dryRun ? "dry run, reverting" : "saving", this.threshold, diff, this.missingMandatory.size()});
        if (this.tracker != null) {
            if (this.dryRun) {
                this.tracker.track("reverting approx " + diff + " nodes... (dry run)", "");
            } else {
                this.tracker.track("saving approx " + diff + " nodes...", "");
            }
        }
        if (session != null) {
            if (this.dryRun) {
                session.refresh(false);
            } else {
                try {
                    session.save();
                }
                catch (RepositoryException e) {
                    log.error("error during auto save - retrying after refresh...");
                    session.refresh(true);
                    session.save();
                }
            }
        }
        this.lastSave = this.numModified;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean modified(int num) {
        this.numModified += num;
        return this.needsSave();
    }

    public void markMissing(String path) {
        this.missingMandatory.add(path);
    }

    public void markResolved(String path) {
        this.missingMandatory.remove(path);
    }

    public String toString() {
        return String.valueOf(this.threshold);
    }
}

