/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.api.PathFilterSet;
import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.DefaultMetaInf;
import com.day.jcr.vault.fs.config.DefaultWorkspaceFilter;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.config.VaultSettings;
import com.day.jcr.vault.fs.io.AbstractArchive;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.fs.spi.CNDReader;
import com.day.jcr.vault.fs.spi.ServiceProviderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrArchive
extends AbstractArchive {
    private static final Logger log = LoggerFactory.getLogger(JcrArchive.class);
    private Node archiveRoot;
    private final String rootPath;
    private DefaultMetaInf inf;
    private JcrEntry jcrRoot;

    public JcrArchive(Node archiveRoot, String rootPath) {
        this.archiveRoot = archiveRoot;
        this.rootPath = rootPath;
    }

    public void open(boolean strict) throws IOException {
        try {
            if (this.archiveRoot.hasNode("META-INF/vault")) {
                this.inf = this.loadMetaInf(new JcrEntry(this.archiveRoot.getNode("META-INF/vault"), "META-INF/vault", true), strict);
            } else {
                this.inf = new DefaultMetaInf();
                this.inf.setSettings(VaultSettings.createDefault());
                DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
                PathFilterSet filterSet = new PathFilterSet(this.rootPath);
                filter.add(filterSet);
                this.inf.setFilter(filter);
            }
            this.jcrRoot = this.archiveRoot.hasNode("jcr_root") ? new JcrEntry(this.archiveRoot.getNode("jcr_root"), "jcr_root", true) : new JcrEntry(this.archiveRoot, this.archiveRoot.getName(), true);
        }
        catch (RepositoryException e) {
            IOException ie = new IOException("Error while opening JCR archive.");
            ie.initCause(e);
            throw ie;
        }
        catch (ConfigurationException e) {
            IOException ie = new IOException("Error while opening JCR archive.");
            ie.initCause(e);
            throw ie;
        }
    }

    private DefaultMetaInf loadMetaInf(Archive.Entry dir, boolean strict) throws IOException, ConfigurationException {
        DefaultMetaInf inf = new DefaultMetaInf();
        for (Archive.Entry entry : dir.getChildren()) {
            String name = entry.getName();
            VaultInputSource src = this.getInputSource(entry);
            if (name.equals("filter.xml")) {
                inf.loadFilter(src.getByteStream(), src.getSystemId());
                continue;
            }
            if (name.equals("config.xml")) {
                inf.loadConfig(src.getByteStream(), src.getSystemId());
                continue;
            }
            if (name.equals("settings.xml")) {
                inf.loadSettings(src.getByteStream(), src.getSystemId());
                continue;
            }
            if (name.equals("properties.xml")) {
                inf.loadProperties(src.getByteStream(), src.getSystemId());
                continue;
            }
            if (name.equals("definition/.content.xml")) {
                inf.setHasDefinition(true);
                log.info("Contains package definition {}.", (Object)src.getSystemId());
                continue;
            }
            if (!name.endsWith(".cnd")) continue;
            try {
                InputStreamReader r = new InputStreamReader(src.getByteStream(), "utf8");
                CNDReader reader = ServiceProviderFactory.getProvider().getCNDReader();
                reader.read(r, entry.getName(), null);
                inf.getNodeTypes().add(reader);
                log.info("Loaded nodetypes from {}.", (Object)src.getSystemId());
            }
            catch (IOException e1) {
                log.error("Error while reading CND: {}", (Object)e1.toString());
                if (!strict) continue;
                throw e1;
            }
        }
        if (inf.getFilter() == null) {
            log.info("Archive {} does not contain filter definition.", (Object)this);
        }
        if (inf.getConfig() == null) {
            log.info("Archive {} does not contain vault config.", (Object)this);
        }
        if (inf.getSettings() == null) {
            log.info("Archive {} does not contain vault settings. using default.", (Object)this);
            VaultSettings settings = new VaultSettings();
            settings.getIgnoredNames().add(".svn");
            inf.setSettings(settings);
        }
        if (inf.getProperties() == null) {
            log.info("Archive {} does not contain properties.", (Object)this);
        }
        if (inf.getNodeTypes().isEmpty()) {
            log.info("Archive {} does not contain nodetypes.", (Object)this);
        }
        return inf;
    }

    public void close() {
        this.archiveRoot = null;
        this.jcrRoot = null;
    }

    public Archive.Entry getJcrRoot() {
        return this.jcrRoot;
    }

    public Archive.Entry getRoot() throws IOException {
        return new JcrEntry(this.archiveRoot, "", true);
    }

    public MetaInf getMetaInf() {
        return this.inf;
    }

    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        if (entry == null || entry.isDirectory()) {
            return null;
        }
        try {
            Node content = ((JcrEntry)entry).node.getNode("jcr:content");
            return content.getProperty("jcr:data").getBinary().getStream();
        }
        catch (RepositoryException e) {
            IOException e1 = new IOException("Unable to open input source.");
            e1.initCause(e);
            throw e1;
        }
    }

    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        if (entry == null || entry.isDirectory()) {
            return null;
        }
        try {
            final Node content = ((JcrEntry)entry).node.getNode("jcr:content");
            final String systemId = ((JcrEntry)entry).node.getPath();
            return new VaultInputSource(){
                {
                    this.setSystemId(systemId);
                }

                public InputStream getByteStream() {
                    try {
                        return content.getProperty("jcr:data").getBinary().getStream();
                    }
                    catch (RepositoryException e) {
                        log.error("Error while opening input stream of " + content, (Throwable)e);
                        return null;
                    }
                }

                public long getContentLength() {
                    try {
                        return content.getProperty("jcr:data").getLength();
                    }
                    catch (RepositoryException e) {
                        log.error("Error while retrieving length of " + content, (Throwable)e);
                        return -1L;
                    }
                }

                public long getLastModified() {
                    try {
                        return content.getProperty("jcr:lastModified").getDate().getTimeInMillis();
                    }
                    catch (RepositoryException e) {
                        log.error("Error while retrieving last modified of " + content, (Throwable)e);
                        return 0L;
                    }
                }
            };
        }
        catch (RepositoryException e) {
            IOException e1 = new IOException("Unable to open input source.");
            e1.initCause(e);
            throw e1;
        }
    }

    public String toString() {
        try {
            return this.archiveRoot.getPath();
        }
        catch (RepositoryException e) {
            return this.archiveRoot.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JcrEntry
    implements Archive.Entry {
        private final Node node;
        private final boolean isDir;
        private final String name;

        private JcrEntry(Node node, String name, boolean isDir) {
            this.node = node;
            this.isDir = isDir;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isDirectory() {
            return this.isDir;
        }

        public Collection<Archive.Entry> getChildren() {
            if (this.isDir) {
                try {
                    NodeIterator iter = this.node.getNodes();
                    long size = iter.getSize();
                    if (size < 0L) {
                        size = 0L;
                    }
                    ArrayList<Archive.Entry> ret = new ArrayList<Archive.Entry>((int)size);
                    while (iter.hasNext()) {
                        boolean isDir;
                        Node child = iter.nextNode();
                        String name = child.getName();
                        if (name.equals(".svn")) continue;
                        if (child.isNodeType("nt:folder")) {
                            isDir = true;
                        } else if (child.isNodeType("nt:file")) {
                            isDir = false;
                        } else {
                            log.info("Skipping node {} with unknown type {}.", (Object)child.getPath(), (Object)child.getPrimaryNodeType().getName());
                            continue;
                        }
                        ret.add(new JcrEntry(child, name, isDir));
                    }
                    return ret;
                }
                catch (RepositoryException e) {
                    log.error("Error while listing child nodes of {}", (Object)this.node, (Object)e);
                    throw new IllegalStateException("Error while listing child nodes of " + this.node, e);
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Archive.Entry getChild(String name) {
            try {
                if (this.isDir && this.node.hasNode(name) && !name.equals(".svn")) {
                    boolean isDir;
                    Node child = this.node.getNode(name);
                    if (child.isNodeType("nt:folder")) {
                        isDir = true;
                    } else if (child.isNodeType("nt:file")) {
                        isDir = false;
                    } else {
                        log.info("Skipping node {} with unknown type {}.", (Object)child.getPath(), (Object)child.getPrimaryNodeType().getName());
                        return null;
                    }
                    return new JcrEntry(child, name, isDir);
                }
                return null;
            }
            catch (RepositoryException e) {
                log.error("Error while retrieving child node of {}", (Object)this.node, (Object)e);
                throw new IllegalStateException("Error while retrieving child node of " + this.node, e);
            }
        }
    }
}

