/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.spi;

import com.day.jcr.vault.fs.spi.JcrVersion;
import com.day.jcr.vault.fs.spi.ServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(ServiceProviderFactory.class);
    private static ServiceProvider instance;
    private static final String CLASS_JCR_NODE_TYPE_DEFINITION = "javax.jcr.nodetype.NodeTypeDefinition";
    private static final Map<JcrVersion, String> providers;

    public static ServiceProvider getProvider() {
        if (instance == null) {
            JcrVersion version;
            try {
                ServiceProviderFactory.class.getClassLoader().loadClass(CLASS_JCR_NODE_TYPE_DEFINITION);
                log.info("javax.jcr.nodetype.NodeTypeDefinition detected. Assuming JCR 2.0");
                version = JcrVersion.V20;
            }
            catch (ClassNotFoundException e) {
                log.info("No javax.jcr.nodetype.NodeTypeDefinition detected. Assuming JCR 1.0.");
                version = JcrVersion.V10;
            }
            String className = providers.get((Object)version);
            if (className == null) {
                throw new InternalError("No valid provider configured for " + (Object)((Object)version));
            }
            try {
                Class<?> cls = ServiceProviderFactory.class.getClassLoader().loadClass(className);
                instance = (ServiceProvider)cls.newInstance();
            }
            catch (Exception e) {
                log.error("Could not create Service provider for " + (Object)((Object)version), (Throwable)e);
                InternalError er = new InternalError("No valid provider configured for " + (Object)((Object)version));
                er.initCause(e);
                throw er;
            }
        }
        return instance;
    }

    static {
        providers = new HashMap<JcrVersion, String>();
        providers.put(JcrVersion.V10, "com.day.jcr.vault.fs.spi.impl.jcr10.JcrServiceProvider");
        providers.put(JcrVersion.V20, "com.day.jcr.vault.fs.spi.impl.jcr20.JcrServiceProvider");
    }
}

