/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.spi.impl.jcr10;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.util.ISO9075;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNDWriter {
    public static final Set<String> JSR170_NODE_TYPES = new HashSet<String>();
    public static final Set<String> JACKRABBIT_NODE_TYPES;
    public static final Set<String> CRX_NODE_TYPES;
    private static final String INDENT = "  ";
    private final Session session;
    private Writer out;
    private Writer nsWriter;
    private HashSet<String> usedNamespaces = new HashSet();

    public CNDWriter(Writer out, Session s) {
        this.session = s;
        if (s != null) {
            this.out = new StringWriter();
            this.nsWriter = out;
        } else {
            this.out = out;
            this.nsWriter = null;
        }
    }

    public static void write(Collection<NodeType> l, Writer out, Session s) throws IOException, RepositoryException {
        CNDWriter w = new CNDWriter(out, s);
        for (NodeType n : l) {
            w.write(n);
        }
        w.close();
    }

    public void write(NodeType d) throws IOException, RepositoryException {
        this.writeName(d);
        this.writeSupertypes(d);
        this.writeOptions(d);
        this.writePropDefs(d);
        this.writeNodeDefs(d);
        this.out.write("\n\n");
    }

    public void close() throws IOException {
        if (this.nsWriter != null) {
            this.nsWriter.write("\n");
            this.out.close();
            this.nsWriter.write(((StringWriter)this.out).getBuffer().toString());
            this.out = this.nsWriter;
            this.nsWriter = null;
        }
        this.out.flush();
        this.out = null;
    }

    private void writeName(NodeType ntd) throws IOException {
        try {
            this.out.write("[");
            this.out.write(this.resolve(ntd.getName()));
            this.out.write("]");
        }
        catch (RepositoryException e) {
            throw new IOException(e.toString());
        }
    }

    private void writeSupertypes(NodeType ntd) throws IOException, RepositoryException {
        LinkedList<NodeType> superTypes = new LinkedList<NodeType>();
        for (NodeType s : ntd.getDeclaredSupertypes()) {
            superTypes.add(s);
        }
        String delim = " > ";
        for (NodeType s : superTypes) {
            this.out.write(delim);
            this.out.write(this.resolve(s.getName()));
            delim = ", ";
        }
    }

    private void writeOptions(NodeType ntd) throws IOException {
        if (ntd.hasOrderableChildNodes()) {
            this.out.write("\n  ");
            this.out.write("orderable");
            if (ntd.isMixin()) {
                this.out.write(" mixin");
            }
        } else if (ntd.isMixin()) {
            this.out.write("\n  ");
            this.out.write("mixin");
        }
    }

    private void writePropDefs(NodeType ntd) throws IOException, RepositoryException {
        for (PropertyDefinition pd : ntd.getDeclaredPropertyDefinitions()) {
            this.writePropDef(ntd, pd);
        }
    }

    private void writeNodeDefs(NodeType ntd) throws IOException, RepositoryException {
        for (NodeDefinition nd : ntd.getDeclaredChildNodeDefinitions()) {
            this.writeNodeDef(ntd, nd);
        }
    }

    private void writePropDef(NodeType ntd, PropertyDefinition pd) throws IOException, RepositoryException {
        this.out.write("\n  - ");
        String name = pd.getName();
        if (name.equals("*")) {
            this.out.write(42);
        } else {
            this.out.write(this.resolve(name));
        }
        this.out.write(" (");
        this.out.write(PropertyType.nameFromValue((int)pd.getRequiredType()).toLowerCase());
        this.out.write(")");
        this.writeDefaultValues(pd.getDefaultValues());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(pd.getName()) ? " primary" : "");
        if (pd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (pd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (pd.isProtected()) {
            this.out.write(" protected");
        }
        if (pd.isMultiple()) {
            this.out.write(" multiple");
        }
        if (pd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)pd.getOnParentVersion()).toLowerCase());
        }
        this.writeValueConstraints(pd.getValueConstraints());
    }

    private void writeDefaultValues(Value[] dva) throws IOException {
        if (dva != null && dva.length > 0) {
            String delim = " = '";
            for (Value aDva : dva) {
                this.out.write(delim);
                try {
                    this.out.write(this.escape(aDva.getString()));
                }
                catch (RepositoryException e) {
                    this.out.write(this.escape(aDva.toString()));
                }
                this.out.write("'");
                delim = ", '";
            }
        }
    }

    private void writeValueConstraints(String[] vca) throws IOException {
        if (vca != null && vca.length > 0) {
            String vc = vca[0];
            this.out.write(" < '");
            this.out.write(this.escape(vc));
            this.out.write("'");
            for (int i = 1; i < vca.length; ++i) {
                vc = vca[i];
                this.out.write(", '");
                this.out.write(this.escape(vc));
                this.out.write("'");
            }
        }
    }

    private void writeNodeDef(NodeType ntd, NodeDefinition nd) throws IOException, RepositoryException {
        this.out.write("\n  + ");
        String name = nd.getName();
        if (name.equals("*")) {
            this.out.write(42);
        } else {
            this.out.write(this.resolve(name));
        }
        this.writeRequiredTypes(nd.getRequiredPrimaryTypes());
        this.writeDefaultType(nd.getDefaultPrimaryType());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(nd.getName()) ? " primary" : "");
        if (nd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (nd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (nd.isProtected()) {
            this.out.write(" protected");
        }
        if (nd.allowsSameNameSiblings()) {
            this.out.write(" multiple");
        }
        if (nd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)nd.getOnParentVersion()).toLowerCase());
        }
    }

    private void writeRequiredTypes(NodeType[] reqTypes) throws IOException, RepositoryException {
        if (reqTypes != null && reqTypes.length > 0) {
            String delim = " (";
            for (NodeType reqType : reqTypes) {
                this.out.write(delim);
                this.out.write(this.resolve(reqType.getName()));
                delim = ", ";
            }
            this.out.write(")");
        }
    }

    private void writeDefaultType(NodeType defType) throws IOException, RepositoryException {
        if (defType != null && !defType.getName().equals("*")) {
            this.out.write(" = ");
            this.out.write(this.resolve(defType.getName()));
        }
    }

    private String resolve(String qname) throws IOException, RepositoryException {
        if (qname == null) {
            return "";
        }
        try {
            String resolvedName;
            int idx = qname.indexOf(58);
            if (idx > 0) {
                String prefix = qname.substring(0, idx);
                if (this.nsWriter != null && this.session != null && !this.usedNamespaces.contains(prefix)) {
                    this.usedNamespaces.add(prefix);
                    this.nsWriter.write("<'");
                    this.nsWriter.write(prefix);
                    this.nsWriter.write("'='");
                    this.nsWriter.write(this.escape(this.session.getNamespaceURI(prefix)));
                    this.nsWriter.write("'>\n");
                }
            }
            if ((resolvedName = ISO9075.encode((String)qname)).indexOf(45) >= 0 || resolvedName.indexOf(43) >= 0) {
                return "'" + resolvedName + "'";
            }
            return resolvedName;
        }
        catch (NamespaceException e) {
            return qname;
        }
    }

    private String escape(String s) {
        StringBuffer sb = new StringBuffer();
        for (char c : s.toCharArray()) {
            if (c == '\\') {
                sb.append('\\');
            } else if (c == '\'') {
                sb.append('\'');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        JSR170_NODE_TYPES.add("nt:base");
        JSR170_NODE_TYPES.add("nt:unstructured");
        JSR170_NODE_TYPES.add("mix:referenceable");
        JSR170_NODE_TYPES.add("mix:lockable");
        JSR170_NODE_TYPES.add("mix:versionable");
        JSR170_NODE_TYPES.add("nt:versionHistory");
        JSR170_NODE_TYPES.add("nt:versionLabels");
        JSR170_NODE_TYPES.add("nt:version");
        JSR170_NODE_TYPES.add("nt:frozenNode");
        JSR170_NODE_TYPES.add("nt:versionedChild");
        JSR170_NODE_TYPES.add("nt:nodeType");
        JSR170_NODE_TYPES.add("nt:propertyDefinition");
        JSR170_NODE_TYPES.add("nt:childNodeDefinition");
        JSR170_NODE_TYPES.add("nt:hierarchyNode");
        JSR170_NODE_TYPES.add("nt:folder");
        JSR170_NODE_TYPES.add("nt:file");
        JSR170_NODE_TYPES.add("nt:linkedFile");
        JSR170_NODE_TYPES.add("nt:resource");
        JSR170_NODE_TYPES.add("nt:query");
        JACKRABBIT_NODE_TYPES = new HashSet<String>();
        JACKRABBIT_NODE_TYPES.add("rep:nodeTypes");
        JACKRABBIT_NODE_TYPES.add("rep:root");
        JACKRABBIT_NODE_TYPES.add("rep:system");
        JACKRABBIT_NODE_TYPES.add("rep:versionStorage");
        CRX_NODE_TYPES = new HashSet<String>();
        CRX_NODE_TYPES.add("crx:XmlNode");
        CRX_NODE_TYPES.add("crx:XmlCharacterData");
        CRX_NODE_TYPES.add("crx:XmlElement");
        CRX_NODE_TYPES.add("crx:XmlDocument");
        CRX_NODE_TYPES.add("crx:XmlProcessingInstruction");
        CRX_NODE_TYPES.add("crx:Package");
        CRX_NODE_TYPES.add("crx:ItemFilter");
        CRX_NODE_TYPES.add("crx:HierarchyFilter");
        CRX_NODE_TYPES.add("crx:OPVValueFilter");
        CRX_NODE_TYPES.add("crx:DeclaredTypeFilter");
        CRX_NODE_TYPES.add("crx:NodeTypeFilter");
        CRX_NODE_TYPES.add("crx:XPathFilter");
        CRX_NODE_TYPES.add("rep:AccessControllable");
        CRX_NODE_TYPES.add("rep:AccessControl");
        CRX_NODE_TYPES.add("rep:Permission");
        CRX_NODE_TYPES.add("rep:GrantPermission");
        CRX_NODE_TYPES.add("rep:DenyPermission");
        CRX_NODE_TYPES.add("rep:Principal");
        CRX_NODE_TYPES.add("rep:Impersonateable");
        CRX_NODE_TYPES.add("rep:User");
        CRX_NODE_TYPES.add("rep:Group");
        CRX_NODE_TYPES.add("rep:PrincipalFolder");
        CRX_NODE_TYPES.add("rep:ExternalPrincipal");
        CRX_NODE_TYPES.add("rep:Sudoers");
        CRX_NODE_TYPES.add("rep:WorkspaceAccess");
        CRX_NODE_TYPES.add("rep:Workspace");
        CRX_NODE_TYPES.add("crx:ResourceBundle");
        CRX_NODE_TYPES.add("crx:RequestMapping");
        CRX_NODE_TYPES.add("crx:NodeTypeRequestMapping");
        CRX_NODE_TYPES.add("crx:PathRequestMapping");
    }
}

