/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.spi.impl.jcr10.compact;

import com.day.jcr.vault.fs.spi.impl.jcr10.compact.Lexer;
import com.day.jcr.vault.fs.spi.impl.jcr10.compact.ParseException;
import com.day.jcr.vault.fs.spi.impl.jcr10.compact.QNodeTypeDefinitionsBuilder;
import com.day.jcr.vault.fs.spi.impl.jcr10.compact.QNodeTypeDefinitionsBuilderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.util.ISO9075;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactNodeTypeDefReader {
    public static final NamespaceMapping NS_DEFAULTS;
    private final List<QNodeTypeDefinition> nodeTypeDefs = new LinkedList<QNodeTypeDefinition>();
    private final NamespaceMapping nsMapping;
    private final NamePathResolver resolver;
    private final Lexer lexer;
    private String currentToken;
    private final QNodeTypeDefinitionsBuilder builder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompactNodeTypeDefReader read(File file) throws ParseException, IOException {
        FileInputStream in = null;
        Reader r = null;
        try {
            in = new FileInputStream(file);
            r = new InputStreamReader((InputStream)in, "utf8");
            CompactNodeTypeDefReader compactNodeTypeDefReader = new CompactNodeTypeDefReader(r, file.getPath());
            return compactNodeTypeDefReader;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public CompactNodeTypeDefReader(Reader r, String systemId) throws ParseException {
        this(r, systemId, null, null);
    }

    public CompactNodeTypeDefReader(Reader r, String systemId, QNodeTypeDefinitionsBuilder builder) throws ParseException {
        this(r, systemId, null, builder);
    }

    public CompactNodeTypeDefReader(Reader r, String systemId, NamespaceMapping mapping) throws ParseException {
        this(r, systemId, mapping, null);
    }

    public CompactNodeTypeDefReader(Reader r, String systemId, NamespaceMapping mapping, QNodeTypeDefinitionsBuilder builder) throws ParseException {
        this.builder = builder == null ? new QNodeTypeDefinitionsBuilderImpl() : builder;
        this.lexer = new Lexer(r, systemId);
        this.nsMapping = mapping == null ? new NamespaceMapping((NamespaceResolver)NS_DEFAULTS) : mapping;
        this.resolver = new DefaultNamePathResolver((NamespaceResolver)this.nsMapping);
        this.nextToken();
        this.parse();
    }

    public String getSystemId() {
        return this.lexer.getSystemId();
    }

    public List<QNodeTypeDefinition> getNodeTypeDefinitions() {
        return this.nodeTypeDefs;
    }

    public NamespaceMapping getNamespaceMapping() {
        return this.nsMapping;
    }

    private void parse() throws ParseException {
        while (!this.currentTokenEquals("eof") && this.doNameSpace()) {
        }
        while (!this.currentTokenEquals("eof")) {
            QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd = this.builder.newQNodeTypeDefinition();
            ntd.setOrderableChildNodes(false);
            ntd.setMixin(false);
            ntd.setPrimaryItemName(null);
            this.doNodeTypeName(ntd);
            this.doSuperTypes(ntd);
            this.doOptions(ntd);
            this.doItemDefs(ntd);
            this.nodeTypeDefs.add(ntd.build());
        }
    }

    private boolean doNameSpace() throws ParseException {
        if (!this.currentTokenEquals('<')) {
            return false;
        }
        this.nextToken();
        String prefix = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('=')) {
            this.lexer.fail("Missing = in namespace decl.");
        }
        this.nextToken();
        String uri = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('>')) {
            this.lexer.fail("Missing > in namespace decl.");
        }
        try {
            this.nsMapping.setMapping(prefix, uri);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        this.nextToken();
        return true;
    }

    private void doNodeTypeName(QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        if (!this.currentTokenEquals('[')) {
            this.lexer.fail("Missing '[' delimiter for beginning of node type name");
        }
        this.nextToken();
        ntd.setName(this.toName(this.currentToken));
        this.nextToken();
        if (!this.currentTokenEquals(']')) {
            this.lexer.fail("Missing ']' delimiter for end of node type name, found " + this.currentToken);
        }
        this.nextToken();
    }

    private void doSuperTypes(QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        HashSet<Name> supertypes = new HashSet<Name>();
        if (this.currentTokenEquals('>')) {
            do {
                this.nextToken();
                supertypes.add(this.toName(this.currentToken));
                this.nextToken();
            } while (this.currentTokenEquals(','));
        }
        ntd.setSupertypes(supertypes.toArray(new Name[supertypes.size()]));
    }

    private void doOptions(QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        boolean hasOption = true;
        while (hasOption) {
            if (this.currentTokenEquals(Lexer.ORDERABLE)) {
                this.nextToken();
                ntd.setOrderableChildNodes(true);
                continue;
            }
            if (this.currentTokenEquals(Lexer.MIXIN)) {
                this.nextToken();
                ntd.setMixin(true);
                continue;
            }
            if (this.currentTokenEquals(Lexer.PRIMARYITEM)) {
                this.nextToken();
                ntd.setPrimaryItemName(this.toName(this.currentToken));
                this.nextToken();
                continue;
            }
            hasOption = false;
        }
    }

    private void doItemDefs(QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        LinkedList<QPropertyDefinition> propertyDefinitions = new LinkedList<QPropertyDefinition>();
        LinkedList<QNodeDefinition> nodeDefinitions = new LinkedList<QNodeDefinition>();
        while (this.currentTokenEquals('-') || this.currentTokenEquals('+')) {
            if (this.currentTokenEquals('-')) {
                QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd = ntd.newQPropertyDefinition();
                pd.setAutoCreated(false);
                pd.setDeclaringNodeType(ntd.getName());
                pd.setDefaultValues(null);
                pd.setMandatory(false);
                pd.setMultiple(false);
                pd.setOnParentVersion(1);
                pd.setProtected(false);
                pd.setRequiredType(1);
                pd.setValueConstraints(new String[0]);
                this.nextToken();
                this.doPropertyDefinition(pd, ntd);
                propertyDefinitions.add(pd.build());
                continue;
            }
            if (!this.currentTokenEquals('+')) continue;
            QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd = ntd.newQNodeDefinitionBuilder();
            nd.setAllowsSameNameSiblings(false);
            nd.setAutoCreated(false);
            nd.setDeclaringNodeType(ntd.getName());
            nd.setMandatory(false);
            nd.setOnParentVersion(1);
            nd.setProtected(false);
            nd.setDefaultPrimaryType(null);
            nd.setRequiredPrimaryTypes(new Name[]{NameConstants.NT_BASE});
            this.nextToken();
            this.doChildNodeDefinition(nd, ntd);
            nodeDefinitions.add(nd.build());
        }
        ntd.setPropertyDefs(propertyDefinitions.toArray(new QPropertyDefinition[propertyDefinitions.size()]));
        ntd.setChildNodeDefs(nodeDefinitions.toArray(new QNodeDefinition[nodeDefinitions.size()]));
    }

    private void doPropertyDefinition(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd, QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        if (this.currentToken.equals("*")) {
            pd.setName(NameConstants.ANY_NAME);
        } else {
            pd.setName(this.toName(this.currentToken));
        }
        this.nextToken();
        this.doPropertyType(pd);
        this.doPropertyDefaultValue(pd);
        this.doPropertyAttributes(pd, ntd);
        this.doPropertyValueConstraints(pd);
    }

    private void doPropertyType(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd) throws ParseException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        this.nextToken();
        if (this.currentTokenEquals(Lexer.STRING)) {
            pd.setRequiredType(1);
        } else if (this.currentTokenEquals(Lexer.BINARY)) {
            pd.setRequiredType(2);
        } else if (this.currentTokenEquals(Lexer.LONG)) {
            pd.setRequiredType(3);
        } else if (this.currentTokenEquals(Lexer.DOUBLE)) {
            pd.setRequiredType(4);
        } else if (this.currentTokenEquals(Lexer.BOOLEAN)) {
            pd.setRequiredType(6);
        } else if (this.currentTokenEquals(Lexer.DATE)) {
            pd.setRequiredType(5);
        } else if (this.currentTokenEquals(Lexer.NAME)) {
            pd.setRequiredType(7);
        } else if (this.currentTokenEquals(Lexer.PATH)) {
            pd.setRequiredType(8);
        } else if (this.currentTokenEquals(Lexer.REFERENCE)) {
            pd.setRequiredType(9);
        } else if (this.currentTokenEquals(Lexer.UNDEFINED)) {
            pd.setRequiredType(0);
        } else {
            this.lexer.fail("Unkown property type '" + this.currentToken + "' specified");
        }
        this.nextToken();
        if (!this.currentTokenEquals(')')) {
            this.lexer.fail("Missing ')' delimiter for end of property type");
        }
        this.nextToken();
    }

    private void doPropertyAttributes(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd, QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        while (this.currentTokenEquals(Lexer.PROP_ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                if (ntd.getPrimaryItemName() != null) {
                    String name = null;
                    try {
                        name = this.resolver.getJCRName(ntd.getName());
                    }
                    catch (NamespaceException e) {
                        // empty catch block
                    }
                    this.lexer.fail("More than one primary item specified in node type '" + name + "'");
                }
                ntd.setPrimaryItemName(pd.getName());
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                pd.setAutoCreated(true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                pd.setMandatory(true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                pd.setProtected(true);
            } else if (this.currentTokenEquals(Lexer.MULTIPLE)) {
                pd.setMultiple(true);
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                pd.setOnParentVersion(1);
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                pd.setOnParentVersion(2);
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                pd.setOnParentVersion(3);
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                pd.setOnParentVersion(4);
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                pd.setOnParentVersion(5);
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                pd.setOnParentVersion(6);
            }
            this.nextToken();
        }
    }

    private void doPropertyDefaultValue(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd) throws ParseException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        LinkedList<QValue> defaultValues = new LinkedList<QValue>();
        do {
            this.nextToken();
            try {
                defaultValues.add(pd.createValue(this.currentToken, this.resolver));
            }
            catch (ValueFormatException e) {
                this.lexer.fail("'" + this.currentToken + "' is not a valid string representation of a value of type " + pd.getRequiredType());
            }
            catch (RepositoryException e) {
                this.lexer.fail("An error occured during value conversion of '" + this.currentToken + "'");
            }
            this.nextToken();
        } while (this.currentTokenEquals(','));
        pd.setDefaultValues(defaultValues.toArray(new QValue[defaultValues.size()]));
    }

    private void doPropertyValueConstraints(QNodeTypeDefinitionsBuilder.QPropertyDefinitionBuilder pd) throws ParseException {
        if (!this.currentTokenEquals('<')) {
            return;
        }
        LinkedList<String> constraints = new LinkedList<String>();
        do {
            this.nextToken();
            try {
                constraints.add(pd.createValueConstraint(this.currentToken, this.resolver).getString());
            }
            catch (InvalidConstraintException e) {
                this.lexer.fail("'" + this.currentToken + "' is not a valid constraint expression for a value of type " + pd.getRequiredType());
            }
            this.nextToken();
        } while (this.currentTokenEquals(','));
        pd.setValueConstraints(constraints.toArray(new String[constraints.size()]));
    }

    private void doChildNodeDefinition(QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd, QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        if (this.currentTokenEquals('*')) {
            nd.setName(NameConstants.ANY_NAME);
        } else {
            nd.setName(this.toName(this.currentToken));
        }
        this.nextToken();
        this.doChildNodeRequiredTypes(nd);
        this.doChildNodeDefaultType(nd);
        this.doChildNodeAttributes(nd, ntd);
    }

    private void doChildNodeRequiredTypes(QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd) throws ParseException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        LinkedList<Name> types = new LinkedList<Name>();
        do {
            this.nextToken();
            types.add(this.toName(this.currentToken));
            this.nextToken();
        } while (this.currentTokenEquals(','));
        nd.setRequiredPrimaryTypes(types.toArray(new Name[types.size()]));
        this.nextToken();
    }

    private void doChildNodeDefaultType(QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd) throws ParseException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        this.nextToken();
        nd.setDefaultPrimaryType(this.toName(this.currentToken));
        this.nextToken();
    }

    private void doChildNodeAttributes(QNodeTypeDefinitionsBuilder.QNodeDefinitionBuilder nd, QNodeTypeDefinitionsBuilder.QNodeTypeDefinitionBuilder ntd) throws ParseException {
        while (this.currentTokenEquals(Lexer.NODE_ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                if (ntd.getPrimaryItemName() != null) {
                    String name = null;
                    try {
                        name = this.resolver.getJCRName(ntd.getName());
                    }
                    catch (NamespaceException e) {
                        // empty catch block
                    }
                    this.lexer.fail("More than one primary item specified in node type '" + name + "'");
                }
                ntd.setPrimaryItemName(nd.getName());
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                nd.setAutoCreated(true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                nd.setMandatory(true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                nd.setProtected(true);
            } else if (this.currentTokenEquals(Lexer.SNS)) {
                nd.setAllowsSameNameSiblings(true);
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                nd.setOnParentVersion(1);
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                nd.setOnParentVersion(2);
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                nd.setOnParentVersion(3);
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                nd.setOnParentVersion(4);
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                nd.setOnParentVersion(5);
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                nd.setOnParentVersion(6);
            }
            this.nextToken();
        }
    }

    private Name toName(String stringName) throws ParseException {
        try {
            Name n = this.resolver.getQName(stringName);
            String decodedLocalName = ISO9075.decode((String)n.getLocalName());
            return this.builder.createName(n.getNamespaceURI(), decodedLocalName);
        }
        catch (NameException e) {
            this.lexer.fail("Error while parsing '" + stringName + "'", e);
            return null;
        }
        catch (NamespaceException e) {
            this.lexer.fail("Error while parsing '" + stringName + "'", e);
            return null;
        }
    }

    private void nextToken() throws ParseException {
        this.currentToken = this.lexer.getNextToken();
    }

    private boolean currentTokenEquals(String[] s) {
        for (String value : s) {
            if (!this.currentToken.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    private boolean currentTokenEquals(char c) {
        return this.currentToken.length() == 1 && this.currentToken.charAt(0) == c;
    }

    private boolean currentTokenEquals(String s) {
        return this.currentToken.equals(s);
    }

    static {
        try {
            NS_DEFAULTS = new NamespaceMapping();
            NS_DEFAULTS.setMapping("", "");
            NS_DEFAULTS.setMapping("jcr", "http://www.jcp.org/jcr/1.0");
            NS_DEFAULTS.setMapping("mix", "http://www.jcp.org/jcr/mix/1.0");
            NS_DEFAULTS.setMapping("nt", "http://www.jcp.org/jcr/nt/1.0");
            NS_DEFAULTS.setMapping("rep", "internal");
        }
        catch (NamespaceException e) {
            throw new InternalError(e.toString());
        }
    }
}

